/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.SomlSchema;
import com.ontotext.rdf.transformer.RdfTransformer;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.rdf.transformer.ValueSerializer;
import com.ontotext.rdf.transformer.graphql.DataBuilder;
import com.ontotext.rdf.transformer.graphql.ErrorBuilder;
import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilder;
import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilderFactory;
import com.ontotext.rdf.transformer.graphql.ListNodeBuilder;
import com.ontotext.rdf.transformer.graphql.NodeBuilder;
import com.ontotext.rdf.transformer.graphql.json.EnumAwareValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.ErrorHandler;
import com.ontotext.rdf.transformer.graphql.json.LangStringValueFilter;
import com.ontotext.rdf.transformer.graphql.json.NameLangStringValueConverter;
import com.ontotext.rdf.transformer.graphql.json.ResponseValueFilter;
import com.ontotext.rdf.transformer.graphql.json.TransformState;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.exceptions.PlatformQueryExecutionException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;

class Rdf2GraphQlNodeTransformer
implements RdfTransformer {
    private static final Logger LOGGER = Loggers.graphqlLogger();
    private final SomlSchema schema;
    private final String format;
    private final ValueSerializer valueSerializer;
    private final List<ResponseValueFilter> responseValueFilters = new ArrayList<ResponseValueFilter>();
    private final GraphQlResultBuilderFactory resultBuilderFactory;

    Rdf2GraphQlNodeTransformer(String format, SomlSchema schema, ValueSerializer valueSerializer, GraphQlResultBuilderFactory resultBuilderFactory) {
        this.format = Objects.requireNonNull(format, "The output format is required");
        this.schema = Objects.requireNonNull(schema, "Schema is required for name to IRI conversion");
        this.valueSerializer = new EnumAwareValueSerializer(schema, Objects.requireNonNull(valueSerializer, "Value serializer is required"));
        this.resultBuilderFactory = Objects.requireNonNull(resultBuilderFactory, "Result value builder factory serializer is required");
        this.addDefaultResponseValueFilters();
    }

    private void addDefaultResponseValueFilters() {
        this.responseValueFilters.add(new LangStringValueFilter());
        this.responseValueFilters.add(new NameLangStringValueConverter());
    }

    public Object transform(List<TransformContext> transformContexts, Map<String, Object> options) {
        GraphQlResultBuilder resultBuilder = this.resultBuilderFactory.newBuilder(this.getFormat());
        ErrorHandler errorHandler = ErrorHandler.create(transformContexts, options);
        Function<RdfTree, TransformState> stateBuilder = this.createTransformState(options, errorHandler);
        DataBuilder dataBuilder = resultBuilder.getDataBuilder();
        ErrorBuilder errorBuilder = resultBuilder.getErrorBuilder();
        for (TransformContext transformContext : transformContexts) {
            if (errorHandler.onOperationResponseBegin(transformContext)) {
                TransformState transformState = stateBuilder.apply(transformContext.getData());
                this.transformRootContext(transformContext, transformState, dataBuilder);
                this.addExtensionResults(resultBuilder, transformContext);
            }
            errorHandler.getWarnings().forEach(errorBuilder::addWarning);
            errorHandler.getErrors().forEach(errorBuilder::addError);
        }
        boolean areQueriesValid = errorHandler.areQueriesValid();
        boolean hasAnyValidData = errorHandler.hasAnyValidData();
        if (areQueriesValid) {
            if (!hasAnyValidData) {
                dataBuilder.setToNull();
            }
            dataBuilder.addToParent();
        }
        Object result = resultBuilder.build();
        if (errorBuilder.hasErrors()) {
            Rdf2GraphQlNodeTransformer.logErrors("warnings", errorBuilder.getWarningsAsMap());
            Rdf2GraphQlNodeTransformer.logErrors("errors", errorBuilder.getErrorsAsMap());
        }
        if (!areQueriesValid || !hasAnyValidData) {
            throw new PlatformQueryExecutionException(200, result, errorBuilder.getErrorMessages());
        }
        return result;
    }

    private Function<RdfTree, TransformState> createTransformState(Map<String, Object> options, ErrorHandler errorHandler) {
        boolean nullArrays = this.isConfigEnabled(options, "nullJsonArrays");
        return rdfTree -> new TransformState(this.schema, (RdfTree)rdfTree, this.valueSerializer, this.responseValueFilters, nullArrays, errorHandler);
    }

    private boolean isConfigEnabled(Map<String, Object> options, String configName) {
        Object appLevelConfig = options.getOrDefault(configName, "false");
        Object schemaLevelConfig = this.schema.getConfig().getOrDefault((Object)configName, appLevelConfig);
        return Boolean.parseBoolean(schemaLevelConfig.toString());
    }

    public String getFormat() {
        return this.format;
    }

    private void transformRootContext(TransformContext context, TransformState state, DataBuilder data) {
        Operation operation = context.getOperation();
        RdfTree rdfTree = context.getData();
        state.stepIn((Selectable)operation);
        Collection resultIris = rdfTree.selectResults(operation.getResponseName());
        NodeBuilder nodeBuilder = data.startOperationListResponse(operation.getResponseName());
        try {
            if (operation.isCollection()) {
                this.traverseValues(resultIris, (Selectable)operation, state, (ListNodeBuilder)nodeBuilder);
            } else if (!resultIris.isEmpty()) {
                RdfPath iri = (RdfPath)resultIris.iterator().next();
                if (operation.isComplexType()) {
                    nodeBuilder = data.startOperationResponse(operation.getResponseName());
                    this.traverseComplexNode(iri, (Selectable)operation, state, nodeBuilder);
                } else if (operation.isCountSelection()) {
                    data.removeLastNode();
                    Object countValue = rdfTree.getValueReader().read(iri.getObjectValue());
                    data.put(operation.getResponseName(), countValue);
                } else {
                    data.removeLastNode();
                    this.processNodeValues(iri, (Selectable)operation, state, data);
                }
            }
        }
        catch (NonNullableConstraintViolatedException nncv) {
            nodeBuilder.setToNull();
        }
    }

    private void addExtensionResults(GraphQlResultBuilder resultBuilder, TransformContext transformContext) {
        Map<String, Object> resultExtensions = resultBuilder.getExtensions();
        transformContext.getExtensions().forEach((extension, value) -> resultExtensions.compute((String)extension, CollectionsUtil.mergeValue((Object)value)));
    }

    private void traverseComplexNode(RdfPath currentNode, Selectable parentSelection, TransformState state, NodeBuilder nodeBuilder) throws NonNullableConstraintViolatedException {
        boolean nonNullableErrorDetected = false;
        for (Selectable selection : parentSelection.getSelections()) {
            String responseName = selection.getResponseName();
            if (!state.isSelectionApplicable(currentNode, selection) || nodeBuilder.containsKey(responseName)) continue;
            state.stepIn(selection);
            nonNullableErrorDetected |= this.processNodeValues(currentNode, selection, state, nodeBuilder);
            state.stepOut();
        }
        if (nonNullableErrorDetected) {
            throw new NonNullableConstraintViolatedException();
        }
    }

    private boolean processNodeValues(RdfPath node, Selectable selection, TransformState state, NodeBuilder result) throws NonNullableConstraintViolatedException {
        List<Object> values = state.getValues(node, selection);
        boolean noData = Rdf2GraphQlNodeTransformer.hasNoData(values, selection);
        String responseName = selection.getResponseName();
        if (noData && selection.getName().equals("__typename")) {
            if (selection.getDefinedInType().isAbstract() && selection.isSubscription()) {
                LOGGER.debug("Trying to insert abstract type {} into subscription result for node {}.", (Object)selection.getDefinedIn(), (Object)node);
                return true;
            }
            noData = false;
            values = Collections.singletonList(selection.getDefinedIn());
        }
        if (noData) {
            if (Rdf2GraphQlNodeTransformer.isNonNullable(selection, state)) {
                return true;
            }
            result.put(responseName, state.getNullValue(selection));
        } else if (state.isDataValidForThisSelection(node, selection)) {
            this.computeSelectionValue(node, selection, values, state, result);
        }
        return false;
    }

    private static boolean hasNoData(List<Object> values, Selectable selection) {
        if (!selection.isCollection()) {
            Iterator<Object> it = values.iterator();
            boolean hasNext = it.hasNext();
            if (!hasNext) {
                return true;
            }
            return it.next() == null;
        }
        return values.isEmpty();
    }

    private void computeSelectionValue(RdfPath currentNode, Selectable selection, List<Object> values, TransformState state, NodeBuilder result) throws NonNullableConstraintViolatedException {
        if (selection.isIgnored()) {
            result.put(selection.getResponseName(), state.getNullValue(selection));
            return;
        }
        Rdf2GraphQlNodeTransformer.verifySingleResultForSingleValueProperty(values, selection, state);
        if (!selection.isComplexType()) {
            Object value2 = state.filterSimpleValue(selection, values);
            result.put(selection.getResponseName(), value2);
            return;
        }
        if (selection.isCollection()) {
            String predicate = state.computePredicate(selection);
            List valuePaths = values.stream().map(value -> currentNode.add(predicate, value)).collect(Collectors.toList());
            ListNodeBuilder listNodeBuilder = result.addNestedListValue(selection.getResponseName());
            Rdf2GraphQlNodeTransformer.resolveResult(valuePaths, selection, state, listNodeBuilder, this::traverseValues);
            return;
        }
        Object value3 = values.get(0);
        if (value3 instanceof Map) {
            Map map = (Map)value3;
            NodeBuilder nodeBuilder = result.addNestedValue(selection.getResponseName());
            Rdf2GraphQlNodeTransformer.resolveResult(map, selection, state, nodeBuilder, this::traverseComplexValue);
        } else if (value3 != null) {
            String predicate = state.computePredicate(selection);
            RdfPath valuePath = currentNode.add(predicate, value3);
            NodeBuilder nodeBuilder = result.addNestedValue(selection.getResponseName());
            Rdf2GraphQlNodeTransformer.resolveResult(valuePath, selection, state, nodeBuilder, this::traverseComplexNode);
        }
    }

    private static void verifySingleResultForSingleValueProperty(List<Object> values, Selectable selection, TransformState state) {
        int size = values.size();
        if (size > 1 && !selection.isCollection() && !"__typename".equals(selection.getName()) && new HashSet<Object>(values).size() != 1) {
            state.getErrorHandler().onSingleValueViolationError(size, selection, state.getPath());
        }
    }

    private static <D, N extends NodeBuilder> void resolveResult(D data, Selectable selection, TransformState state, N nodeBuilder, NonNullableResolver<D, N> resultSupplier) throws NonNullableConstraintViolatedException {
        try {
            resultSupplier.get(data, selection, state, nodeBuilder);
        }
        catch (NonNullableConstraintViolatedException constraintExc) {
            if (selection.isNonNullable() && !selection.isIgnored()) {
                state.getErrorHandler().onRequiredFieldWithoutValueError(selection, state.getPath());
                throw constraintExc;
            }
            nodeBuilder.setToNull();
        }
    }

    private void traverseComplexValue(Map<String, Object> valueMap, Selectable parentSelection, TransformState state, NodeBuilder nodeBuilder) throws NonNullableConstraintViolatedException {
        boolean propagateToParent = false;
        for (Selectable selection : parentSelection.getSelections()) {
            if (!selection.isRequestedByUser()) continue;
            state.stepIn(selection);
            Object value = valueMap.get(selection.getName());
            String responseName = selection.getResponseName();
            if (value == null) {
                if (Rdf2GraphQlNodeTransformer.isNonNullable(selection, state)) {
                    propagateToParent = true;
                } else {
                    nodeBuilder.put(responseName, state.getNullValue(selection));
                }
            } else {
                nodeBuilder.put(responseName, value);
            }
            state.stepOut();
        }
        if (propagateToParent) {
            throw new NonNullableConstraintViolatedException();
        }
    }

    private void traverseValues(Collection<RdfPath> values, Selectable selection, TransformState state, ListNodeBuilder listNodeBuilder) throws NonNullableConstraintViolatedException {
        listNodeBuilder.resize(values.size());
        int index = 0;
        boolean propagateToParent = false;
        for (RdfPath pathNode : values) {
            state.stepIn(index++);
            Object value = pathNode.getObjectValue();
            NodeBuilder subItem = listNodeBuilder.newListItem();
            try {
                if (value instanceof Map) {
                    Map map = (Map)value;
                    this.traverseComplexValue(map, selection, state, subItem);
                } else if (value != null) {
                    this.traverseComplexNode(pathNode, selection, state, subItem);
                }
            }
            catch (NonNullableConstraintViolatedException nncv) {
                propagateToParent |= selection.isNonNullableElements();
                subItem.setToNull();
            }
            state.stepOut();
        }
        if (propagateToParent) {
            throw new NonNullableConstraintViolatedException();
        }
    }

    private static boolean isNonNullable(Selectable selection, TransformState state) {
        if (selection.isNonNullable() && !selection.isIgnored() && !selection.hasConstraints() || Rdf2GraphQlNodeTransformer.isLangFromLangString(selection)) {
            state.getErrorHandler().onRequiredFieldWithoutValueError(selection, state.getPath());
            return true;
        }
        return false;
    }

    private static boolean isLangFromLangString(Selectable selection) {
        if (!"lang".equals(selection.getName()) && !"Literal".equals(selection.getDefinedIn())) {
            return false;
        }
        return selection.getParent().getProperty().filter(PropertyShape::isScalarType).filter(property -> property.getScalarType().isLangStringExclusive()).isPresent();
    }

    private static void logErrors(String type, List<Map<String, Object>> errors) {
        if (LOGGER.isWarnEnabled() && !errors.isEmpty()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String errorString = objectMapper.writeValueAsString(errors);
                LOGGER.warn("Finishing request with {}: {}", (Object)type, (Object)errorString);
            }
            catch (JsonProcessingException jpe) {
                throw new IllegalStateException(jpe);
            }
        }
    }

    private static class NonNullableConstraintViolatedException
    extends Exception {
        private static final long serialVersionUID = 4570946251833805969L;

        private NonNullableConstraintViolatedException() {
        }
    }

    @FunctionalInterface
    private static interface NonNullableResolver<D, N> {
        public void get(D var1, Selectable var2, TransformState var3, N var4) throws NonNullableConstraintViolatedException;
    }
}

