/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.SomlSchema;
import com.ontotext.rdf.transformer.RdfTransformer;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.rdf.transformer.ValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.EnumAwareValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.ErrorHandler;
import com.ontotext.rdf.transformer.graphql.json.LangStringValueFilter;
import com.ontotext.rdf.transformer.graphql.json.NameLangStringValueConverter;
import com.ontotext.rdf.transformer.graphql.json.ResponseValueFilter;
import com.ontotext.rdf.transformer.graphql.json.TransformState;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.exceptions.PlatformQueryExecutionException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Deprecated
class Rdf2GraphQlJsonTransformer
implements RdfTransformer {
    private static final Logger LOGGER = Loggers.graphqlLogger();
    private final SomlSchema schema;
    private final String format;
    private final ValueSerializer valueSerializer;
    private final List<ResponseValueFilter> responseValueFilters = new ArrayList<ResponseValueFilter>();

    Rdf2GraphQlJsonTransformer(String format, SomlSchema schema, ValueSerializer valueSerializer) {
        this.format = Objects.requireNonNull(format, "The output format is required");
        this.schema = Objects.requireNonNull(schema, "Schema is required for name to IRI conversion");
        this.valueSerializer = new EnumAwareValueSerializer(schema, Objects.requireNonNull(valueSerializer, "Value serializer is required"));
        this.addDefaultResponseValueFilters();
    }

    private void addDefaultResponseValueFilters() {
        this.responseValueFilters.add(new LangStringValueFilter());
        this.responseValueFilters.add(new NameLangStringValueConverter());
    }

    public Object transform(List<TransformContext> transformContexts, Map<String, Object> options) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
        int transformCtxSize = transformContexts.size();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(transformCtxSize);
        LinkedList<Map<String, Object>> errors = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> warnings = new LinkedList<Map<String, Object>>();
        ErrorHandler errorHandler = ErrorHandler.create(transformContexts, options);
        Function<RdfTree, TransformState> stateBuilder = this.createTransformState(options, errorHandler);
        for (TransformContext transformContext : transformContexts) {
            if (errorHandler.onOperationResponseBegin(transformContext)) {
                TransformState transformState = stateBuilder.apply(transformContext.getData());
                this.transformRootContext(transformContext, transformState, data);
            }
            warnings.addAll(errorHandler.getWarnings());
            errors.addAll(errorHandler.getErrors());
        }
        errors.addAll(warnings);
        this.addErrorsToResult(errors, result, errorHandler);
        boolean areQueriesValid = errorHandler.areQueriesValid();
        boolean hasAnyValidData = errorHandler.hasAnyValidData();
        if (areQueriesValid) {
            if (hasAnyValidData) {
                result.put("data", data);
            } else {
                result.put("data", null);
            }
        }
        if (!areQueriesValid || !hasAnyValidData) {
            List errorMessages = errors.stream().map(error -> error.get("message")).map(Object::toString).collect(Collectors.toList());
            throw new PlatformQueryExecutionException(200, result, errorMessages);
        }
        return result;
    }

    private Function<RdfTree, TransformState> createTransformState(Map<String, Object> options, ErrorHandler errorHandler) {
        boolean nullArrays = this.isConfigEnabled(options, "nullJsonArrays");
        return rdfTree -> new TransformState(this.schema, (RdfTree)rdfTree, this.valueSerializer, this.responseValueFilters, nullArrays, errorHandler);
    }

    private boolean isConfigEnabled(Map<String, Object> options, String configName) {
        Object appLevelConfig = options.getOrDefault(configName, "false");
        Object schemaLevelConfig = this.schema.getConfig().getOrDefault((Object)configName, appLevelConfig);
        return Boolean.parseBoolean(schemaLevelConfig.toString());
    }

    public String getFormat() {
        return this.format;
    }

    private void addErrorsToResult(List<Map<String, Object>> messages, Map<String, Object> result, ErrorHandler errorHandler) {
        if (!messages.isEmpty()) {
            result.put("errors", messages);
            errorHandler.logErrors(messages);
        }
    }

    private void transformRootContext(TransformContext context, TransformState state, Map<String, Object> data) {
        boolean nullRootData;
        Object localData;
        Operation operation;
        block6: {
            operation = context.getOperation();
            RdfTree rdfTree = context.getData();
            state.stepIn((Selectable)operation);
            localData = Collections.emptyList();
            Collection resultIris = rdfTree.selectResults(operation.getResponseName());
            nullRootData = false;
            try {
                if (operation.isCollection()) {
                    localData = this.traverseValues(resultIris, (Selectable)operation, state);
                    break block6;
                }
                if (resultIris.isEmpty()) break block6;
                RdfPath iri = (RdfPath)resultIris.iterator().next();
                if (operation.isComplexType()) {
                    localData = this.traverseComplexNode(iri, (Selectable)operation, state);
                    break block6;
                }
                this.processNodeValues(iri, (Selectable)operation, state, data);
                return;
            }
            catch (NonNullableConstraintViolatedException nncv) {
                nullRootData = true;
                Object object = localData = operation.isCollection() ? Collections.emptyList() : null;
            }
        }
        if (nullRootData) {
            data.put(operation.getResponseName(), localData);
        } else {
            data.compute(operation.getResponseName(), CollectionsUtil.mergeValue(localData));
        }
    }

    private Map<String, Object> traverseComplexNode(RdfPath currentNode, Selectable parentSelection, TransformState state) throws NonNullableConstraintViolatedException {
        LinkedHashMap<String, Object> resultItem = new LinkedHashMap<String, Object>();
        boolean nonNullableErrorDetected = false;
        for (Selectable selection : parentSelection.getSelections()) {
            if (!state.isSelectionApplicable(currentNode, selection) || resultItem.containsKey(selection.getResponseName())) continue;
            state.stepIn(selection);
            nonNullableErrorDetected |= this.processNodeValues(currentNode, selection, state, resultItem);
            state.stepOut();
        }
        if (nonNullableErrorDetected) {
            throw new NonNullableConstraintViolatedException();
        }
        return resultItem;
    }

    private boolean processNodeValues(RdfPath node, Selectable selection, TransformState state, Map<String, Object> result) throws NonNullableConstraintViolatedException {
        List<Object> values = state.getValues(node, selection);
        String responseName = selection.getResponseName();
        boolean noData = Rdf2GraphQlJsonTransformer.hasNoData(values, selection);
        if (noData && selection.getName().equals("__typename")) {
            if (selection.getDefinedInType().isAbstract() && selection.isSubscription()) {
                LOGGER.debug("Trying to insert abstract type {} into subscription result for node {}.", (Object)selection.getDefinedIn(), (Object)node);
                return true;
            }
            values = Collections.singletonList(selection.getDefinedIn());
            noData = false;
        }
        if (noData) {
            if (this.isNonNullable(selection, state)) {
                return true;
            }
            result.put(responseName, state.getNullValue(selection));
        } else if (state.isDataValidForThisSelection(node, selection)) {
            Object selectionValue = this.computeSelectionValue(node, selection, values, state);
            result.put(responseName, selectionValue);
        }
        return false;
    }

    private static boolean hasNoData(List<Object> values, Selectable selection) {
        if (selection.isCollection()) {
            return values.isEmpty();
        }
        Iterator<Object> it = values.iterator();
        boolean hasNext = it.hasNext();
        if (!hasNext) {
            return true;
        }
        return it.next() == null;
    }

    private Object computeSelectionValue(RdfPath currentNode, Selectable selection, List<Object> values, TransformState state) throws NonNullableConstraintViolatedException {
        if (selection.isIgnored()) {
            return selection.isCollection() ? Collections.emptyList() : null;
        }
        this.verifySingleResultForSingleValueProperty(values, selection, state);
        if (!selection.isComplexType()) {
            return state.filterSimpleValue(selection, values);
        }
        if (selection.isCollection()) {
            String predicate = state.computePredicate(selection);
            List valuePaths = values.stream().map(value -> currentNode.add(predicate, value)).collect(Collectors.toList());
            return this.resolveResult(valuePaths, selection, state, this::traverseValues);
        }
        Map selectionValue = null;
        Object value2 = values.get(0);
        if (value2 instanceof Map) {
            Map map = (Map)value2;
            selectionValue = this.resolveResult(map, selection, state, this::traverseComplexValue);
        } else if (value2 != null) {
            String predicate = state.computePredicate(selection);
            RdfPath valuePath = currentNode.add(predicate, value2);
            selectionValue = this.resolveResult(valuePath, selection, state, this::traverseComplexNode);
        }
        return selectionValue;
    }

    private void verifySingleResultForSingleValueProperty(List<Object> values, Selectable selection, TransformState state) {
        int size = values.size();
        if (size > 1 && !selection.isCollection() && !"__typename".equals(selection.getName())) {
            state.getErrorHandler().onSingleValueViolationError(size, selection, state.getPath());
        }
    }

    private <D, R> R resolveResult(D data, Selectable selection, TransformState state, NonNullableResolver<D, R> resultSupplier) throws NonNullableConstraintViolatedException {
        try {
            return resultSupplier.get(data, selection, state);
        }
        catch (NonNullableConstraintViolatedException constraintExc) {
            if (selection.isNonNullable() && !selection.isIgnored()) {
                state.getErrorHandler().onRequiredFieldWithoutValueError(selection, state.getPath());
                throw constraintExc;
            }
            return null;
        }
    }

    private Map<String, Object> traverseComplexValue(Map<String, Object> valueMap, Selectable parentSelection, TransformState state) throws NonNullableConstraintViolatedException {
        LinkedHashMap<String, Object> resultItem = new LinkedHashMap<String, Object>();
        boolean propagateToParent = false;
        for (Selectable selection : parentSelection.getSelections()) {
            if (!selection.isRequestedByUser()) continue;
            state.stepIn(selection);
            String responseName = selection.getResponseName();
            Object value = valueMap.get(selection.getName());
            if (value == null) {
                if (this.isNonNullable(selection, state)) {
                    propagateToParent = true;
                } else {
                    resultItem.put(responseName, state.getNullValue(selection));
                }
            } else {
                resultItem.put(responseName, value);
            }
            state.stepOut();
        }
        if (propagateToParent) {
            throw new NonNullableConstraintViolatedException();
        }
        return resultItem;
    }

    private List<Map<String, Object>> traverseValues(Collection<RdfPath> values, Selectable selection, TransformState state) throws NonNullableConstraintViolatedException {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(values.size());
        int index = 0;
        boolean propagateToParent = false;
        for (RdfPath pathNode : values) {
            state.stepIn(index++);
            Object value = pathNode.getObjectValue();
            Map<String, Object> subItem = null;
            try {
                if (value instanceof Map) {
                    Map map = (Map)value;
                    subItem = this.traverseComplexValue(map, selection, state);
                } else if (value != null) {
                    subItem = this.traverseComplexNode(pathNode, selection, state);
                }
            }
            catch (NonNullableConstraintViolatedException nncv) {
                propagateToParent |= selection.isNonNullableElements();
                subItem = null;
            }
            items.add(subItem);
            state.stepOut();
        }
        if (propagateToParent) {
            throw new NonNullableConstraintViolatedException();
        }
        return items;
    }

    private boolean isNonNullable(Selectable selection, TransformState state) {
        if (selection.isNonNullable() && !selection.isIgnored() && !selection.hasConstraints() || this.isLangFromLangString(selection)) {
            state.getErrorHandler().onRequiredFieldWithoutValueError(selection, state.getPath());
            return true;
        }
        return false;
    }

    private boolean isLangFromLangString(Selectable selection) {
        if (!"lang".equals(selection.getName()) && !"Literal".equals(selection.getDefinedIn())) {
            return false;
        }
        return selection.getParent().getProperty().filter(PropertyShape::isScalarType).filter(property -> property.getScalarType().isLangStringExclusive()).isPresent();
    }

    private static class NonNullableConstraintViolatedException
    extends Exception {
        private static final long serialVersionUID = 4570946251833805969L;

        private NonNullableConstraintViolatedException() {
        }
    }

    @FunctionalInterface
    private static interface NonNullableResolver<D, T> {
        public T get(D var1, Selectable var2, TransformState var3) throws NonNullableConstraintViolatedException;
    }
}

