/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.Selectable;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.rdf.transformer.SerializationError;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.rdf.transformer.graphql.json.ErrorHandler;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class CompactErrorHandler
extends ErrorHandler {
    private boolean mutationOperations;
    private boolean missingRequiredFieldValueError;
    private boolean serializationError;
    private boolean singleValueViolationError;
    private boolean securityError;

    CompactErrorHandler() {
    }

    @Override
    public boolean onOperationResponseBegin(TransformContext transformContext) {
        this.onNewOperation();
        LinkedList<Map<String, Object>> initialWarnings = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> initialErrors = new LinkedList<Map<String, Object>>();
        this.mutationOperations = transformContext.getOperation() instanceof Mutation;
        boolean operationPossible = CompactErrorHandler.isOperationPossible(transformContext, this.dataValidation::add, this.queryValidation::add, initialWarnings::add, initialErrors::add);
        this.aggregateInitialErrors(initialErrors);
        this.aggregateInitialWarnings(initialWarnings);
        return operationPossible;
    }

    void aggregateInitialErrors(List<Map<String, Object>> errors) {
        for (Map<String, Object> error : errors) {
            if (CompactErrorHandler.isSecurityError(error)) {
                if (this.securityError) continue;
                this.securityError = true;
                this.onError(this.createSecurityMessage(true));
                continue;
            }
            this.onError(error);
        }
    }

    void aggregateInitialWarnings(List<Map<String, Object>> warnings) {
        for (Map<String, Object> warn : warnings) {
            if (CompactErrorHandler.isSecurityError(warn)) {
                if (this.securityError) continue;
                this.securityError = true;
                this.onWarning(this.createSecurityMessage(false));
                continue;
            }
            this.onWarning(warn);
        }
    }

    private Map<String, Object> createSecurityMessage(boolean isError) {
        if (this.mutationOperations && isError) {
            return this.createMessage("compact.error.message.mutationSecurityChecks");
        }
        return this.createMessage("compact.error.message.securityChecks");
    }

    private static boolean isSecurityError(Map<String, Object> error) {
        String message = Objects.toString(error.get("message"), null);
        if (message == null) {
            return false;
        }
        return message.startsWith("You have limited") || message.startsWith("You have no permission") || message.startsWith("Restricted an") || message.contains(" is constrained to ") || message.startsWith("Cannot calculate the permissions") || message.contains("queried without permissions") || message.contains("has been prevented as the selected objects") || message.contains("has been roll-backed as the objects of type");
    }

    @Override
    public void onRequiredFieldWithoutValueError(Selectable selection, Deque<Object> path) {
        if (this.missingRequiredFieldValueError) {
            return;
        }
        this.missingRequiredFieldValueError = true;
        this.onError(this.createMessage("compact.error.message.missingRequiredField"));
    }

    @Override
    public void onSerializationError(SerializationError error, Selectable selection, Deque<Object> path) {
        if (this.serializationError) {
            return;
        }
        this.serializationError = true;
        this.onError(this.createMessage("compact.error.message.serializationError"));
    }

    @Override
    public void onSingleValueViolationError(int valuesSize, Selectable selection, Deque<Object> path) {
        if (this.singleValueViolationError) {
            return;
        }
        this.singleValueViolationError = true;
        this.onError(this.createMessage("compact.error.message.multipleValuesError"));
    }

    private Map<String, Object> createMessage(String templateId) {
        return Map.of("message", ErrorMessages.get((String)templateId));
    }
}

