/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.java;

import com.google.common.collect.ImmutableSet;
import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilder;
import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilderFactory;
import com.ontotext.rdf.transformer.graphql.java.JavaGraphqlResultBuilder;
import java.util.Set;

public class JavaGraphQlResultBuilderFactory
implements GraphQlResultBuilderFactory {
    private static final Set<String> SUPPORTED_MIME_TYPES = ImmutableSet.of((Object)"application/json", (Object)"application/graphql");

    @Override
    public GraphQlResultBuilder newBuilder(String mimeType) {
        if (SUPPORTED_MIME_TYPES.contains(mimeType)) {
            return new JavaGraphqlResultBuilder();
        }
        throw new IllegalArgumentException(String.format("The given mimeTime %s is not supported! Supported are: %s", mimeType, String.join((CharSequence)", ", SUPPORTED_MIME_TYPES)));
    }

    @Override
    public Set<String> getSupportedMimeTypes() {
        return SUPPORTED_MIME_TYPES;
    }
}

