/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql;

import com.ontotext.rdf.transformer.graphql.GraphQlError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ErrorBuilder {
    public List<GraphQlError> getErrors();

    default public List<Map<String, Object>> getErrorsAsMap() {
        return this.getErrors().stream().map(GraphQlError::asMap).collect(Collectors.toList());
    }

    public List<GraphQlError> getWarnings();

    default public List<Map<String, Object>> getWarningsAsMap() {
        return this.getWarnings().stream().map(GraphQlError::asMap).collect(Collectors.toList());
    }

    public void addError(GraphQlError var1);

    default public void addError(Map<String, Object> error) {
        this.addError(new GraphQlError(error));
    }

    public void addWarning(GraphQlError var1);

    default public void addWarning(Map<String, Object> error) {
        this.addWarning(new GraphQlError(error));
    }

    default public List<Map<String, Object>> getAllErrorsAsMap() {
        return Stream.concat(this.getErrorsAsMap().stream(), this.getWarningsAsMap().stream()).collect(Collectors.toList());
    }

    default public List<GraphQlError> getAllErrors() {
        List<GraphQlError> errors = this.getErrors();
        List<GraphQlError> warnings = this.getWarnings();
        ArrayList<GraphQlError> allErrors = new ArrayList<GraphQlError>(errors.size() + warnings.size());
        allErrors.addAll(errors);
        allErrors.addAll(warnings);
        return allErrors;
    }

    default public List<String> getErrorMessages() {
        return this.getAllErrors().stream().map(GraphQlError::getMessage).collect(Collectors.toList());
    }

    default public List<GraphQlError> build() {
        return this.getAllErrors();
    }

    public boolean hasErrors();
}

