/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql;

import com.ontotext.rdf.transformer.graphql.ListNodeBuilder;
import com.ontotext.rdf.transformer.graphql.NodeBuilder;

public abstract class BaseNodeBuilder<P extends BaseNodeBuilder<P>>
implements NodeBuilder {
    static final Object NOT_SET = new Object();
    protected final P parentNodeBuilder;
    private final String name;
    protected boolean isNull;
    protected NodeBuilder lastNodeBuilder;

    public BaseNodeBuilder(P parent, String name) {
        this.parentNodeBuilder = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NodeBuilder addNestedValue(String key) {
        this.addLastValue();
        this.lastNodeBuilder = this.newNodeBuilder(key);
        return this.lastNodeBuilder;
    }

    protected abstract NodeBuilder newNodeBuilder(String var1);

    @Override
    public ListNodeBuilder addNestedListValue(String key) {
        this.addLastValue();
        this.lastNodeBuilder = this.newListNodeBuilder(key);
        return (ListNodeBuilder)this.lastNodeBuilder;
    }

    protected abstract ListNodeBuilder newListNodeBuilder(String var1);

    protected void addLastValue() {
        if (this.lastNodeBuilder != null) {
            NodeBuilder localBuilder = this.lastNodeBuilder;
            this.lastNodeBuilder = null;
            localBuilder.addToParent();
        }
    }

    @Override
    public void setToNull() {
        this.isNull = true;
    }

    @Override
    public void addToParent() {
        if (this.parentNodeBuilder == null) {
            return;
        }
        Object value = this.build();
        if (value == NOT_SET) {
            return;
        }
        if (this.parentNodeBuilder instanceof ListNodeBuilder) {
            ((ListNodeBuilder)this.parentNodeBuilder).add(value);
        } else {
            this.parentNodeBuilder.put(this.getName(), value);
        }
    }

    @Override
    public void removeLastNode() {
        this.lastNodeBuilder = null;
    }
}

