/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.querymodel.Exists;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.sparql.ConsumingTupleQueryResultHandler;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.DataRetrievalRequest;
import com.ontotext.validator.data.DataRetrievalResponse;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;

public class PropertyMaxCardinalityValidationStep
implements ValidationStep,
DisplayableValidation,
OffendingValidationDataRetrieval {
    public static final String NAME = "propertyMaxCardinality";
    private static final String SUBJECT = "subject";
    private static final String VALUE = "value";
    private static final String CONTEXT = "context";

    @Override
    public boolean accept(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return propertyShape != null && !"id".equals(propertyShape.getName()) && !"name".equals(propertyShape.getName()) && "1".equals(propertyShape.getMax());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void validate(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        Var subject = new Var(SUBJECT);
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, subject);
        Value propertyPredicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        Var value = new Var(VALUE);
        sparqlNodes.addAll(ValidationStepUtil.createIsMultiValueCheck((Value)subject, propertyPredicate, value));
        String question = ValidationStepUtil.createAskQuery(schema, sparqlNodes);
        if (ValidationStepUtil.ask(dataEndpoint, validation, question).isYes()) {
            validation.addResultMessage("validations.max-cardinality", validation.getObjectType(), validation.getPropertyName());
            validation.setTaskStatus(Task.TaskStatus.WARN);
        }
    }

    @Override
    public String getViewQuery(SomlSchema schema, ValidationTask validation) {
        SelectQuery selectQuery = this.buildViewQuery(schema, validation, false);
        selectQuery.setLimit(Long.valueOf(100L));
        return SparqlUtil.prettyPrint((String)selectQuery.toSparql());
    }

    @Override
    public DataRetrievalResponse loadData(DataRetrievalRequest request) {
        SomlSchema schema = request.getSchema();
        ValidationTask validation = request.getValidation();
        SelectQuery query = this.buildViewQuery(schema, validation, true);
        DataRetrievalResponse response = new DataRetrievalResponse();
        ConsumingTupleQueryResultHandler resultHandler = new ConsumingTupleQueryResultHandler(ValidationStepUtil.readBindings(response::addResultEntry, SUBJECT, VALUE, null, CONTEXT));
        ValidationStepUtil.select(request.getDataEndpoint(), request.getValidation(), query, request.getLimit(), request.getOffset(), (TupleQueryResultHandler)resultHandler, true);
        return response;
    }

    @NotNull
    protected SelectQuery buildViewQuery(SomlSchema schema, ValidationTask validation, boolean lateral) {
        Var subject = new Var(SUBJECT);
        Var value = new Var(VALUE);
        Var graph = new Var(CONTEXT);
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, subject);
        Value propertyPredicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        sparqlNodes.add((SparqlNode)new Filter((SparqlNode)new Exists((SparqlNode)new SparqlNodeSequence(ValidationStepUtil.createIsMultiValueCheck((Value)subject, propertyPredicate, value)))));
        PatternNode propertyMatch = PatternNode.createPattern((Value)subject, (Value)propertyPredicate, (Value)value);
        if (lateral) {
            ArrayList<SparqlNode> subqueryNodes = new ArrayList<SparqlNode>();
            subqueryNodes.add((SparqlNode)propertyMatch);
            subqueryNodes.add((SparqlNode)new Optional((SparqlNode)new NamedGraphTriplePatternBlock((Value)graph).addNode((SparqlNode)propertyMatch)));
            SelectQuery query = ValidationStepUtil.createSelectQuery(schema, subqueryNodes);
            query.getProjectionSegment().add(subject);
            query.getProjectionSegment().add(value);
            query.getProjectionSegment().add(graph);
            query.convertToSubSelect();
            query.setValues(new Values(subject));
            sparqlNodes.add((SparqlNode)query);
        } else {
            sparqlNodes.add((SparqlNode)propertyMatch);
            sparqlNodes.add((SparqlNode)new Optional((SparqlNode)new NamedGraphTriplePatternBlock((Value)graph).addNode((SparqlNode)propertyMatch)));
        }
        SelectQuery query = ValidationStepUtil.createSelectQuery(schema, sparqlNodes);
        query.getProjectionSegment().add(subject);
        query.getProjectionSegment().add(value);
        query.getProjectionSegment().add(graph);
        return query;
    }
}

