/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.ErrorMessages;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.ValidationSteps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValidationTask
implements Task {
    private String id;
    private int order;
    private String validatorName;
    private String objectType;
    private String propertyName;
    private Task.TaskStatus status;
    private Long duration;
    private List<String> result;
    private Map<String, Object> validatorConfig;
    private List<Object> violations;

    public ValidationTask() {
    }

    public ValidationTask(String id) {
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.getValidatorName();
    }

    public String getValidatorName() {
        return this.validatorName;
    }

    public void setValidatorName(String validatorName) {
        this.validatorName = validatorName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Task.TaskStatus getTaskStatus() {
        return this.status;
    }

    public void setTaskStatus(Task.TaskStatus status) {
        this.status = status;
    }

    public List<String> getResult() {
        return this.result;
    }

    public void setResult(List<String> result) {
        this.result = result;
    }

    public Map<String, Object> getValidatorConfig() {
        return this.validatorConfig;
    }

    public void setValidatorConfig(Map<String, Object> validatorConfig) {
        this.validatorConfig = validatorConfig;
    }

    public void addResult(String resultEntry) {
        if (this.result == null) {
            this.result = new ArrayList<String>();
        }
        this.result.add(resultEntry);
    }

    public void addResultMessage(String messageTemplate, Object ... args) {
        this.addResult(ErrorMessages.get((String)messageTemplate, (Object[])args));
    }

    public int getTaskOrder() {
        return this.order;
    }

    public void setTaskOrder(int order) {
        this.order = order;
    }

    public Long getEvaluationDuration() {
        return this.duration;
    }

    public void setEvaluationDuration(Long duration) {
        this.duration = duration;
    }

    public boolean isQueryable() {
        return ValidationSteps.isQueryable(this.getValidatorName());
    }

    public boolean isDataQueryable() {
        return ValidationSteps.isDataQueryable(this.getValidatorName());
    }

    public Map<String, Object> asJson() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.getId());
        map.put("validatorName", this.getValidatorName());
        map.put("objectType", this.getObjectType());
        map.put("propertyName", this.getPropertyName());
        map.put("status", this.getTaskStatus());
        map.put("queryable", this.isQueryable());
        if (this.getEvaluationDuration() != null) {
            map.put("durationInMs", this.getEvaluationDuration());
        }
        map.put("result", this.getResult());
        if (this.violations != null) {
            map.put("violations", this.violations);
        }
        return map;
    }

    public ValidationTask copy() {
        ValidationTask copy = new ValidationTask();
        copy.id = this.id;
        copy.order = this.order;
        copy.validatorName = this.validatorName;
        copy.objectType = this.objectType;
        copy.propertyName = this.propertyName;
        copy.status = this.status;
        copy.duration = this.duration;
        if (this.result != null) {
            copy.result = new ArrayList<String>(this.result);
        }
        if (this.violations != null) {
            copy.violations = new ArrayList<Object>(this.violations);
        }
        if (this.validatorConfig != null) {
            copy.validatorConfig = new LinkedHashMap<String, Object>(this.validatorConfig);
        }
        return copy;
    }

    public String toString() {
        return String.format("ValidationTask{id='%s', order=%d, validatorName='%s', objectType='%s', propertyName='%s', status=%s, duration=%d, result=%s, violations=%d, validatorConfig=%s}", this.id, this.order, this.validatorName, this.objectType, this.propertyName, this.status, this.duration, this.result, this.violations == null ? -1 : this.violations.size(), this.validatorConfig);
    }

    public List<Object> getViolations() {
        return this.violations;
    }

    public void setViolations(List<Object> violations) {
        this.violations = violations;
    }
}

