/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationJobReport;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationTask;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ValidationManagerAdapter
implements ValidationManager {
    protected final ValidationManager delegate;

    public ValidationManagerAdapter(ValidationManager delegate) {
        this.delegate = Objects.requireNonNull(delegate, "ValidationManager delegate should not be null");
    }

    @Override
    public ValidationJob validate(SomlSchema schema, Set<String> types, Set<String> properties, Set<String> validations, String repository) {
        return this.delegate.validate(schema, types, properties, validations, repository);
    }

    @Override
    public boolean removeValidation(String schemaId) {
        return this.delegate.removeValidation(schemaId);
    }

    @Override
    public boolean removeValidationById(String jobId) {
        return this.delegate.removeValidationById(jobId);
    }

    @Override
    public Optional<ValidationJob> cancelValidation(String schemaId) {
        return this.delegate.cancelValidation(schemaId);
    }

    @Override
    public Optional<ValidationJob> cancelValidationById(String jobId) {
        return this.delegate.cancelValidationById(jobId);
    }

    @Override
    public Optional<ValidationJobReport> getValidationReport(String schemaId, boolean failedOnly, long limit, long offset) {
        return this.delegate.getValidationReport(schemaId, failedOnly, limit, offset);
    }

    @Override
    public Optional<ValidationJobReport> getValidationReportById(String jobId, boolean failedOnly, long limit, long offset) {
        return this.delegate.getValidationReportById(jobId, failedOnly, limit, offset);
    }

    @Override
    public Optional<ValidationJob> getValidation(String schemaId) {
        return this.delegate.getValidation(schemaId);
    }

    @Override
    public Optional<ValidationTask> getValidationTask(String schemaId, String taskId) {
        return this.delegate.getValidationTask(schemaId, taskId);
    }

    @Override
    public void updateJob(String schemaId, List<ValidationTask> toUpdate) {
        this.delegate.updateJob(schemaId, toUpdate);
    }

    @Override
    public List<ValidationTask> getNextTasks(String schemaId, int numberOfTasks) {
        return this.delegate.getNextTasks(schemaId, numberOfTasks);
    }

    public void addJobListener(JobListener jobEventConsumer) {
        this.delegate.addJobListener(jobEventConsumer);
    }

    public void removeJobListener(JobListener jobEventConsumer) {
        this.delegate.removeJobListener(jobEventConsumer);
    }

    @Override
    public boolean continueValidationJobs() {
        return this.delegate.continueValidationJobs();
    }

    @Override
    public void setSchemaLoader(Function<String, SomlSchema> schemaLoader) {
        this.delegate.setSchemaLoader(schemaLoader);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public boolean isJobDone(String jobId) {
        return this.delegate.isJobDone(jobId);
    }

    @Override
    public void disableDataLoading() {
        this.delegate.disableDataLoading();
    }

    @Override
    public boolean isDataLoadingEnabled() {
        return this.delegate.isDataLoadingEnabled();
    }

    public HealthResult runHealthCheck() {
        return this.delegate.runHealthCheck();
    }
}

