/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.escalon.hypermedia.hydra.mapping.Expose;
import de.escalon.hypermedia.hydra.mapping.Term;
import de.escalon.hypermedia.hydra.mapping.Terms;
import de.escalon.hypermedia.hydra.mapping.Vocab;
import java.util.Date;

@Vocab(value="http://ontotext.com/ontology/validation/")
@Terms(value={@Term(define="@base", as="http://data.ontotext.com/"), @Term(define="xsd", as="http://www.w3.org/2001/XMLSchema#"), @Term(define="hydra", as="http://www.w3.org/ns/hydra/core#")})
@Expose(value=":Validation")
public class ValidationJob {
    @JsonProperty(value="id")
    private String jobId;
    private String schemaId;
    private String repository;
    private Date createdOn;
    private Date completedOn;
    private Date canceledOn;
    private int totalTasks;
    private int remainingTasks;
    private int infoTasks;
    private int warningTasks;
    private int failedTasks;

    public ValidationJob() {
    }

    public ValidationJob(String jobId) {
        this.setJobId(jobId);
    }

    public ValidationJob(ValidationJob copyFrom) {
        this.jobId = copyFrom.jobId;
        this.schemaId = copyFrom.schemaId;
        this.createdOn = copyFrom.createdOn;
        this.completedOn = copyFrom.completedOn;
        this.canceledOn = copyFrom.canceledOn;
        this.totalTasks = copyFrom.totalTasks;
        this.remainingTasks = copyFrom.remainingTasks;
        this.infoTasks = copyFrom.infoTasks;
        this.warningTasks = copyFrom.warningTasks;
        this.failedTasks = copyFrom.failedTasks;
        this.repository = copyFrom.repository;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getCompletedOn() {
        return this.completedOn;
    }

    public void setCompletedOn(Date completedOn) {
        this.completedOn = completedOn;
    }

    public int getTotalTasks() {
        return this.totalTasks;
    }

    public void setTotalTasks(int totalTasks) {
        this.totalTasks = totalTasks;
    }

    public int getRemainingTasks() {
        return this.remainingTasks;
    }

    public void setRemainingTasks(int remainingTasks) {
        this.remainingTasks = remainingTasks;
    }

    public int getFailedTasks() {
        return this.failedTasks;
    }

    public void setFailedTasks(int failedTasks) {
        this.failedTasks = failedTasks;
    }

    public int getWarningTasks() {
        return this.warningTasks;
    }

    public void setWarningTasks(int warningTasks) {
        this.warningTasks = warningTasks;
    }

    public Date getCanceledOn() {
        return this.canceledOn;
    }

    public void setCanceledOn(Date canceledOn) {
        this.canceledOn = canceledOn;
    }

    public boolean isDone() {
        return this.totalTasks == 0 || this.totalTasks > 0 && this.remainingTasks == 0;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.canceledOn == null && this.completedOn == null;
    }

    public String toString() {
        return String.format("ValidationJob{jobId='%s', schemaId='%s', repository='%s', createdOn=%s, completedOn=%s, canceledOn=%s, totalTasks=%d, remainingTasks=%d, infoTasks=%d, warningTasks=%d, failedTasks=%d}", this.jobId, this.schemaId, this.repository, this.createdOn, this.completedOn, this.canceledOn, this.totalTasks, this.remainingTasks, this.infoTasks, this.warningTasks, this.failedTasks);
    }

    public int getInfoTasks() {
        return this.infoTasks;
    }

    public void setInfoTasks(int infoTasks) {
        this.infoTasks = infoTasks;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }
}

