/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.Debounce;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationJobReport;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationManagerAdapter;
import com.ontotext.validator.data.ValidationTask;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;

public class CachedValidationManager
extends ValidationManagerAdapter {
    public static final long DEFAULT_CACHE_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private Map<String, Pair<Debounce<ValidationJobReport>, Debounce<ValidationJobReport>>> jobs = new ConcurrentHashMap<String, Pair<Debounce<ValidationJobReport>, Debounce<ValidationJobReport>>>();
    private final long cacheTimeout;

    public CachedValidationManager(ValidationManager delegate) {
        this(delegate, -1L);
    }

    public CachedValidationManager(ValidationManager delegate, long cacheTimeout) {
        super(delegate);
        this.cacheTimeout = cacheTimeout < 0L ? DEFAULT_CACHE_TIMEOUT : cacheTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationJob validate(SomlSchema schema, Set<String> types, Set<String> properties, Set<String> validations, String repository) {
        try {
            ValidationJob validationJob = this.delegate.validate(schema, types, properties, validations, repository);
            return validationJob;
        }
        finally {
            this.jobs.remove(schema.getId());
        }
    }

    @Override
    public boolean removeValidation(String schemaId) {
        try {
            boolean bl = this.delegate.removeValidation(schemaId);
            return bl;
        }
        finally {
            this.jobs.remove(schemaId);
        }
    }

    @Override
    public Optional<ValidationJob> cancelValidation(String schemaId) {
        try {
            Optional<ValidationJob> optional = this.delegate.cancelValidation(schemaId);
            return optional;
        }
        finally {
            this.jobs.remove(schemaId);
        }
    }

    @Override
    public Optional<ValidationJobReport> getValidationReport(String schemaId, boolean failedOnly, long limit, long offset) {
        if (limit > 0L) {
            return this.delegate.getValidationReport(schemaId, failedOnly, limit, offset);
        }
        return Optional.ofNullable((ValidationJobReport)this.getDebounce(schemaId, failedOnly).get(() -> this.delegate.getValidationReport(schemaId, failedOnly, limit, offset).orElse(null)));
    }

    @Override
    public Optional<ValidationJob> getValidation(String schemaId) {
        return Optional.ofNullable((ValidationJobReport)this.getDebounce(schemaId, true).get(() -> this.delegate.getValidationReport(schemaId, true, false).orElse(null))).map(ValidationJob::new);
    }

    @Override
    public Optional<ValidationTask> getValidationTask(String schemaId, String taskId) {
        return Optional.ofNullable((ValidationJobReport)this.getDebounce(schemaId, true).get(() -> this.delegate.getValidationReport(schemaId, true, false).orElse(null))).flatMap(job -> job.getTasks().stream().filter(task -> Objects.equals(task.getId(), taskId)).map(ValidationTask::copy).findFirst());
    }

    private Debounce<ValidationJobReport> getDebounce(String schemaId, boolean failedOnly) {
        Pair debouncePair = this.jobs.computeIfAbsent(schemaId, key -> Pair.of((Object)new Debounce(this.cacheTimeout), (Object)new Debounce(this.cacheTimeout)));
        return failedOnly ? (Debounce)debouncePair.getLeft() : (Debounce)debouncePair.getRight();
    }

    @Override
    public void updateJob(String schemaId, List<ValidationTask> toUpdate) {
        try {
            this.delegate.updateJob(schemaId, toUpdate);
        }
        finally {
            this.jobs.remove(schemaId);
        }
    }
}

