/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.recovery;

import com.ontotext.graphdb.recovery.SnapshotOptions;
import java.io.File;
import java.util.Objects;

public class SnapshotReplicationRequest {
    private final File snapshot;
    private boolean requireFingerprint;
    private final SnapshotOptions snapshotOptions;

    public SnapshotReplicationRequest(File snapshot) {
        this(snapshot, null);
    }

    public SnapshotReplicationRequest(File snapshot, SnapshotOptions options) {
        this.snapshot = Objects.requireNonNull(snapshot, "Snapshot file is required");
        this.snapshotOptions = options == null ? new SnapshotOptions() : new SnapshotOptions(options);
    }

    public File getSnapshot() {
        return this.snapshot;
    }

    public boolean delete() {
        if (this.snapshot != null && this.snapshot.exists()) {
            return this.snapshot.delete();
        }
        return false;
    }

    public SnapshotOptions getSnapshotOptions() {
        return this.snapshotOptions;
    }

    public boolean isRequireFingerprint() {
        return this.requireFingerprint;
    }

    public SnapshotReplicationRequest setRequireFingerprint(boolean requireFingerprint) {
        this.requireFingerprint = requireFingerprint;
        return this;
    }

    public String toString() {
        return this.snapshot.getAbsolutePath();
    }
}

