/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.recovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.forest.core.ForestErrorController;
import com.ontotext.forest.recovery.BackupOptions;
import com.ontotext.forest.recovery.CloudBackupOptions;
import com.ontotext.forest.recovery.CloudRestoreOptions;
import com.ontotext.forest.recovery.RecoveryService;
import com.ontotext.forest.recovery.RestoreOptions;
import com.ontotext.graphdb.recovery.BackupException;
import com.ontotext.graphdb.recovery.SnapshotOptions;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.SchemaProperty;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/recovery"})
@RestController
@Tag(name="Recovery Management", description="Manage data recovery processes")
public class RecoveryController {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryController.class);
    public static final String MAPPING = "/rest/recovery";
    private final RecoveryService recoveryService;

    @Autowired
    public RecoveryController(RecoveryService recoveryService) {
        this.recoveryService = recoveryService;
    }

    @Hidden
    @GetMapping(value={"/backups"})
    public ResponseEntity<?> getSnapshots() {
        logger.warn("Deprecated operation for getting all backups detected. Consider using the new Recovery REST API.");
        return new ResponseEntity(this.recoveryService.getSnapshots(), (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @GetMapping(value={"/backups/{name}"})
    public void getSnapshot(@PathVariable String name, HttpServletResponse response) throws IOException {
        logger.warn("Deprecated operation for getting backup content detected. Consider using the new Recovery REST API.");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            try {
                File source = this.recoveryService.getSnapshotFileOrThrowIfNotExists(name);
                try (FileInputStream inputStream = new FileInputStream(source);){
                    response.setStatus(200);
                    response.setContentType("application/x-tar");
                    response.addHeader("Content-disposition", "attachment;filename=" + name);
                    response.setHeader("Content-Length", String.valueOf(source.length()));
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
            catch (Exception e) {
                if (!ForestErrorController.forceCloseSocketIfCommitted((HttpServletResponse)response, (Throwable)e, (Logger)logger)) {
                    this.resetResponseAndReturnError(response, e);
                }
            }
        }
    }

    @Hidden
    @PostMapping(value={"/backups/{name}"})
    public ResponseEntity<?> createSnapshot(@RequestParam(required=false, defaultValue="true") boolean withSystemData, @org.springframework.web.bind.annotation.RequestBody(required=false) BackupOptions repositories, @PathVariable String name) {
        logger.warn("Deprecated operation for creating a new backup detected. Consider using the new Recovery REST API.");
        try {
            List<String> repositoriesInSnapshot = repositories == null || repositories.getRepositories() == null || repositories.getRepositories().isEmpty() ? null : repositories.getRepositories();
            SnapshotOptions options = new SnapshotOptions().setWithRepositoryData(true).setWithSystemData(withSystemData).setWithClusterData(false).setRepositories(repositoriesInSnapshot);
            this.recoveryService.createSnapshot(name, options);
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT);
        }
        catch (IOException e) {
            return new ResponseEntity((Object)e.toString(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Create a new backup of GraphDB instance", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/backup"})
    public void createBackup(@org.springframework.web.bind.annotation.RequestBody(required=false) @Parameter(description="Options for creating a backup") BackupOptions createBackupOptions, HttpServletResponse response) throws IOException {
        List<String> repositoriesInSnapshot = createBackupOptions == null || createBackupOptions.getRepositories() == null ? null : createBackupOptions.getRepositories();
        SnapshotOptions options = new SnapshotOptions().setWithRepositoryData(repositoriesInSnapshot == null || !repositoriesInSnapshot.isEmpty()).setWithSystemData(createBackupOptions != null && createBackupOptions.getBackupSystemData()).setWithClusterData(false).setRepositories(repositoriesInSnapshot);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            try {
                response.setStatus(200);
                String filename = this.getBackupFileName();
                response.setHeader("Content-disposition", "attachment; filename=" + filename);
                response.setContentType("application/x-tar");
                this.recoveryService.createBackup(options, (OutputStream)outputStream);
                outputStream.flush();
            }
            catch (Exception e) {
                if (!ForestErrorController.forceCloseSocketIfCommitted((HttpServletResponse)response, (Throwable)e, (Logger)logger)) {
                    this.resetResponseAndReturnError(response, e);
                }
            }
        }
    }

    private void resetResponseAndReturnError(HttpServletResponse response, Exception e) throws IOException {
        logger.error("An error occurred during backup creation", (Throwable)e);
        response.sendError(this.getStatusResponseCode(e), e instanceof BackupException ? e.getMessage() : e.toString());
    }

    private int getStatusResponseCode(Exception e) {
        if (e instanceof BackupException && ((BackupException)((Object)e)).isNotFound()) {
            return 404;
        }
        return 400;
    }

    private String getBackupFileName() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
        return "backup-" + LocalDateTime.now().format(formatter) + ".tar";
    }

    @Hidden
    @PutMapping(value={"/backups/{name}"})
    public ResponseEntity<?> updateSnapshot(@RequestParam(required=false, defaultValue="true") boolean withSystemData, @org.springframework.web.bind.annotation.RequestBody(required=false) BackupOptions repositories, @PathVariable String name) {
        logger.warn("Deprecated operation for updating or creating a backup detected. Consider using the new Recovery REST API.");
        try {
            List<String> repositoriesInSnapshot = repositories == null || repositories.getRepositories() == null || repositories.getRepositories().isEmpty() ? null : repositories.getRepositories();
            SnapshotOptions options = new SnapshotOptions().setWithRepositoryData(true).setWithSystemData(withSystemData).setWithClusterData(false).setRepositories(repositoriesInSnapshot);
            this.recoveryService.updateSnapshot(name, options);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.toString(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Hidden
    @DeleteMapping(value={"/backups/{name}"})
    public ResponseEntity<?> deleteSnapshot(@PathVariable String name) {
        logger.warn("Deprecated operation for deleting a backup detected. Consider using the new Recovery REST API.");
        try {
            this.recoveryService.deleteSnapshotOrThrow(name);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)(e.isNotFound() ? HttpStatus.NOT_FOUND : HttpStatus.BAD_REQUEST));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.toString(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Restore GraphDB instance from a backup", requestBody=@RequestBody(content={@Content(mediaType="multipart/form-data", schemaProperties={@SchemaProperty(name="params", schema=@Schema(description="Restore options in JSON format", type="object", implementation=RestoreOptions.class)), @SchemaProperty(name="file", schema=@Schema(description="Backup file", type="string", format="binary"))}, encoding={@Encoding(name="file")})}), responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/restore"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> applySnapshot(HttpServletRequest request) {
        ResponseEntity responseEntity;
        block12: {
            FileItemInputIterator iter = new JakartaServletFileUpload().getItemIterator(request);
            if (!iter.hasNext()) {
                return new ResponseEntity((Object)"No params were submitted", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            FileItemInput params = iter.next();
            if (!"params".equals(params.getFieldName())) {
                return new ResponseEntity((Object)"Params must be provided as the first multipart entity", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            RestoreOptions restoreOptions = (RestoreOptions)new ObjectMapper().readValue(params.getInputStream(), RestoreOptions.class);
            SnapshotOptions snapshotOptions = new SnapshotOptions().setCleanDataDir(restoreOptions.isRemoveStaleRepositories()).setWithRepositoryData(restoreOptions.getRepositories() == null || !restoreOptions.getRepositories().isEmpty()).setWithSystemData(restoreOptions.getRestoreSystemData()).setRepositories(restoreOptions.getRepositories()).setWithClusterData(false);
            if (!iter.hasNext()) {
                return new ResponseEntity((Object)"No backup file was submitted", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            FileItemInput backupFileStream = iter.next();
            if (!"file".equals(backupFileStream.getFieldName())) {
                return new ResponseEntity((Object)"Backup file must be provided as the second multipart entity", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            InputStream backupStream = backupFileStream.getInputStream();
            try {
                this.recoveryService.applyBackup(backupStream, snapshotOptions);
                responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                if (backupStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (backupStream != null) {
                        try {
                            backupStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BackupException | IOException e) {
                    return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
            }
            backupStream.close();
        }
        return responseEntity;
    }

    @Hidden
    @Deprecated(since="10.8")
    @Operation(summary="Restore GraphDB instance from a cloud backup", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/cloud-restore"}, consumes={"application/json"})
    public ResponseEntity<?> applyCloudSnapshotStream(@org.springframework.web.bind.annotation.RequestBody com.ontotext.forest.recovery.Cloud.CloudRestoreOptions cloudRestoreOptions) {
        logger.warn("Deprecated operation for applying cloud snapshot detected. Consider using the new cloud restore recovery REST API.");
        if (cloudRestoreOptions.getBucketUri() == null || cloudRestoreOptions.getBucketUri().isEmpty()) {
            return new ResponseEntity((Object)"bucketUri is required", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        RestoreOptions restoreOptions = cloudRestoreOptions.getRestoreOptions();
        SnapshotOptions options = new SnapshotOptions().setCleanDataDir(restoreOptions.isRemoveStaleRepositories()).setWithRepositoryData(restoreOptions.getRepositories() == null || !restoreOptions.getRepositories().isEmpty()).setWithSystemData(restoreOptions.getRestoreSystemData()).setRepositories(restoreOptions.getRepositories()).setWithClusterData(false);
        try {
            URI bucketUrl = new URI(cloudRestoreOptions.getBucketUri());
            this.recoveryService.applyCloudBackup(bucketUrl, options);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (URISyntaxException e) {
            return new ResponseEntity((Object)"Invalid bucketUri", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Restore GraphDB instance from a cloud backup", requestBody=@RequestBody(content={@Content(mediaType="multipart/form-data", schemaProperties={@SchemaProperty(name="params", schema=@Schema(description="Cloud restore options in JSON format", type="object", implementation=CloudRestoreOptions.class)), @SchemaProperty(name="authenticationFile", schema=@Schema(description="Authentication file", type="string", format="binary"))}, encoding={@Encoding(name="authenticationFile")})}), responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/cloud-restore"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> applyCloudSnapshotStream(HttpServletRequest request) {
        try {
            FileItemInputIterator iter = new JakartaServletFileUpload().getItemIterator(request);
            if (!iter.hasNext()) {
                return new ResponseEntity((Object)"No params were submitted. bucketUri is required.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            FileItemInput params = iter.next();
            if (!"params".equals(params.getFieldName())) {
                return new ResponseEntity((Object)"Params must be provided as the first multipart entity.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            CloudRestoreOptions cloudRestoreOptions = (CloudRestoreOptions)new ObjectMapper().readValue(params.getInputStream(), CloudRestoreOptions.class);
            if (cloudRestoreOptions.getBucketUri() == null || cloudRestoreOptions.getBucketUri().isEmpty()) {
                return new ResponseEntity((Object)"bucketUri is required", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            FileItemInput authenticationFile = null;
            if (iter.hasNext() && !"authenticationFile".equals((authenticationFile = iter.next()).getFieldName())) {
                return new ResponseEntity((Object)"Authentication file must be provided as the second multipart entity.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            SnapshotOptions options = new SnapshotOptions().setCleanDataDir(cloudRestoreOptions.isRemoveStaleRepositories()).setWithRepositoryData(cloudRestoreOptions.getRepositories() == null || !cloudRestoreOptions.getRepositories().isEmpty()).setWithSystemData(cloudRestoreOptions.getRestoreSystemData()).setRepositories(cloudRestoreOptions.getRepositories()).setWithClusterData(false);
            try {
                URI bucketUrl = new URI(cloudRestoreOptions.getBucketUri());
                this.recoveryService.applyCloudBackup(bucketUrl, options, authenticationFile);
                return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            }
            catch (BackupException e) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            catch (URISyntaxException e) {
                return new ResponseEntity((Object)"Invalid bucketUri", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        catch (IOException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Hidden
    @Deprecated(since="10.8")
    @Operation(summary="Create a backup saved to the cloud", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/cloud-backup"}, consumes={"application/json"})
    public ResponseEntity<?> createCloudBackup(@org.springframework.web.bind.annotation.RequestBody @Parameter(description="Options for creating a backup") com.ontotext.forest.recovery.Cloud.CloudBackupOptions createBackupOptions) {
        logger.warn("Deprecated operation for creating cloud backup detected. Consider using the new cloud backup recovery REST API.");
        if (createBackupOptions.getBucketUri() == null || createBackupOptions.getBucketUri().isEmpty()) {
            return new ResponseEntity((Object)"bucketUri is required", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        BackupOptions backupOptions = createBackupOptions.getBackupOptions();
        List<String> repositoriesInSnapshot = backupOptions == null || backupOptions.getRepositories() == null ? null : backupOptions.getRepositories();
        SnapshotOptions options = new SnapshotOptions().setWithRepositoryData(repositoriesInSnapshot == null || !repositoriesInSnapshot.isEmpty()).setWithSystemData(backupOptions != null && backupOptions.getBackupSystemData()).setWithClusterData(false).setRepositories(repositoriesInSnapshot);
        try {
            URI bucketUrl = new URI(createBackupOptions.getBucketUri());
            this.recoveryService.createCloudBackup(bucketUrl, options);
            return new ResponseEntity((Object)"Backup successfully uploaded", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (URISyntaxException e) {
            return new ResponseEntity((Object)"Invalid bucketUri", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Create a backup saved to the cloud", requestBody=@RequestBody(content={@Content(mediaType="multipart/form-data", schemaProperties={@SchemaProperty(name="params", schema=@Schema(description="Cloud backup options in JSON format", type="object", implementation=CloudBackupOptions.class)), @SchemaProperty(name="authenticationFile", schema=@Schema(description="Authentication file", type="string", format="binary"))}, encoding={@Encoding(name="authenticationFile")})}), responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/cloud-backup"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> createCloudBackup(HttpServletRequest request) {
        try {
            FileItemInputIterator iter = new JakartaServletFileUpload().getItemIterator(request);
            if (!iter.hasNext()) {
                return new ResponseEntity((Object)"No params were submitted. bucketUri is required.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            FileItemInput params = iter.next();
            if (!"params".equals(params.getFieldName())) {
                return new ResponseEntity((Object)"Params must be provided as the first multipart entity.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            CloudBackupOptions cloudBackupOptions = (CloudBackupOptions)new ObjectMapper().readValue(params.getInputStream(), CloudBackupOptions.class);
            if (cloudBackupOptions.getBucketUri() == null || cloudBackupOptions.getBucketUri().isEmpty()) {
                return new ResponseEntity((Object)"bucketUri is required", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            FileItemInput authenticationFile = null;
            if (iter.hasNext() && !"authenticationFile".equals((authenticationFile = iter.next()).getFieldName())) {
                return new ResponseEntity((Object)"Authentication file must be provided as the second multipart entity.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            List<String> repositoriesInSnapshot = cloudBackupOptions.getRepositories() == null ? null : cloudBackupOptions.getRepositories();
            SnapshotOptions options = new SnapshotOptions().setWithRepositoryData(repositoriesInSnapshot == null || !repositoriesInSnapshot.isEmpty()).setWithSystemData(cloudBackupOptions.getBackupSystemData()).setWithClusterData(false).setRepositories(repositoriesInSnapshot);
            try {
                URI bucketUrl = new URI(cloudBackupOptions.getBucketUri());
                this.recoveryService.createCloudBackup(bucketUrl, options, authenticationFile);
                return new ResponseEntity((Object)"Backup successfully uploaded", (HttpStatusCode)HttpStatus.OK);
            }
            catch (BackupException e) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            catch (URISyntaxException e) {
                return new ResponseEntity((Object)"Invalid bucketUri", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        catch (IOException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(description="Restore GraphDB instance from a backup", hidden=true)
    @PostMapping(value={"/restore/{name}"})
    public ResponseEntity<?> applySnapshot(@PathVariable String name, @RequestParam(required=false, defaultValue="true") boolean withSystemData, @org.springframework.web.bind.annotation.RequestBody(required=false) BackupOptions repositories, @RequestParam(defaultValue="false") boolean cleanDataDir) {
        logger.warn("Deprecated operation for restoring GraphDB from a backup detected. Consider using the new Recovery REST API.");
        try {
            List<String> repositoriesInSnapshot = repositories == null || repositories.getRepositories() == null || repositories.getRepositories().isEmpty() ? null : repositories.getRepositories();
            SnapshotOptions options = new SnapshotOptions().setCleanDataDir(cleanDataDir).setRepositories(repositoriesInSnapshot).setWithRepositoryData(true).setWithSystemData(withSystemData).setRemoveCluster(true).setWithClusterData(false);
            this.recoveryService.applySnapshot(name, options);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)(e.isNotFound() ? HttpStatus.NOT_FOUND : HttpStatus.BAD_REQUEST));
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.toString(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

