/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.util.QueryUtils;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.UserDeletedEvent;
import com.ontotext.forest.sparql.SavedQueriesEvent;
import com.ontotext.forest.sparql.SavedQuery;
import com.ontotext.forest.sparql.SharedSavedQuery;
import com.ontotext.raft.GraphDBReplicationCluster;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class SavedQueriesService
implements ApplicationListener<UserDeletedEvent>,
ApplicationEventPublisherAware {
    private static final String PERSISTENCE_PROPERTY_LEGACY = "queries";
    private static final String PERSISTENCE_PROPERTY = "user_queries";
    @Autowired
    private ResourceUtils resourceUtils;
    @Autowired
    private UsersConfig usersConfig;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private SemanticDataManagement dataManagement;
    private List<SharedSavedQuery> sharedQueries;
    private ApplicationEventPublisher applicationEventPublisher;

    @PostConstruct
    public void initSharedQueries() {
        ArrayList<SharedSavedQuery> sharedQueries = new ArrayList<SharedSavedQuery>();
        Map allSavedQueries = this.usersConfig.getMapOfMaps(this.getPersistenceProperty(), SavedQuery.class);
        allSavedQueries.forEach((username, savedQueries) -> savedQueries.forEach((queryName, query) -> {
            if (query.isShared()) {
                sharedQueries.add(new SharedSavedQuery(query.getName(), query.getBody(), (String)username));
            }
        }));
        this.sharedQueries = sharedQueries;
    }

    public String getPersistenceProperty() {
        return PERSISTENCE_PROPERTY;
    }

    public void onApplicationEvent(UserDeletedEvent userDeletedEvent) {
        this.usersConfig.deleteMapEntry(this.getPersistenceProperty(), Map.class, userDeletedEvent.getUsername());
    }

    protected Map<String, SavedQuery> initWithDefaultQueries() {
        String[] samples = (String[])this.resourceUtils.getProperty("sparql.samples");
        if (samples == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SavedQuery> queries = new HashMap<String, SavedQuery>();
        LinkedHashMap queryMap = QueryUtils.getQueryMap((String[])samples);
        for (Map.Entry query : queryMap.entrySet()) {
            queries.put((String)query.getKey(), new SavedQuery((String)query.getKey(), (String)query.getValue()));
        }
        this.saveQueriesNoEvent(this.getAuthenticatedUsername(), queries, false);
        return queries;
    }

    protected Map<String, SavedQuery> initWithLegacyQueries() {
        Map legacyQueries = this.usersConfig.getMap(PERSISTENCE_PROPERTY_LEGACY, SavedQuery.class);
        this.saveQueriesNoEvent(this.getAuthenticatedUsername(), legacyQueries, false);
        return legacyQueries;
    }

    public void saveQueriesNoEvent(String username, Map<String, SavedQuery> queries, boolean withDelete) {
        try {
            if (withDelete) {
                Set<String> oldNames = this.getExistingQueriesMap(username).keySet();
                Set<String> newNames = queries.keySet();
                Sets.SetView namesToRemove = Sets.difference(oldNames, newNames);
                for (String nameToRemove : namesToRemove) {
                    this.usersConfig.deleteMapMapEntry(this.getPersistenceProperty(), username, SavedQuery.class, nameToRemove);
                }
            }
            this.usersConfig.updateMapMapEntries(this.getPersistenceProperty(), username, SavedQuery.class, queries);
            this.initSharedQueries();
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Unable to save queries", (Throwable)e);
        }
    }

    private void saveQueries(Map<String, SavedQuery> queries) {
        this.validateLeadership();
        String user = this.getAuthenticatedUsername();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SavedQueriesEvent(user, queries));
        this.saveQueriesNoEvent(user, queries, false);
    }

    protected String getAuthenticatedUsername() {
        return this.securityConfig.getAuthenticatedUsername();
    }

    private void validateSavedQuery(String name, String query) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Name must not be empty.");
        }
        if (Strings.isNullOrEmpty((String)query)) {
            throw new IllegalArgumentException("Query must not be empty.");
        }
    }

    public void createSavedQuery(SavedQuery query) {
        Map<String, SavedQuery> queries = this.getQueriesMap();
        if (queries.containsKey(query.getName())) {
            throw new IllegalArgumentException("Query '" + query.getName() + "' already exists!");
        }
        queries.put(query.getName(), query);
        this.saveQueries(queries);
    }

    public void deleteSavedQuery(String name) {
        this.validateLeadership();
        Map<String, SavedQuery> queries = this.getQueriesMap();
        SavedQuery remove = queries.remove(name);
        if (remove == null) {
            this.notExists(name, null);
        }
        try {
            String user = this.getAuthenticatedUsername();
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new SavedQueriesEvent(user, queries));
            this.usersConfig.deleteMapMapEntry(this.getPersistenceProperty(), user, SavedQuery.class, name);
            this.initSharedQueries();
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Unable to delete query", (Throwable)e);
        }
    }

    private void notExists(String name, String owner) {
        throw new IllegalArgumentException("Query '" + name + "' doesn't exist" + (String)(StringUtils.isEmpty((CharSequence)owner) ? "" : " for owner " + owner));
    }

    public synchronized void editSavedQuery(String oldQueryName, SavedQuery newQuery) {
        this.deleteSavedQuery(oldQueryName);
        HashMap<String, SavedQuery> updatedQueries = new HashMap<String, SavedQuery>(this.getQueriesMap());
        updatedQueries.put(newQuery.getName(), newQuery);
        this.saveQueries(updatedQueries);
    }

    public List<? extends SavedQuery> getSavedQueries() {
        return this.getSavedQueries(this.getAuthenticatedUsername(), null);
    }

    public List<? extends SavedQuery> getSavedQueriesOwnedBy(String owner) {
        return this.getSavedQueries(this.getAuthenticatedUsername(), owner);
    }

    private List<? extends SavedQuery> getSavedQueries(String username, String owner) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new GraphDBWorkbenchException("Username required");
        }
        Map<String, SavedQuery> userQueries = this.getQueriesMap(username);
        HashMap<String, SharedSavedQuery> sharedSavedQueryMap = new HashMap<String, SharedSavedQuery>();
        for (String query : userQueries.keySet()) {
            SavedQuery sq = userQueries.get(query);
            sharedSavedQueryMap.put(query, new SharedSavedQuery(query, sq.getBody(), username, sq.isShared()));
        }
        return Stream.concat(sharedSavedQueryMap.values().stream(), this.getSharedQueries().stream().filter(q -> !username.equals(q.getOwner()))).sorted((o1, o2) -> {
            boolean o1shared = o1 instanceof SharedSavedQuery;
            boolean o2shared = o2 instanceof SharedSavedQuery;
            if (o1shared == o2shared) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
            return Boolean.compare(o1shared, o2shared);
        }).filter(q -> owner == null || owner.equals(q.getOwner())).collect(Collectors.toList());
    }

    public SavedQuery getSavedQuery(String name, @Nullable String owner) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new GraphDBWorkbenchException("Query name required");
        }
        SavedQuery query = this.getSavedQueriesOwnedBy(owner).stream().filter(sq -> name.equals(sq.getName())).findAny().orElse(null);
        if (query == null) {
            this.notExists(name, owner);
        }
        return query;
    }

    private Map<String, SavedQuery> getQueriesMap() {
        return this.getQueriesMap(null);
    }

    private Map<String, SavedQuery> getQueriesMap(@Nullable String username) {
        Map<String, SavedQuery> userQueries;
        if (username == null) {
            username = this.getAuthenticatedUsername();
        }
        if ((userQueries = this.getExistingQueriesMap(username)).isEmpty() && !this.securityConfig.isUsernameFreeAccess(username)) {
            if ("admin".equals(username)) {
                userQueries = this.initWithLegacyQueries();
            }
            if (userQueries.isEmpty()) {
                userQueries = this.initWithDefaultQueries();
            }
        }
        return userQueries;
    }

    private Map<String, SavedQuery> getExistingQueriesMap(String username) {
        return this.usersConfig.getMapMap(this.getPersistenceProperty(), username, SavedQuery.class);
    }

    private List<SharedSavedQuery> getSharedQueries() {
        return this.sharedQueries;
    }

    private void validateLeadership() {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            try {
                replicationCluster.validateLeadership();
            }
            catch (UpdateExecutionException e) {
                throw new GraphDBWorkbenchException(e.getMessage());
            }
            if (!replicationCluster.isPrimaryCluster()) {
                throw new GraphDBWorkbenchException("Unable to execute operation as node is in secondary cluster mode.");
            }
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

