/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.ScriptField;
import org.opensearch.client.opensearch._types.SlicedScroll;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.mapping.RuntimeField;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.BoostingQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.CombinedFieldsQuery;
import org.opensearch.client.opensearch._types.query_dsl.CommonTermsQuery;
import org.opensearch.client.opensearch._types.query_dsl.ConstantScoreQuery;
import org.opensearch.client.opensearch._types.query_dsl.DisMaxQuery;
import org.opensearch.client.opensearch._types.query_dsl.DistanceFeatureQuery;
import org.opensearch.client.opensearch._types.query_dsl.ExistsQuery;
import org.opensearch.client.opensearch._types.query_dsl.FieldAndFormat;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScoreQuery;
import org.opensearch.client.opensearch._types.query_dsl.FuzzyQuery;
import org.opensearch.client.opensearch._types.query_dsl.GeoBoundingBoxQuery;
import org.opensearch.client.opensearch._types.query_dsl.GeoDistanceQuery;
import org.opensearch.client.opensearch._types.query_dsl.GeoPolygonQuery;
import org.opensearch.client.opensearch._types.query_dsl.GeoShapeQuery;
import org.opensearch.client.opensearch._types.query_dsl.HasChildQuery;
import org.opensearch.client.opensearch._types.query_dsl.HasParentQuery;
import org.opensearch.client.opensearch._types.query_dsl.IdsQuery;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchBoolPrefixQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchNoneQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchPhrasePrefixQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchPhraseQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.MoreLikeThisQuery;
import org.opensearch.client.opensearch._types.query_dsl.MultiMatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.ParentIdQuery;
import org.opensearch.client.opensearch._types.query_dsl.PercolateQuery;
import org.opensearch.client.opensearch._types.query_dsl.PinnedQuery;
import org.opensearch.client.opensearch._types.query_dsl.PrefixQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryStringQuery;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch._types.query_dsl.RankFeatureQuery;
import org.opensearch.client.opensearch._types.query_dsl.RegexpQuery;
import org.opensearch.client.opensearch._types.query_dsl.ScriptQuery;
import org.opensearch.client.opensearch._types.query_dsl.ScriptScoreQuery;
import org.opensearch.client.opensearch._types.query_dsl.SimpleQueryStringQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanContainingQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanFieldMaskingQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanFirstQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanMultiTermQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanNearQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanNotQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanOrQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanTermQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanWithinQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsSetQuery;
import org.opensearch.client.opensearch._types.query_dsl.TypeQuery;
import org.opensearch.client.opensearch._types.query_dsl.WildcardQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.FieldCollapse;
import org.opensearch.client.opensearch.core.search.Highlight;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.opensearch.core.search.Pit;
import org.opensearch.client.opensearch.core.search.Rescore;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.Suggester;
import org.opensearch.client.opensearch.core.search.TrackHits;

public class QueryHighlighter {
    private final Highlight highlight;
    private final JsonpDeserializer<SearchRequest> requestDeserializer;
    private final JsonpDeserializer<Query> queryDeserializer;
    private final JsonpDeserializer<BoolQuery> boolDeserializer;
    private final JsonpDeserializer<NestedQuery> nestedDeserializer;

    public QueryHighlighter(Highlight highlight) {
        this.highlight = highlight;
        this.requestDeserializer = ObjectBuilderDeserializer.lazy(SearchRequest.Builder::new, this::setupSearchRequestDeserializer);
        this.queryDeserializer = ObjectBuilderDeserializer.lazy(Query.Builder::new, this::setupQueryDeserializer, Query.Builder::build);
        this.boolDeserializer = ObjectBuilderDeserializer.lazy(() -> new GraphDBBoolBuilder(highlight), this::setupBoolQueryDeserializer);
        this.nestedDeserializer = ObjectBuilderDeserializer.lazy(GraphDBNestedBuilder::new, this::setupNestedQueryDeserializer);
    }

    public Query withJson(String query) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        Query q = ((SearchRequest)this.requestDeserializer.deserialize(mapper.jsonProvider().createParser((Reader)new StringReader(query)), (JsonpMapper)mapper)).query();
        return this.highlightQuery(q, this.highlight);
    }

    protected void setupQueryDeserializer(ObjectDeserializer<Query.Builder> op) {
        op.add(Query.Builder::bool, this.boolDeserializer, "bool");
        op.add(Query.Builder::boosting, BoostingQuery._DESERIALIZER, "boosting");
        op.add(Query.Builder::common, CommonTermsQuery._DESERIALIZER, "common");
        op.add(Query.Builder::combinedFields, CombinedFieldsQuery._DESERIALIZER, "combined_fields");
        op.add(Query.Builder::constantScore, ConstantScoreQuery._DESERIALIZER, "constant_score");
        op.add(Query.Builder::disMax, DisMaxQuery._DESERIALIZER, "dis_max");
        op.add(Query.Builder::distanceFeature, DistanceFeatureQuery._DESERIALIZER, "distance_feature");
        op.add(Query.Builder::exists, ExistsQuery._DESERIALIZER, "exists");
        op.add(Query.Builder::functionScore, FunctionScoreQuery._DESERIALIZER, "function_score");
        op.add(Query.Builder::fuzzy, FuzzyQuery._DESERIALIZER, "fuzzy");
        op.add(Query.Builder::geoBoundingBox, GeoBoundingBoxQuery._DESERIALIZER, "geo_bounding_box");
        op.add(Query.Builder::geoDistance, GeoDistanceQuery._DESERIALIZER, "geo_distance");
        op.add(Query.Builder::geoPolygon, GeoPolygonQuery._DESERIALIZER, "geo_polygon");
        op.add(Query.Builder::geoShape, GeoShapeQuery._DESERIALIZER, "geo_shape");
        op.add(Query.Builder::hasChild, HasChildQuery._DESERIALIZER, "has_child");
        op.add(Query.Builder::hasParent, HasParentQuery._DESERIALIZER, "has_parent");
        op.add(Query.Builder::ids, IdsQuery._DESERIALIZER, "ids");
        op.add(Query.Builder::intervals, IntervalsQuery._DESERIALIZER, "intervals");
        op.add(Query.Builder::match, MatchQuery._DESERIALIZER, "match");
        op.add(Query.Builder::matchAll, MatchAllQuery._DESERIALIZER, "match_all");
        op.add(Query.Builder::matchBoolPrefix, MatchBoolPrefixQuery._DESERIALIZER, "match_bool_prefix");
        op.add(Query.Builder::matchNone, MatchNoneQuery._DESERIALIZER, "match_none");
        op.add(Query.Builder::matchPhrase, MatchPhraseQuery._DESERIALIZER, "match_phrase");
        op.add(Query.Builder::matchPhrasePrefix, MatchPhrasePrefixQuery._DESERIALIZER, "match_phrase_prefix");
        op.add(Query.Builder::moreLikeThis, MoreLikeThisQuery._DESERIALIZER, "more_like_this");
        op.add(Query.Builder::multiMatch, MultiMatchQuery._DESERIALIZER, "multi_match");
        op.add(Query.Builder::nested, this.nestedDeserializer, "nested");
        op.add(Query.Builder::parentId, ParentIdQuery._DESERIALIZER, "parent_id");
        op.add(Query.Builder::percolate, PercolateQuery._DESERIALIZER, "percolate");
        op.add(Query.Builder::pinned, PinnedQuery._DESERIALIZER, "pinned");
        op.add(Query.Builder::prefix, PrefixQuery._DESERIALIZER, "prefix");
        op.add(Query.Builder::queryString, QueryStringQuery._DESERIALIZER, "query_string");
        op.add(Query.Builder::range, RangeQuery._DESERIALIZER, "range");
        op.add(Query.Builder::rankFeature, RankFeatureQuery._DESERIALIZER, "rank_feature");
        op.add(Query.Builder::regexp, RegexpQuery._DESERIALIZER, "regexp");
        op.add(Query.Builder::script, ScriptQuery._DESERIALIZER, "script");
        op.add(Query.Builder::scriptScore, ScriptScoreQuery._DESERIALIZER, "script_score");
        op.add(Query.Builder::simpleQueryString, SimpleQueryStringQuery._DESERIALIZER, "simple_query_string");
        op.add(Query.Builder::spanContaining, SpanContainingQuery._DESERIALIZER, "span_containing");
        op.add(Query.Builder::fieldMaskingSpan, SpanFieldMaskingQuery._DESERIALIZER, "field_masking_span");
        op.add(Query.Builder::spanFirst, SpanFirstQuery._DESERIALIZER, "span_first");
        op.add(Query.Builder::spanMulti, SpanMultiTermQuery._DESERIALIZER, "span_multi");
        op.add(Query.Builder::spanNear, SpanNearQuery._DESERIALIZER, "span_near");
        op.add(Query.Builder::spanNot, SpanNotQuery._DESERIALIZER, "span_not");
        op.add(Query.Builder::spanOr, SpanOrQuery._DESERIALIZER, "span_or");
        op.add(Query.Builder::spanTerm, SpanTermQuery._DESERIALIZER, "span_term");
        op.add(Query.Builder::spanWithin, SpanWithinQuery._DESERIALIZER, "span_within");
        op.add(Query.Builder::term, TermQuery._DESERIALIZER, "term");
        op.add(Query.Builder::terms, TermsQuery._DESERIALIZER, "terms");
        op.add(Query.Builder::termsSet, TermsSetQuery._DESERIALIZER, "terms_set");
        op.add(Query.Builder::wildcard, WildcardQuery._DESERIALIZER, "wildcard");
        op.add(Query.Builder::type, TypeQuery._DESERIALIZER, "type");
    }

    protected void setupSearchRequestDeserializer(ObjectDeserializer<SearchRequest.Builder> op) {
        op.add(SearchRequest.Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(SearchRequest.Builder::aggregations, JsonpDeserializer.stringMapDeserializer((JsonpDeserializer)Aggregation._DESERIALIZER), "aggregations", new String[]{"aggs"});
        op.add(SearchRequest.Builder::collapse, FieldCollapse._DESERIALIZER, "collapse");
        op.add(SearchRequest.Builder::docvalueFields, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)FieldAndFormat._DESERIALIZER), "docvalue_fields");
        op.add(SearchRequest.Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(SearchRequest.Builder::fields, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)FieldAndFormat._DESERIALIZER), "fields");
        op.add(SearchRequest.Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(SearchRequest.Builder::highlight, Highlight._DESERIALIZER, "highlight");
        op.add(SearchRequest.Builder::indicesBoost, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringMapDeserializer((JsonpDeserializer)JsonpDeserializer.doubleDeserializer())), "indices_boost");
        op.add(SearchRequest.Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(SearchRequest.Builder::pit, Pit._DESERIALIZER, "pit");
        op.add(SearchRequest.Builder::postFilter, this.queryDeserializer, "post_filter");
        op.add(SearchRequest.Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile");
        op.add(SearchRequest.Builder::query, this.queryDeserializer, "query");
        op.add(SearchRequest.Builder::rescore, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)Rescore._DESERIALIZER), "rescore");
        op.add(SearchRequest.Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer((JsonpDeserializer)RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(SearchRequest.Builder::scriptFields, JsonpDeserializer.stringMapDeserializer((JsonpDeserializer)ScriptField._DESERIALIZER), "script_fields");
        op.add(SearchRequest.Builder::searchAfter, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)FieldValue._DESERIALIZER), "search_after");
        op.add(SearchRequest.Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term");
        op.add(SearchRequest.Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(SearchRequest.Builder::slice, SlicedScroll._DESERIALIZER, "slice");
        op.add(SearchRequest.Builder::sort, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)SortOptions._DESERIALIZER), "sort");
        op.add(SearchRequest.Builder::stats, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringDeserializer()), "stats");
        op.add(SearchRequest.Builder::storedFields, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringDeserializer()), "stored_fields");
        op.add(SearchRequest.Builder::suggest, Suggester._DESERIALIZER, "suggest");
        op.add(SearchRequest.Builder::terminateAfter, JsonpDeserializer.longDeserializer(), "terminate_after");
        op.add(SearchRequest.Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout");
        op.add(SearchRequest.Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores");
        op.add(SearchRequest.Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(SearchRequest.Builder::version, JsonpDeserializer.booleanDeserializer(), "version");
    }

    protected void setupBoolQueryDeserializer(ObjectDeserializer<BoolQuery.Builder> op) {
        this.setupQueryBaseDeserializer(op);
        op.add(BoolQuery.Builder::filter, JsonpDeserializer.arrayDeserializer(this.queryDeserializer), "filter");
        op.add(BoolQuery.Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(BoolQuery.Builder::mustNot, JsonpDeserializer.arrayDeserializer(this.queryDeserializer), "must_not");
        op.add((BiConsumer)new BoolMustHighlighter(), JsonpDeserializer.arrayDeserializer(this.queryDeserializer), "must");
        op.add((BiConsumer)new BoolShouldHighlighter(), JsonpDeserializer.arrayDeserializer(this.queryDeserializer), "should");
    }

    protected void setupNestedQueryDeserializer(ObjectDeserializer<NestedQuery.Builder> op) {
        this.setupQueryBaseDeserializer(op);
        op.add(NestedQuery.Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(NestedQuery.Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(NestedQuery.Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(NestedQuery.Builder::query, this.queryDeserializer, "query");
        op.add(NestedQuery.Builder::scoreMode, (JsonpDeserializer)ChildScoreMode._DESERIALIZER, "score_mode");
    }

    protected <BuilderT extends QueryBase.AbstractBuilder<BuilderT>> void setupQueryBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(QueryBase.AbstractBuilder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(QueryBase.AbstractBuilder::queryName, JsonpDeserializer.stringDeserializer(), "_name");
    }

    private Query highlightQuery(Query query, Highlight highlight) {
        if (query.isNested()) {
            NestedQuery nested = query.nested();
            InnerHits innerHits = nested.innerHits();
            if (innerHits == null) {
                innerHits = new InnerHits.Builder().highlight(highlight).build();
                query = this.rebuildHighlightedQuery(nested, innerHits);
            } else if (innerHits.highlight() == null) {
                innerHits = new InnerHits.Builder().highlight(highlight).build();
                query = this.rebuildHighlightedQuery(nested, innerHits);
            }
        }
        return query;
    }

    private Query rebuildHighlightedQuery(NestedQuery query, InnerHits hits) {
        return ((NestedQuery.Builder)new NestedQuery.Builder().query(query.query()).innerHits(hits).ignoreUnmapped(query.ignoreUnmapped()).path(query.path()).scoreMode(query.scoreMode()).queryName(query.queryName())).build().toQuery();
    }

    protected static class BoolMustHighlighter
    implements BiConsumer<BoolQuery.Builder, List<Query>> {
        protected BoolMustHighlighter() {
        }

        @Override
        public void accept(BoolQuery.Builder builder, List<Query> queries) {
            if (builder instanceof GraphDBBoolBuilder) {
                ((GraphDBBoolBuilder)builder).mustList(queries);
            } else {
                builder.must(queries);
            }
        }
    }

    protected static class BoolShouldHighlighter
    implements BiConsumer<BoolQuery.Builder, List<Query>> {
        protected BoolShouldHighlighter() {
        }

        @Override
        public void accept(BoolQuery.Builder builder, List<Query> queries) {
            if (builder instanceof GraphDBBoolBuilder) {
                ((GraphDBBoolBuilder)builder).shouldList(queries);
            } else {
                builder.should(queries);
            }
        }
    }

    protected class GraphDBBoolBuilder
    extends BoolQuery.Builder {
        private final Highlight highlight;

        public GraphDBBoolBuilder(Highlight highlight) {
            this.highlight = highlight;
        }

        public BoolQuery build() {
            return super.build();
        }

        public BoolQuery.Builder mustList(List<Query> list) {
            if (this.highlight != null) {
                list = this.highlightNestedQueries(list, this.highlight);
            }
            super.must(list);
            return this;
        }

        public BoolQuery.Builder shouldList(List<Query> list) {
            if (this.highlight != null) {
                list = this.highlightNestedQueries(list, this.highlight);
            }
            super.should(list);
            return this;
        }

        private List<Query> highlightNestedQueries(List<Query> list, Highlight highlight) {
            ArrayList<Query> highlightedList = new ArrayList<Query>();
            for (Query q : list) {
                highlightedList.add(QueryHighlighter.this.highlightQuery(q, highlight));
            }
            return highlightedList;
        }
    }

    protected static class GraphDBNestedBuilder
    extends NestedQuery.Builder {
        GraphDBNestedBuilder() {
        }

        public NestedQuery build() {
            return super.build();
        }
    }
}

