/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.util.GraphDBPropertyWrapper;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.util.GraphDBSearchRequestBuilder;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import jakarta.json.stream.JsonGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.Value;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.jackson.JacksonJsonProvider;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.mapping.AggregateMetricDoubleProperty;
import org.opensearch.client.opensearch._types.mapping.BinaryProperty;
import org.opensearch.client.opensearch._types.mapping.BooleanProperty;
import org.opensearch.client.opensearch._types.mapping.ByteNumberProperty;
import org.opensearch.client.opensearch._types.mapping.CompletionProperty;
import org.opensearch.client.opensearch._types.mapping.CorePropertyBase;
import org.opensearch.client.opensearch._types.mapping.DateNanosProperty;
import org.opensearch.client.opensearch._types.mapping.DateProperty;
import org.opensearch.client.opensearch._types.mapping.DateRangeProperty;
import org.opensearch.client.opensearch._types.mapping.DoubleNumberProperty;
import org.opensearch.client.opensearch._types.mapping.DoubleRangeProperty;
import org.opensearch.client.opensearch._types.mapping.FieldAliasProperty;
import org.opensearch.client.opensearch._types.mapping.FlatObjectProperty;
import org.opensearch.client.opensearch._types.mapping.FloatNumberProperty;
import org.opensearch.client.opensearch._types.mapping.FloatRangeProperty;
import org.opensearch.client.opensearch._types.mapping.GeoPointProperty;
import org.opensearch.client.opensearch._types.mapping.GeoShapeProperty;
import org.opensearch.client.opensearch._types.mapping.HalfFloatNumberProperty;
import org.opensearch.client.opensearch._types.mapping.HistogramProperty;
import org.opensearch.client.opensearch._types.mapping.IndexOptions;
import org.opensearch.client.opensearch._types.mapping.IntegerNumberProperty;
import org.opensearch.client.opensearch._types.mapping.IntegerRangeProperty;
import org.opensearch.client.opensearch._types.mapping.IpProperty;
import org.opensearch.client.opensearch._types.mapping.IpRangeProperty;
import org.opensearch.client.opensearch._types.mapping.JoinProperty;
import org.opensearch.client.opensearch._types.mapping.KeywordProperty;
import org.opensearch.client.opensearch._types.mapping.LongNumberProperty;
import org.opensearch.client.opensearch._types.mapping.LongRangeProperty;
import org.opensearch.client.opensearch._types.mapping.Murmur3HashProperty;
import org.opensearch.client.opensearch._types.mapping.NestedProperty;
import org.opensearch.client.opensearch._types.mapping.ObjectProperty;
import org.opensearch.client.opensearch._types.mapping.PercolatorProperty;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.RankFeatureProperty;
import org.opensearch.client.opensearch._types.mapping.RankFeaturesProperty;
import org.opensearch.client.opensearch._types.mapping.ScaledFloatNumberProperty;
import org.opensearch.client.opensearch._types.mapping.SearchAsYouTypeProperty;
import org.opensearch.client.opensearch._types.mapping.ShortNumberProperty;
import org.opensearch.client.opensearch._types.mapping.TextIndexPrefixes;
import org.opensearch.client.opensearch._types.mapping.TextProperty;
import org.opensearch.client.opensearch._types.mapping.TokenCountProperty;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch._types.mapping.UnsignedLongNumberProperty;
import org.opensearch.client.opensearch._types.mapping.VersionProperty;
import org.opensearch.client.opensearch._types.mapping.WildcardProperty;
import org.opensearch.client.opensearch._types.mapping.XyShapeProperty;
import org.opensearch.client.opensearch._types.query_dsl.IdsQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch._types.query_dsl.QueryHighlighter;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.search.Highlight;
import org.opensearch.client.opensearch.core.search.HighlightField;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.TrackHits;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchUtil {
    private static final Logger logger = LoggerFactory.getLogger(OpensearchUtil.class);
    private static final Map<String, Property.Kind> PROPERTY_KIND_MAP = new HashMap<String, Property.Kind>();
    private static final String COERCE = "coerce";
    private static final String COPY_TO = "copy_to";
    private static final String DOC_VALUES = "doc_values";
    private static final String EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";
    private static final String ENABLED = "enabled";
    private static final String IGNORE_ABOVE = "ignore_above";
    private static final String IGNORE_MALFORMED = "ignore_malformed";
    private static final String INDEX_OPTIONS = "index_options";
    private static final String INDEX_PHRASES = "index_phrases";
    private static final String INDEX_PREFIXES = "index_prefixes";
    private static final String META = "meta";
    private static final String NORMALIZER = "normalizer";
    private static final String NORMS = "norms";
    private static final String POSITION_INCREMENT_GAP = "position_increment_gap";
    private static final String SEARCH_ANALYZER = "search_analyzer";
    private static final String SIMILARITY = "similarity";

    private OpensearchUtil() {
    }

    public static SearchRequest.Builder searchBuilderWithCustomParameters(String indexName, MasterResultIterator mri) {
        Query query;
        String queryString;
        GraphDBSearchRequestBuilder searchBuilder = new GraphDBSearchRequestBuilder();
        searchBuilder.index(indexName, new String[0]);
        Highlight highlight = null;
        boolean useSubjectFilter = true;
        boolean useMriTrackHits = true;
        SearchOptions searchOptions = mri.getSearchOptions();
        if (mri.isSnippets()) {
            highlight = OpensearchUtil.buildHighlight(searchOptions);
            searchBuilder.highlight(highlight);
        }
        if ((queryString = mri.getQueryString()) == null || queryString.isEmpty()) {
            query = QueryBuilders.matchAll().build().toQuery();
        } else if ((queryString = queryString.trim()).startsWith("{")) {
            Integer offset;
            SearchRequest parsedRequest = searchBuilder.withJson(new StringReader(queryString)).build();
            useSubjectFilter = parsedRequest.postFilter() == null;
            useMriTrackHits = parsedRequest.trackTotalHits() == null;
            Integer size = parsedRequest.size();
            if (size != null) {
                searchOptions.setLimit(size.toString());
            }
            if ((offset = parsedRequest.from()) != null) {
                searchOptions.setOffset(offset.toString());
            }
            searchBuilder.size(null);
            searchBuilder.from(null);
            if (highlight != null && !OpensearchUtil.hasNestedHighlighter(parsedRequest.query())) {
                QueryHighlighter highlighter = new QueryHighlighter(highlight);
                query = highlighter.withJson(queryString);
            } else {
                query = parsedRequest.query();
            }
        } else {
            query = QueryBuilders.queryString().query(queryString).build().toQuery();
        }
        searchBuilder.query(query);
        searchBuilder.source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build());
        if (useSubjectFilter) {
            OpensearchUtil.setSubjectFilter(searchBuilder, mri);
        }
        if (mri.isTrackTotalHits() && useMriTrackHits) {
            searchBuilder.trackTotalHits((TrackHits)new TrackHits.Builder().enabled(Boolean.valueOf(true)).build());
        }
        return searchBuilder;
    }

    public static IndexSettings settingsFromJson(Object settings) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        return (IndexSettings)IndexSettings._DESERIALIZER.deserialize(mapper.jsonProvider().createParser((Reader)new StringReader(settings.toString())), (JsonpMapper)mapper);
    }

    public static String toString(JsonpSerializable value) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        JacksonJsonProvider provider = new JacksonJsonProvider();
        StringWriter string = new StringWriter();
        JsonGenerator generator = provider.createGenerator((Writer)string);
        value.serialize(generator, (JsonpMapper)mapper);
        generator.close();
        return string.toString();
    }

    public static TypeMapping mappingFromJson(String mapping) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        return (TypeMapping)TypeMapping._DESERIALIZER.deserialize(mapper.jsonProvider().createParser((Reader)new StringReader(mapping)), (JsonpMapper)mapper);
    }

    public static <T> T handleOpenSearchException(String message, Exception e) {
        String specificMessage = null;
        if (e instanceof OpenSearchException) {
            try {
                OpenSearchException openSearchException = (OpenSearchException)e;
                List rootCause = openSearchException.response().error().rootCause();
                if (rootCause != null && !rootCause.isEmpty()) {
                    specificMessage = ((ErrorCause)rootCause.get(0)).reason();
                }
            }
            catch (Exception ex) {
                logger.error("Could not parse error response from ES due to: ", (Throwable)ex);
            }
        }
        if (specificMessage == null) {
            specificMessage = e.getMessage();
        }
        throw new ConnectorServerException(message + ": " + specificMessage, (Throwable)e);
    }

    public static String buildFailureMessage(BulkResponse response) {
        List responses = response.items();
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < responses.size(); ++i) {
            BulkResponseItem tmp = (BulkResponseItem)responses.get(i);
            if (tmp.error() == null) continue;
            sb.append("\n[").append(i).append("]: index [").append(tmp.index()).append("], type [").append(tmp.operationType()).append("], id [").append(tmp.id()).append("], message [").append(tmp.error()).append("]");
        }
        return sb.toString();
    }

    public static void addMutableProperties(Map<String, Property> source, Map<String, Property> destination) {
        for (Map.Entry<String, Property> entry : source.entrySet()) {
            Property prop = entry.getValue();
            if ((prop.isNested() || prop.isObject() || prop.isGeoPoint()) && !(prop instanceof GraphDBPropertyWrapper)) {
                HashMap<String, Property> newMap = new HashMap<String, Property>();
                if (prop.isNested()) {
                    NestedProperty nested = prop.nested();
                    OpensearchUtil.addMutableProperties(nested.properties(), newMap);
                    destination.put(entry.getKey(), OpensearchUtil.buildNestedProperty(newMap));
                    continue;
                }
                if (prop.isObject()) {
                    ObjectProperty obj = prop.object();
                    OpensearchUtil.addMutableProperties(obj.properties(), newMap);
                    destination.put(entry.getKey(), OpensearchUtil.buildObjectProperty(newMap));
                    continue;
                }
                GeoPointProperty geo = prop.geoPoint();
                OpensearchUtil.addMutableProperties(geo.properties(), newMap);
                destination.put(entry.getKey(), OpensearchUtil.buildGeopointProperty(newMap, null, Collections.emptyMap()));
                continue;
            }
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public static Property buildProperty(String type, Map<String, Property> properties) {
        return OpensearchUtil.buildProperty(type, false, null, null, null, null, properties, Collections.emptyMap());
    }

    public static Property buildProperty(String type, boolean fielddata, boolean index, boolean stored, String format, String analyzer, Map<String, ?> nativeSettings) {
        return OpensearchUtil.buildProperty(type, fielddata, index, stored, format, analyzer, null, nativeSettings);
    }

    private static Property buildProperty(String type, boolean fielddata, Boolean index, Boolean stored, String format, String analyzer, Map<String, Property> properties, Map<String, ?> nativeSettings) {
        Property.Kind kind = PROPERTY_KIND_MAP.get(type);
        switch (kind) {
            case AggregateMetricDouble: {
                AggregateMetricDoubleProperty.Builder builder = new AggregateMetricDoubleProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case Binary: {
                BinaryProperty.Builder builder = new BinaryProperty.Builder();
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Boolean: {
                BooleanProperty.Builder builder = (BooleanProperty.Builder)new BooleanProperty.Builder().index(index).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Byte: {
                ByteNumberProperty.Builder builder = (ByteNumberProperty.Builder)((ByteNumberProperty.Builder)((ByteNumberProperty.Builder)((ByteNumberProperty.Builder)new ByteNumberProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE))).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Completion: {
                CompletionProperty.Builder builder = new CompletionProperty.Builder().analyzer(analyzer);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case DateNanos: {
                DateNanosProperty.Builder builder = ((DateNanosProperty.Builder)new DateNanosProperty.Builder().index(index).store(stored)).format(format).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Date: {
                DateProperty.Builder builder = ((DateProperty.Builder)new DateProperty.Builder().index(index).store(stored)).format(format).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case DateRange: {
                DateRangeProperty.Builder builder = ((DateRangeProperty.Builder)((DateRangeProperty.Builder)((DateRangeProperty.Builder)new DateRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE))).format(format);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Double: {
                DoubleNumberProperty.Builder builder = (DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)new DoubleNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case DoubleRange: {
                DoubleRangeProperty.Builder builder = (DoubleRangeProperty.Builder)((DoubleRangeProperty.Builder)((DoubleRangeProperty.Builder)new DoubleRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Alias: {
                FieldAliasProperty.Builder builder = new FieldAliasProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case FlatObject: {
                FlatObjectProperty.Builder builder = new FlatObjectProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case Float: {
                FloatNumberProperty.Builder builder = (FloatNumberProperty.Builder)((FloatNumberProperty.Builder)((FloatNumberProperty.Builder)((FloatNumberProperty.Builder)new FloatNumberProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case FloatRange: {
                FloatRangeProperty.Builder builder = (FloatRangeProperty.Builder)((FloatRangeProperty.Builder)((FloatRangeProperty.Builder)new FloatRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case GeoPoint: {
                return OpensearchUtil.buildGeopointProperty(properties, stored, nativeSettings);
            }
            case GeoShape: {
                GeoShapeProperty.Builder builder = (GeoShapeProperty.Builder)new GeoShapeProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).coerce((Boolean)nativeSettings.get(COERCE)).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case HalfFloat: {
                HalfFloatNumberProperty.Builder builder = (HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)new HalfFloatNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Histogram: {
                HistogramProperty.Builder builder = new HistogramProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case Integer: {
                IntegerNumberProperty.Builder builder = (IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)new IntegerNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case IntegerRange: {
                IntegerRangeProperty.Builder builder = (IntegerRangeProperty.Builder)((IntegerRangeProperty.Builder)((IntegerRangeProperty.Builder)new IntegerRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Ip: {
                IpProperty.Builder builder = (IpProperty.Builder)new IpProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).index(index).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case IpRange: {
                IpRangeProperty.Builder builder = (IpRangeProperty.Builder)((IpRangeProperty.Builder)((IpRangeProperty.Builder)new IpRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Join: {
                JoinProperty.Builder builder = new JoinProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case Keyword: {
                KeywordProperty.Builder builder = (KeywordProperty.Builder)new KeywordProperty.Builder().index(index).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                if (nativeSettings.get(INDEX_OPTIONS) != null) {
                    builder.indexOptions(IndexOptions.valueOf((String)((String)nativeSettings.get(INDEX_OPTIONS))));
                }
                builder.normalizer((String)nativeSettings.get(NORMALIZER));
                builder.norms((Boolean)nativeSettings.get(NORMS));
                return builder.build().toProperty();
            }
            case Long: {
                LongNumberProperty.Builder builder = (LongNumberProperty.Builder)((LongNumberProperty.Builder)((LongNumberProperty.Builder)((LongNumberProperty.Builder)new LongNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case LongRange: {
                LongRangeProperty.Builder builder = (LongRangeProperty.Builder)((LongRangeProperty.Builder)((LongRangeProperty.Builder)new LongRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Murmur3: {
                Murmur3HashProperty.Builder builder = (Murmur3HashProperty.Builder)new Murmur3HashProperty.Builder().store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Nested: {
                return OpensearchUtil.buildNestedProperty(properties);
            }
            case Object: {
                return OpensearchUtil.buildObjectProperty(properties, nativeSettings);
            }
            case Percolator: {
                PercolatorProperty.Builder builder = new PercolatorProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case RankFeature: {
                RankFeatureProperty.Builder builder = new RankFeatureProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case RankFeatures: {
                RankFeaturesProperty.Builder builder = new RankFeaturesProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case ScaledFloat: {
                ScaledFloatNumberProperty.Builder builder = (ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)new ScaledFloatNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                builder.scalingFactor(Double.valueOf(nativeSettings.get("scaling_factor").toString()));
                return builder.build().toProperty();
            }
            case SearchAsYouType: {
                SearchAsYouTypeProperty.Builder builder = ((SearchAsYouTypeProperty.Builder)new SearchAsYouTypeProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case XyShape: {
                XyShapeProperty.Builder builder = (XyShapeProperty.Builder)new XyShapeProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).coerce((Boolean)nativeSettings.get(COERCE)).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Short: {
                ShortNumberProperty.Builder builder = (ShortNumberProperty.Builder)((ShortNumberProperty.Builder)((ShortNumberProperty.Builder)((ShortNumberProperty.Builder)new ShortNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Text: {
                TextProperty.Builder builder = ((TextProperty.Builder)new TextProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                if (fielddata) {
                    builder.fielddata(Boolean.valueOf(true));
                }
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.indexPhrases((Boolean)nativeSettings.get(INDEX_PHRASES));
                Object prefixes = nativeSettings.get(INDEX_PREFIXES);
                if (prefixes != null) {
                    TextIndexPrefixes.Builder prefBuilder = new TextIndexPrefixes.Builder();
                    Map prefMap = (Map)prefixes;
                    if (prefMap.containsKey("max_chars")) {
                        prefBuilder.maxChars(((Integer)prefMap.get("max_chars")).intValue());
                    }
                    if (prefMap.containsKey("min_chars")) {
                        prefBuilder.minChars(((Integer)prefMap.get("min_chars")).intValue());
                    }
                    builder.indexPrefixes(prefBuilder.build());
                }
                builder.searchAnalyzer((String)nativeSettings.get(SEARCH_ANALYZER));
                builder.positionIncrementGap((Integer)nativeSettings.get(POSITION_INCREMENT_GAP));
                builder.norms((Boolean)nativeSettings.get(NORMS));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                if (nativeSettings.get(INDEX_OPTIONS) != null) {
                    builder.indexOptions(IndexOptions.valueOf((String)((String)nativeSettings.get(INDEX_OPTIONS))));
                }
                return builder.build().toProperty();
            }
            case TokenCount: {
                TokenCountProperty.Builder builder = ((TokenCountProperty.Builder)new TokenCountProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case UnsignedLong: {
                UnsignedLongNumberProperty.Builder builder = (UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)new UnsignedLongNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Version: {
                VersionProperty.Builder builder = (VersionProperty.Builder)new VersionProperty.Builder().store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
            case Wildcard: {
                WildcardProperty.Builder builder = (WildcardProperty.Builder)new WildcardProperty.Builder().store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build().toProperty();
            }
        }
        throw new IllegalArgumentException("Unknown property type " + type);
    }

    private static void setSubjectFilter(SearchRequest.Builder searchRequest, MasterResultIterator mri) {
        if (mri.getEntitySubjectFilter() != 0L) {
            IdsQuery queryBuilder = QueryBuilders.ids().values(EntitiesUtil.valueToString((Value)mri.getEntities().get(mri.getEntitySubjectFilter())), new String[0]).build();
            searchRequest.postFilter(queryBuilder.toQuery());
        }
    }

    private static Highlight buildHighlight(SearchOptions searchOptions) {
        Highlight.Builder highlightBuilder = new Highlight.Builder();
        highlightBuilder.fields("*", new HighlightField.Builder().build());
        highlightBuilder.preTags(searchOptions.snippetPre, new String[0]);
        highlightBuilder.postTags(searchOptions.snippetPost, new String[0]);
        if (searchOptions.snippetSize > 0) {
            highlightBuilder.fragmentSize(Integer.valueOf(searchOptions.snippetSize));
        }
        return highlightBuilder.build();
    }

    private static boolean hasNestedHighlighter(Query query) {
        if (query == null) {
            return true;
        }
        boolean result = false;
        if (query.isNested()) {
            InnerHits hits = query.nested().innerHits();
            if (hits != null) {
                result = hits.highlight() != null;
            }
        } else if (query.isBool()) {
            for (Query q : query.bool().should()) {
                result |= OpensearchUtil.hasNestedHighlighter(q);
            }
            if (!result) {
                for (Query q : query.bool().must()) {
                    result |= OpensearchUtil.hasNestedHighlighter(q);
                }
            }
        }
        return result;
    }

    private static <U extends CorePropertyBase.AbstractBuilder> void addCopyAndSimilarityToProperty(U builder, Map<String, ?> nativeSettings) {
        Object copyTo = nativeSettings.get(COPY_TO);
        if (copyTo != null) {
            if (copyTo instanceof List) {
                builder.copyTo((List)copyTo);
            } else {
                builder.copyTo((String)copyTo, new String[0]);
            }
        }
        builder.similarity((String)nativeSettings.get(SIMILARITY));
    }

    private static <U extends PropertyBase.AbstractBuilder> void addIgnoreAboveAndMetaToProperty(U builder, Map<String, ?> nativeSettings) {
        builder.ignoreAbove((Integer)nativeSettings.get(IGNORE_ABOVE));
        Object meta = nativeSettings.get(META);
        if (meta != null) {
            builder.meta((Map)meta);
        }
    }

    private static Property buildNestedProperty(Map<String, Property> properties) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        NestedProperty.Builder builder = (NestedProperty.Builder)new NestedProperty.Builder().properties(properties);
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static Property buildGeopointProperty(Map<String, Property> properties, Boolean stored, Map<String, ?> nativeSettings) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        GeoPointProperty.Builder builder = new GeoPointProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
        builder.store(stored);
        OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
        OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
        builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static Property buildObjectProperty(Map<String, Property> properties) {
        return OpensearchUtil.buildObjectProperty(properties, Collections.emptyMap());
    }

    private static Property buildObjectProperty(Map<String, Property> properties, Map<String, ?> nativeSettings) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        ObjectProperty.Builder builder = ((ObjectProperty.Builder)new ObjectProperty.Builder().properties(properties)).enabled((Boolean)nativeSettings.get(ENABLED));
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    static {
        for (Property.Kind type : Property.Kind.values()) {
            PROPERTY_KIND_MAP.put(type.jsonValue(), type);
        }
    }
}

