/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch;

import com.google.common.collect.Iterables;
import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.mapping.OpensearchUtil;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.slf4j.Logger;

public class OpensearchResult
implements DocumentsResult {
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private final int userSuppliedLimit;
    private final OpenSearchClient queryClient;
    private final SearchRequest.Builder searchBuilder;
    private final int userSuppliedOffset;
    private final List<List<Hit>> previousResultsCache;
    private final String indexName;
    private final Logger logger;
    private final int currentPagingLimit;
    private final int maxResultWindow;
    private int currentPagingOffset;
    private Iterator<Hit> iterator;
    private Hit currentHit;
    private List<Hit> searchHits;
    private Map<String, Aggregate> aggregations;
    private long totalSize;
    private boolean endReachedOnce;
    private boolean noMoreOpenSearchResults;

    OpensearchResult(String indexName, Logger logger, int userSuppliedOffset, int userSuppliedLimit, boolean cacheResults, OpenSearchClient queryClient, SearchRequest.Builder searchBuilder, int maxResultWindow) {
        this.indexName = indexName;
        this.logger = logger;
        this.userSuppliedLimit = userSuppliedLimit;
        this.userSuppliedOffset = userSuppliedOffset;
        this.currentPagingOffset = userSuppliedOffset;
        this.currentPagingLimit = userSuppliedLimit > 0 ? userSuppliedLimit : 1000;
        this.queryClient = queryClient;
        this.searchBuilder = searchBuilder.size(Integer.valueOf(this.currentPagingLimit));
        this.maxResultWindow = maxResultWindow;
        this.previousResultsCache = cacheResults ? new ArrayList<List<Hit>>() : null;
        this.advancePage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void advancePage() {
        SearchResponse searchResponse;
        boolean isAboveMaxResultWindow;
        boolean isFirstPage;
        boolean bl = isFirstPage = this.searchHits == null;
        if (this.userSuppliedLimit != 0 && !isFirstPage) {
            return;
        }
        if (!isFirstPage) {
            this.currentPagingOffset += this.searchHits.size();
        }
        boolean bl2 = isAboveMaxResultWindow = this.currentPagingOffset + this.currentPagingLimit > this.maxResultWindow;
        if (isAboveMaxResultWindow) {
            if (isFirstPage) {
                if (this.currentPagingOffset >= this.maxResultWindow) throw new RuntimeException(this.getMaxResultWindowMessage(0L));
                this.searchBuilder.size(Integer.valueOf(this.maxResultWindow - this.currentPagingOffset));
            } else if (this.currentPagingOffset < this.maxResultWindow) {
                this.searchBuilder.size(Integer.valueOf(this.maxResultWindow - this.currentPagingOffset));
            } else {
                this.iterator = Collections.emptyIterator();
                this.logMaxResultWindowWarning();
                return;
            }
            this.noMoreOpenSearchResults = true;
        }
        this.searchBuilder.from(Integer.valueOf(this.currentPagingOffset));
        try {
            SearchRequest searchRequest = this.searchBuilder.build();
            this.logCurlStatement(searchRequest.query());
            searchResponse = this.queryClient.search(searchRequest, Object.class);
        }
        catch (IOException | OpenSearchException e) {
            OpensearchUtil.handleOpenSearchException("Could not run OpenSearch query", (Exception)e);
            throw new IllegalStateException("Unreachable code reached");
        }
        HitsMetadata hitsMetadata = searchResponse.hits();
        this.totalSize = hitsMetadata.total().value();
        this.searchHits = hitsMetadata.hits();
        if (this.previousResultsCache != null) {
            this.previousResultsCache.add(this.searchHits);
        }
        this.iterator = this.searchHits.iterator();
        if (this.aggregations == null) {
            this.aggregations = searchResponse.aggregations();
        }
        if (!isAboveMaxResultWindow) return;
        this.logMaxResultWindowWarning();
    }

    private void logMaxResultWindowWarning() {
        if (this.totalSize > (long)this.maxResultWindow) {
            this.logger.warn("[{}] {}", (Object)this.indexName, (Object)this.getMaxResultWindowMessage(this.totalSize - (long)this.maxResultWindow));
        }
    }

    private String getMaxResultWindowMessage(long leftOut) {
        return String.format("OpenSearch's offset + limit must be less than or equal to %d but it is %d (offset) + %d (limit) = %d. %sSee OpenSearch's index create option index.max_result_window.", this.maxResultWindow, this.currentPagingOffset, this.currentPagingLimit, this.currentPagingOffset + this.currentPagingLimit, leftOut > 0L ? String.format("The query will only see the first %d hits from OpenSearch (%d more). ", this.maxResultWindow, leftOut) : "");
    }

    public long totalSize() {
        return this.totalSize;
    }

    public double getCurrentScore() {
        return this.currentHit.score();
    }

    public String getCurrentSubject() {
        return this.currentHit.id();
    }

    public Collection<SnippetResult> getCurrentSnippets() {
        ArrayList<SnippetResult> result = new ArrayList<SnippetResult>();
        this.addSnippets(result, this.currentHit, null);
        return result;
    }

    private void addSnippets(List<SnippetResult> snippets, Hit searchHit, @Nullable String innerField) {
        Map highlightFields = searchHit.highlight();
        for (Map.Entry entry : highlightFields.entrySet()) {
            SnippetResult snippet = new SnippetResult((String)entry.getKey(), innerField, (List)entry.getValue());
            snippets.add(snippet);
        }
        Map innerHits = searchHit.innerHits();
        if (innerHits != null) {
            innerHits.forEach((inField, inHits) -> inHits.hits().hits().forEach(inHit -> this.addSnippets(snippets, (Hit)inHit, (String)inField)));
        }
    }

    OpensearchResult getResult() {
        if (this.endReachedOnce && this.previousResultsCache == null) {
            return new OpensearchResult(this.indexName, this.logger, this.userSuppliedOffset, this.userSuppliedLimit, true, this.queryClient, this.searchBuilder, this.maxResultWindow);
        }
        return this;
    }

    public boolean next() {
        boolean hasMore;
        if (this.endReachedOnce) {
            this.endReachedOnce = false;
            this.reset();
        }
        if (hasMore = this.iterator.hasNext()) {
            this.currentHit = this.iterator.next();
        } else if (!this.noMoreOpenSearchResults) {
            this.advancePage();
            boolean bl = hasMore = this.iterator.hasNext() && this.next();
        }
        if (!hasMore) {
            this.endReachedOnce = true;
            this.noMoreOpenSearchResults = true;
        }
        return hasMore;
    }

    private void reset() {
        this.iterator = Iterables.concat(this.previousResultsCache).iterator();
    }

    Map<String, Aggregate> getAggregations() {
        return this.aggregations;
    }

    private void logCurlStatement(Query query) {
        if (this.logger.isDebugEnabled()) {
            String curl = "curl http://localhost:9200/" + this.indexName + "/_search?pretty=1 -d '" + String.valueOf(query) + "'";
            this.logger.debug("Executing " + curl);
        }
    }
}

