/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.plugin;

import com.ontotext.soaas.plugin.Injection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public interface Plugin {
    public Class<?> type();

    public Object get();

    public List<Injection> injectors();

    public static Plugin from(Class<?> clazz) {
        return new PluginIml(clazz);
    }

    public static Plugin from(Object instance) {
        if (instance instanceof Class) {
            return Plugin.from((Class)instance);
        }
        if (instance instanceof Plugin) {
            return (Plugin)instance;
        }
        return new PluginIml(instance);
    }

    public static Plugin fromSupplier(Class<?> type, Supplier<?> supplier) {
        return new LazyPlugin(type, supplier);
    }

    public static class PluginIml
    implements Plugin {
        private final Object instance;
        private final Class<?> clazz;
        private final List<Injection> injectors;

        public PluginIml(Class<?> clazz) {
            this.clazz = Objects.requireNonNull(clazz, "Extension type is required!");
            this.instance = null;
            this.injectors = Injection.scan(clazz);
        }

        public PluginIml(Object instance) {
            this.instance = Objects.requireNonNull(instance, "The instance is required!");
            this.clazz = instance.getClass();
            this.injectors = Injection.scan(this.clazz);
        }

        @Override
        public Class<?> type() {
            return this.clazz;
        }

        @Override
        public Object get() {
            if (this.instance != null) {
                return this.instance;
            }
            try {
                Constructor<?> constructor = this.clazz.getConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public List<Injection> injectors() {
            return this.injectors;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PluginIml)) {
                return false;
            }
            PluginIml pluginIml = (PluginIml)obj;
            return this.clazz.equals(pluginIml.clazz);
        }

        public int hashCode() {
            return Objects.hash(this.clazz);
        }
    }

    public static class LazyPlugin
    implements Plugin {
        private final Class<?> type;
        private final Supplier<?> supplier;
        private final List<Injection> injectors;

        public LazyPlugin(Class<?> type, Supplier<?> supplier) {
            this.type = type;
            this.supplier = supplier;
            this.injectors = Injection.scan(type);
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        @Override
        public Object get() {
            return this.supplier.get();
        }

        @Override
        public List<Injection> injectors() {
            return this.injectors;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LazyPlugin)) {
                return false;
            }
            LazyPlugin that = (LazyPlugin)obj;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }
    }
}

