/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.plugin;

import java.util.Objects;
import java.util.function.Supplier;

public class InjectionValue {
    private final Class<?> type;
    private final Supplier<?> valueSupplier;

    public InjectionValue(Object value) {
        this.type = Objects.requireNonNull(value, "Injection value cannot be null").getClass();
        this.valueSupplier = () -> value;
    }

    public <E> InjectionValue(Class<E> type, Supplier<E> valueSupplier) {
        this.type = type;
        this.valueSupplier = valueSupplier;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getValue() {
        return this.valueSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InjectionValue)) {
            return false;
        }
        InjectionValue that = (InjectionValue)obj;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }
}

