/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.plugin;

import com.ontotext.soaas.plugin.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public interface Injection {
    public void inject(Object var1, Object var2);

    public Class<?> argumentType();

    public boolean required();

    public static List<Injection> scan(Class<?> type) {
        ArrayList<Injection> injectors = new ArrayList<Injection>();
        Consumer<Class> classScanner = clazz -> {
            Injection.from(clazz).ifPresent(injectors::add);
            for (Method method : clazz.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != 1 || !method.isAnnotationPresent(Inject.class) && !method.getParameters()[0].isAnnotationPresent(Inject.class)) continue;
                injectors.add(new MethodInjector(method));
            }
        };
        classScanner.accept(type);
        Arrays.stream(type.getInterfaces()).forEach(classScanner);
        for (Class<?> current = type.getSuperclass(); current != Object.class && current != null; current = current.getSuperclass()) {
            classScanner.accept(current);
            Arrays.stream(current.getInterfaces()).forEach(classScanner);
        }
        return injectors;
    }

    public static Optional<Injection> from(Class<?> clazz) {
        if (clazz.isInterface() && clazz.getMethods().length == 1 && clazz.getMethods()[0].getParameterCount() == 1) {
            return Optional.of(new MethodInjector(clazz.getMethods()[0]));
        }
        return Optional.empty();
    }

    public static Injection from(Class<?> clazz, String methodName) {
        Method method = Arrays.stream(clazz.getMethods()).filter(mtd -> mtd.getName().equals(methodName) && mtd.getParameterCount() == 1).findFirst().orElseThrow(IllegalArgumentException::new);
        return new MethodInjector(method);
    }

    public static class MethodInjector
    implements Injection {
        private final Method method;

        public MethodInjector(Method type) {
            this.method = Objects.requireNonNull(type);
            if (this.method.getParameterCount() != 1) {
                throw new IllegalArgumentException("Only single argument methods are allowed");
            }
        }

        @Override
        public void inject(Object target, Object toInject) {
            if (this.method.getDeclaringClass().isAssignableFrom(target.getClass()) && this.method.getParameterTypes()[0].isInstance(toInject)) {
                try {
                    int modifiers = this.method.getModifiers();
                    if (Modifier.isStatic(modifiers)) {
                        this.method.invoke(null, toInject);
                    } else {
                        this.method.invoke(target, toInject);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }

        @Override
        public Class<?> argumentType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public boolean required() {
            return this.method.isAnnotationPresent(Inject.class);
        }
    }
}

