/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.experimental;

import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.configuration.ConfigurationDefinition;
import com.ontotext.soaas.experimental.ExperimentalFeature;
import com.ontotext.soaas.plugin.PluginsManager;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentalFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static List<ExperimentalFeature> features;

    private ExperimentalFeatures() {
    }

    public static <E extends ExperimentalFeature> E getFeature(Class<E> featureType) {
        return (E)ExperimentalFeatures.getFeatures().stream().filter(featureType::isInstance).map(featureType::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Extension " + String.valueOf(featureType) + " is not registered as a service extension"));
    }

    public static <E> void configureFeatures(BiFunction<String, Class<E>, E> configurationResolver) {
        List<ExperimentalFeature> features = ExperimentalFeatures.getFeatures();
        for (ExperimentalFeature feature : features) {
            HashMap<String, Object> configurations = new HashMap<String, Object>();
            for (ConfigurationDefinition configValue : feature.featureConfigurations()) {
                E property;
                Object config = configValue.getName();
                if (feature.experimental()) {
                    config = "experimental.features." + (String)config;
                }
                if ((property = configurationResolver.apply((String)config, configValue.getValueType())) == null && configValue.getOldName() != null && (property = configurationResolver.apply(configValue.getOldName(), configValue.getValueType())) != null) {
                    LOGGER.warn("The configuration '{}' has been deprecated. It's replaced by '{}'", (Object)configValue.getOldName(), (Object)configValue.getName());
                }
                configurations.put(configValue.getName(), ObjectsUtil.getOrDefault(property, configValue.getDefaultValue()));
            }
            feature.configure(configurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<ExperimentalFeature> getFeatures() {
        if (features != null) return features;
        Class<ExperimentalFeatures> clazz = ExperimentalFeatures.class;
        synchronized (ExperimentalFeatures.class) {
            features = PluginsManager.loadPlugins(ExperimentalFeature.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return features;
        }
    }

    static void resetFeatures() {
        if (features != null) {
            features.clear();
            features = null;
        }
    }
}

