/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.version;

import com.ontotext.soaas.common.version.SemanticVersion;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class VersionUtil {
    private static final String VERSION_POSTSCRIPT = "-";
    private static final String VERSION_SEPARATOR = "\\.";

    private VersionUtil() {
    }

    public static SemanticVersion parseVersion(String version) {
        Objects.requireNonNull(version, "Cannot parse null version!");
        String[] versionParts = VersionUtil.dropVersionPostScript(version).split(VERSION_SEPARATOR);
        int major = VersionUtil.parseVersionPart(versionParts, 0);
        int minor = VersionUtil.parseVersionPart(versionParts, 1);
        int patch = VersionUtil.parseVersionPart(versionParts, 2);
        return new SemanticVersion(major, minor, patch);
    }

    private static String dropVersionPostScript(String version) {
        if (version.contains(VERSION_POSTSCRIPT)) {
            return version.substring(0, version.indexOf(VERSION_POSTSCRIPT));
        }
        return version;
    }

    private static int parseVersionPart(String[] versionParts, int index) {
        if (index < versionParts.length && StringUtils.isNotBlank((CharSequence)versionParts[index])) {
            return Integer.parseInt(versionParts[index]);
        }
        return 0;
    }
}

