/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.sparql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class SparqlPrettyPrinter {
    private static final char[] PREFIX = new char[]{'P', 'R', 'E', 'F', 'I', 'X'};
    private static final char[] BASE = new char[]{'B', 'A', 'S', 'E'};
    private static final char[][] PREFIXES = new char[][]{BASE, PREFIX};
    private static final char[][] PREFIXES_L = SparqlPrettyPrinter.toLowerCase(PREFIXES);
    private static final char[] FILTER = new char[]{'F', 'I', 'L', 'T', 'E', 'R'};
    private static final char[] BIND = new char[]{'B', 'I', 'N', 'D'};
    private static final char[] COUNT = new char[]{'C', 'O', 'U', 'N', 'T'};
    private static final char[] GROUP_CONCAT = new char[]{'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'N', 'C', 'A', 'T'};
    private static final char[][] PROJECTION_FUNCTIONS = new char[][]{COUNT, GROUP_CONCAT};
    private static final char[][] PROJECTION_FUNCTIONS_L = SparqlPrettyPrinter.toLowerCase(PROJECTION_FUNCTIONS);
    private static final char[][] EXPRESSIONS = new char[][]{BIND, FILTER};
    private static final char[][] EXPRESSIONS_L = SparqlPrettyPrinter.toLowerCase(EXPRESSIONS);
    private static final char[] ASK = new char[]{'A', 'S', 'K'};
    private static final char[] SELECT = new char[]{'S', 'E', 'L', 'E', 'C', 'T'};
    private static final char[] SELECT_L = SparqlPrettyPrinter.toLowerCase(SELECT);
    private static final char[] WHERE = new char[]{'W', 'H', 'E', 'R', 'E'};
    private static final char[] CONSTRUCT = new char[]{'C', 'O', 'N', 'S', 'T', 'R', 'U', 'C', 'T'};
    private static final char[] MINUS = new char[]{'M', 'I', 'N', 'U', 'S'};
    private static final char[] OPTIONAL = new char[]{'O', 'P', 'T', 'I', 'O', 'N', 'A', 'L'};
    private static final char[] INSERT = new char[]{'I', 'N', 'S', 'E', 'R', 'T'};
    private static final char[] DELETE = new char[]{'D', 'E', 'L', 'E', 'T', 'E'};
    private static final char[] GRAPH = new char[]{'G', 'R', 'A', 'P', 'H'};
    private static final char[] VALUES = new char[]{'V', 'A', 'L', 'U', 'E', 'S'};
    private static final char[] UNION = new char[]{'U', 'N', 'I', 'O', 'N'};
    private static final char[] SERVICE = new char[]{'S', 'E', 'R', 'V', 'I', 'C', 'E'};
    private static final char[] UNION_L = SparqlPrettyPrinter.toLowerCase(UNION);
    private static final char[] FROM = new char[]{'F', 'R', 'O', 'M'};
    private static final char[][] KEYWORDS = new char[][]{ASK, SELECT, WHERE, CONSTRUCT, BIND, MINUS, OPTIONAL, INSERT, DELETE, GRAPH, VALUES, SERVICE, FROM};
    private static final char[][] KEYWORDS_L = SparqlPrettyPrinter.toLowerCase(KEYWORDS);
    private static final char[] KEYWORD_BOUNDARY = SparqlPrettyPrinter.sorted(' ', '>', '<', '{', '}', '(', ')', '[', ']', '.', '\n', '\r', '\t');

    private static char[] sorted(char ... chars) {
        Arrays.sort(chars);
        return chars;
    }

    private SparqlPrettyPrinter() {
    }

    private static char[] toLowerCase(char[] chars) {
        char[] copy = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            copy[i] = Character.toLowerCase(chars[i]);
        }
        return copy;
    }

    private static char[][] toLowerCase(char[][] chars) {
        char[][] copy = new char[chars.length][];
        for (int i = 0; i < chars.length; ++i) {
            copy[i] = SparqlPrettyPrinter.toLowerCase(chars[i]);
        }
        return copy;
    }

    public static String prettyPrint(String sparql) {
        StringBuilder builder = new StringBuilder();
        PrintState printState = new PrintState();
        LineSplitter lineSplitter = new LineSplitter(sparql);
        for (String line : lineSplitter.getLines()) {
            printState.onNewLine(line);
            printState.tryToFindClosingBracket(line);
            printState.tryToFindOpeningBracket(line);
            String trimmedLine = line.trim();
            if (!trimmedLine.isEmpty()) {
                for (int i = 0; i < printState.getMaxIndentation(); ++i) {
                    builder.append(' ');
                }
            }
            printState.updateIndentationForBrackets();
            printState.onLineEnd(line);
            builder.append(trimmedLine).append("\n");
        }
        return builder.toString();
    }

    private static class PrintState {
        private int indentation = 0;
        private boolean inSelect = false;
        private boolean inMultiline = false;
        private int beginStr;
        private int endStr = -1;
        private int numOfClosingBrackets = 0;
        private int numOfOpeningBrackets = 0;

        private PrintState() {
        }

        void onNewLine(String line) {
            if (this.inSelect && line.contains("WHERE")) {
                this.indentation -= 4;
                this.inSelect = false;
            }
            this.beginStr = 0;
            this.endStr = -1;
            this.beginStr = line.indexOf(39);
            if (this.beginStr >= 0) {
                this.endStr = line.lastIndexOf(39);
            }
            if (this.beginStr == this.endStr || this.endStr < 0) {
                this.beginStr = Integer.MAX_VALUE;
                this.endStr = -1;
            }
        }

        public void tryToFindClosingBracket(String line) {
            this.numOfClosingBrackets = 0;
            int lastClosingBracketPosition = -1;
            while ((lastClosingBracketPosition = line.indexOf(125, lastClosingBracketPosition + 1)) >= 0) {
                if (lastClosingBracketPosition >= this.beginStr && lastClosingBracketPosition <= this.endStr) continue;
                ++this.numOfClosingBrackets;
            }
            if (this.numOfClosingBrackets-- > 0) {
                this.indentation -= 4;
            }
        }

        public void tryToFindOpeningBracket(String line) {
            this.numOfOpeningBrackets = 0;
            int lastOpeningBracketPosition = -1;
            while ((lastOpeningBracketPosition = line.indexOf(123, lastOpeningBracketPosition + 1)) >= 0) {
                if (lastOpeningBracketPosition >= this.beginStr && lastOpeningBracketPosition <= this.endStr) continue;
                ++this.numOfOpeningBrackets;
            }
            if (this.numOfOpeningBrackets > 1) {
                this.indentation += 4 * (this.numOfOpeningBrackets - 1);
                this.numOfOpeningBrackets = 1;
            }
        }

        public int getMaxIndentation() {
            return this.indentation + (this.inMultiline ? 8 : 0);
        }

        public void updateIndentationForBrackets() {
            if (this.numOfClosingBrackets > 0) {
                this.indentation -= 4 * this.numOfClosingBrackets;
            }
            if (this.numOfOpeningBrackets > 0) {
                this.indentation += 4;
            }
        }

        public void onLineEnd(String line) {
            if (line.contains("SELECT")) {
                this.indentation += 4;
                this.inSelect = true;
            }
            if (PrintState.isPrevious(line, line.length(), ';')) {
                this.inMultiline = true;
            }
            if (this.inMultiline && (PrintState.isPrevious(line, line.length(), '.') || PrintState.isPrevious(line, line.length(), ';', '}'))) {
                this.inMultiline = false;
            }
        }

        private static boolean isPrevious(String sparql, int idx, char ... toFind) {
            if (idx == 0) {
                return false;
            }
            int count = toFind.length;
            for (char next : toFind) {
                char charAt;
                do {
                    if (--idx < 0) {
                        return false;
                    }
                    charAt = sparql.charAt(idx);
                    if (charAt != next || --count != 0) continue;
                    return true;
                } while (Character.isWhitespace(charAt));
            }
            return false;
        }
    }

    private static class LineSplitter {
        private final String sparql;
        private List<String> lines = new ArrayList<String>(64);
        private StringBuilder line = new StringBuilder();

        private LineSplitter(String sparql) {
            this.sparql = sparql;
        }

        private List<String> getLines() {
            boolean isInSelectProjection = false;
            boolean passedBracket = false;
            boolean hasPrefix = false;
            AtomicInteger offset = new AtomicInteger(1);
            for (int i = 0; i < this.sparql.length(); i += offset.get()) {
                StringBuilder iri;
                offset.set(1);
                char charAt = this.sparql.charAt(i);
                if (!passedBracket && this.getPrefixIdx(i) != -1) {
                    iri = this.readIri(i);
                    this.newLine().append((CharSequence)iri);
                    offset.set(iri.length());
                    hasPrefix = true;
                    continue;
                }
                if (LineSplitter.isLiteralValueBoundary(charAt)) {
                    this.line.append((CharSequence)this.readLiteralValue(i, offset, charAt));
                    continue;
                }
                if (this.isIriStart(charAt, i)) {
                    iri = this.readIri(i);
                    offset.set(iri.length());
                    this.line.append((CharSequence)iri);
                    continue;
                }
                if (charAt == '{') {
                    passedBracket = true;
                    isInSelectProjection = false;
                    this.handleOpenBracket(i, offset);
                    continue;
                }
                int idx = this.getExpressionIdx(i);
                if (idx != -1) {
                    char[] expression = EXPRESSIONS[idx];
                    this.newLine().append(expression);
                    this.parseExpression(i + expression.length, '(', ')', offset, idx == 0);
                    offset.addAndGet(expression.length);
                    this.line = new StringBuilder();
                    continue;
                }
                idx = this.getKeywordIdx(i);
                if (idx != -1) {
                    this.newLine().append(KEYWORDS[idx]);
                    hasPrefix = this.checkForPrefixSeparatorLine(hasPrefix);
                    offset.set(KEYWORDS[idx].length);
                    isInSelectProjection = this.is(i, SELECT, SELECT_L);
                    continue;
                }
                if (this.isCloseBracket(charAt)) {
                    this.onCloseBracket(i);
                    continue;
                }
                if (this.isProjectionFunction(i, charAt)) {
                    this.newLine();
                    this.parseExpression(i, '(', ')', offset, true);
                    continue;
                }
                if (LineSplitter.isProjectionVariable(isInSelectProjection, charAt)) {
                    this.newLine().append(charAt);
                    continue;
                }
                if (LineSplitter.isLineSeparator(charAt)) {
                    this.newLine();
                    continue;
                }
                if (this.isStatementSeparator(charAt, i, false)) {
                    this.line.append(charAt);
                    this.newLine();
                    continue;
                }
                this.line.append(charAt);
            }
            this.newLine();
            return this.lines;
        }

        private boolean isProjectionFunction(int idx, char charAt) {
            return charAt == '(' && this.getProjectionFunctionIdx(idx + 1) != -1;
        }

        private boolean checkForPrefixSeparatorLine(boolean hasPrefix) {
            if (hasPrefix) {
                this.lines.add("");
                hasPrefix = false;
            }
            return hasPrefix;
        }

        private boolean isIriStart(char charAt, int idx) {
            return charAt == '<' && Character.isLetterOrDigit(this.sparql.charAt(idx + 1));
        }

        private boolean isStatementSeparator(char charAt, int idx, boolean singleLine) {
            return !singleLine && (charAt == ';' || charAt == '.' && idx + 1 < this.sparql.length() && !Character.isDigit(this.sparql.charAt(idx + 1)));
        }

        private void parseExpression(int initial, char open, char close, AtomicInteger offset, boolean singleLine) {
            AtomicInteger openCloseCounter = new AtomicInteger();
            AtomicBoolean foundOpen = new AtomicBoolean(false);
            for (int i = initial; i < this.sparql.length(); i += offset.getAndSet(1)) {
                char charAt = this.sparql.charAt(i);
                if (LineSplitter.shouldExitOnCloseCondition(open, close, openCloseCounter, foundOpen, charAt)) {
                    offset.set(i - initial + 1);
                    this.line.append(charAt).append(this.getTrailingDot(i, offset));
                    break;
                }
                if (LineSplitter.isLiteralValueBoundary(charAt)) {
                    this.line.append((CharSequence)this.readLiteralValue(i, offset, charAt));
                    continue;
                }
                if (this.isIriStart(charAt, i)) {
                    StringBuilder iri = this.readIri(i);
                    offset.set(iri.length());
                    this.line.append((CharSequence)iri);
                    continue;
                }
                if (charAt == '{') {
                    this.handleOpenBracket(i, offset);
                    continue;
                }
                int idx = this.getExpressionIdx(i);
                if (idx != -1) {
                    char[] expression = EXPRESSIONS[idx];
                    this.newLine().append(expression);
                    this.parseExpression(i + expression.length, '(', ')', offset, idx == 0);
                    this.line = new StringBuilder();
                    offset.addAndGet(expression.length);
                    continue;
                }
                idx = this.getKeywordIdx(i);
                if (idx != -1) {
                    this.newLine().append(KEYWORDS[idx]);
                    offset.set(KEYWORDS[idx].length);
                    continue;
                }
                if (this.isCloseBracket(charAt)) {
                    this.onCloseBracket(i);
                    continue;
                }
                if (LineSplitter.isLineSeparator(charAt)) {
                    this.newLine();
                    continue;
                }
                if (this.isStatementSeparator(charAt, i, singleLine)) {
                    this.line.append(charAt);
                    this.newLine();
                    continue;
                }
                this.line.append(charAt);
            }
            this.newLine();
        }

        private String getTrailingDot(int idx, AtomicInteger offset) {
            int end = this.findNext(idx, '.');
            if (end != -1) {
                String substring = this.sparql.substring(idx + 1, end + 1);
                offset.addAndGet(substring.length());
                return substring;
            }
            return "";
        }

        private static boolean shouldExitOnCloseCondition(int open, char close, AtomicInteger openCloseCounter, AtomicBoolean foundOpen, char charAt) {
            if (charAt == open) {
                foundOpen.set(true);
                openCloseCounter.incrementAndGet();
            } else if (charAt == close) {
                openCloseCounter.decrementAndGet();
                return openCloseCounter.get() == 0 && foundOpen.get();
            }
            return false;
        }

        private static boolean isLiteralValueBoundary(char charAt) {
            return charAt == '\"' || charAt == '\'';
        }

        private StringBuilder readLiteralValue(int idx, AtomicInteger offset, char literalType) {
            StringBuilder literal = new StringBuilder();
            literal.append(literalType);
            for (int i = idx + 1; i < this.sparql.length(); ++i) {
                char charAt = this.sparql.charAt(i);
                if (charAt == literalType && this.sparql.charAt(i - 1) != '\\') {
                    literal.append(charAt);
                    if (charAt == '\"' && i + 2 < this.sparql.length() && this.sparql.charAt(i + 1) == '\"' && this.sparql.charAt(i + 2) == '\"') {
                        literal.append(charAt).append(charAt);
                    }
                    offset.set(literal.length());
                    break;
                }
                literal.append(charAt);
            }
            return literal;
        }

        private StringBuilder readIri(int initial) {
            AtomicInteger openCloseCounter = new AtomicInteger();
            StringBuilder iri = new StringBuilder();
            AtomicBoolean foundOpen = new AtomicBoolean(false);
            AtomicInteger offset = new AtomicInteger(1);
            for (int i = initial; i < this.sparql.length(); i += offset.getAndSet(1)) {
                char charAt = this.sparql.charAt(i);
                if (LineSplitter.shouldExitOnCloseCondition(60, '>', openCloseCounter, foundOpen, charAt)) {
                    offset.set(i - initial + 1);
                    iri.append(charAt).append(this.getTrailingDot(i, offset));
                    break;
                }
                iri.append(charAt);
            }
            return iri;
        }

        private boolean isCloseBracket(char charAt) {
            return charAt == '}';
        }

        private void onCloseBracket(int idx) {
            if (StringUtils.isNotBlank((CharSequence)this.line)) {
                this.newLine().append('}');
            } else {
                this.line.append('}');
            }
            if (!this.isNext(idx + 1, UNION, UNION_L) && this.findNext(idx, ')') == -1 && this.findNext(idx, ';') == -1 && this.findNext(idx, '&') == -1 && this.findNext(idx, '|') == -1) {
                this.newLine();
            }
        }

        private void handleOpenBracket(int currentIdx, AtomicInteger offsetCapture) {
            int idx = this.getOpenCloseBracketIdx(currentIdx);
            if (idx != -1) {
                if (!LineSplitter.isPrevious(this.sparql, currentIdx, '}')) {
                    this.line.append(this.sparql, currentIdx, idx + 1);
                    this.newLine();
                } else {
                    this.newLine().append(this.sparql, currentIdx, idx + 1);
                }
                offsetCapture.set(idx + 1 - currentIdx);
            } else if (StringUtils.isNotBlank((CharSequence)this.line) && LineSplitter.isPrevious(this.sparql, currentIdx, '.')) {
                this.newLine();
                this.addLine("{");
            } else {
                this.line.append('{');
                this.newLine();
            }
        }

        private int getOpenCloseBracketIdx(int idx) {
            if (this.sparql.charAt(idx) != '{') {
                return -1;
            }
            return this.findNext(idx, '}');
        }

        private static boolean isProjectionVariable(boolean isInSelectProjection, char charAt) {
            return isInSelectProjection && charAt == '?';
        }

        private static boolean isLineSeparator(char charAt) {
            return charAt == '\n' || charAt == '\r';
        }

        private int findNext(int idx, char toFind) {
            while (++idx < this.sparql.length()) {
                char charAt = this.sparql.charAt(idx);
                if (charAt == toFind) {
                    return idx;
                }
                if (Character.isWhitespace(charAt)) continue;
            }
            return -1;
        }

        private static boolean isPrevious(String sparql, int idx, char toFind) {
            if (idx == 0) {
                return false;
            }
            while (--idx >= 0) {
                char charAt = sparql.charAt(idx);
                if (charAt == toFind) {
                    return true;
                }
                if (Character.isWhitespace(charAt)) continue;
            }
            return false;
        }

        private int getKeywordIdx(int idx) {
            for (int j = 0; j < KEYWORDS.length; ++j) {
                if (!this.is(idx, KEYWORDS[j], KEYWORDS_L[j]) || !this.isLeadingSeparator(idx) || !this.isSeparatorAt(idx + KEYWORDS[j].length)) continue;
                return j;
            }
            return -1;
        }

        private int getExpressionIdx(int idx) {
            for (int j = 0; j < EXPRESSIONS.length; ++j) {
                if (!this.is(idx, EXPRESSIONS[j], EXPRESSIONS_L[j]) || !this.isLeadingSeparator(idx) || !this.isSeparatorAt(idx + EXPRESSIONS[j].length)) continue;
                return j;
            }
            return -1;
        }

        private int getProjectionFunctionIdx(int idx) {
            for (int j = 0; j < PROJECTION_FUNCTIONS.length; ++j) {
                if (!this.is(idx, PROJECTION_FUNCTIONS[j], PROJECTION_FUNCTIONS_L[j]) || !this.isLeadingSeparator(idx) || !this.isSeparatorAt(idx + PROJECTION_FUNCTIONS[j].length)) continue;
                return j;
            }
            return -1;
        }

        private int getPrefixIdx(int idx) {
            if (StringUtils.isNotBlank((CharSequence)this.sparql.substring(0, idx)) && !LineSplitter.isPrevious(this.sparql, idx, '>')) {
                return -1;
            }
            for (int j = 0; j < PREFIXES.length; ++j) {
                if (!this.is(idx, PREFIXES[j], PREFIXES_L[j]) || !this.isSeparatorAt(idx + PREFIXES[j].length)) continue;
                return j;
            }
            return -1;
        }

        private boolean isSeparatorAt(int idx) {
            return Arrays.binarySearch(KEYWORD_BOUNDARY, this.sparql.charAt(idx)) >= 0;
        }

        private boolean isLeadingSeparator(int idx) {
            return idx == 0 || this.isSeparatorAt(idx - 1);
        }

        private StringBuilder newLine() {
            String localLine = this.line.toString();
            this.addLine(localLine);
            this.line = new StringBuilder();
            return this.line;
        }

        private void addLine(String localLine) {
            if (StringUtils.isNotBlank((CharSequence)localLine)) {
                this.lines.add(localLine);
            }
        }

        private boolean is(int idx, char[] test, char[] testLow) {
            if (idx + test.length >= this.sparql.length()) {
                return false;
            }
            for (int j = 0; j < test.length; ++j) {
                char charAt = this.sparql.charAt(idx + j);
                if (charAt == test[j] || charAt == testLow[j]) continue;
                return false;
            }
            return true;
        }

        private boolean isNext(int idx, char[] test, char[] testLow) {
            if (idx + test.length >= this.sparql.length()) {
                return false;
            }
            int currentIdx = 0;
            int testIndex = 0;
            while (testIndex < test.length && this.sparql.length() > idx + currentIdx + 1) {
                char charAt = this.sparql.charAt(idx + currentIdx);
                if (charAt == ' ') {
                    ++currentIdx;
                    continue;
                }
                if (charAt != test[testIndex] && charAt != testLow[testIndex]) {
                    return false;
                }
                ++testIndex;
                ++currentIdx;
            }
            return true;
        }
    }
}

