/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.TripleImpl;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToLongFunction;

public class RdfPath {
    private RdfPath previous;
    private RdfPath next;
    private final long subject;
    private final long predicate;
    private final long object;
    private final EntityPool pool;

    RdfPath(long subject, long predicate, long object, EntityPool pool) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.pool = pool;
    }

    public static RdfPath of(LongTriple node) {
        LongTriple triple = RdfPath.validate(node);
        return new RdfPath(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getPool());
    }

    public static RdfPath ofUnsafe(LongTriple node) {
        return new RdfPath(node.getSubject(), node.getPredicate(), node.getObject(), node.getPool());
    }

    public RdfPath add(LongTriple node) {
        RdfPath longRdfPath;
        if (node.getPool() == this.pool) {
            longRdfPath = RdfPath.of(node);
        } else {
            RdfPath path = node.getPool().toPath(node.getSubject(), node.getPredicate(), node.getObject());
            longRdfPath = this.pool.toLocalPath(path);
        }
        return this.copy().tail().appendInternal(longRdfPath);
    }

    public RdfPath add(String predicate, Object value) {
        RdfPath tail = this.tail();
        if (tail.getPredicate() == 0L && tail.getObject() == 0L) {
            return this.pool.toPath(tail.getSubjectValue(), predicate, value);
        }
        return this.addNotSafe(predicate, value);
    }

    public RdfPath add(long predicate, long value) {
        RdfPath tail = this.tail();
        if (tail.getPredicate() == 0L && tail.getObject() == 0L) {
            return new RdfPath(tail.getSubject(), predicate, value, this.pool);
        }
        return this.addNotSafe(predicate, value);
    }

    RdfPath addNotSafe(String pred, Object val) {
        RdfPath copy = this.copyFrom(this.head());
        return copy.appendNotValidate(new RdfPath(copy.object, this.pool.resolve(pred), this.pool.resolve(val), this.pool));
    }

    RdfPath addNotSafe(long pred, long val) {
        RdfPath copy = this.copyFrom(this.head());
        return copy.appendNotValidate(new RdfPath(copy.object, pred, val, this.pool));
    }

    public RdfPath append(RdfPath pathToAppend) {
        RdfPath copyToAppend = Objects.requireNonNull(pathToAppend, "Cannot append null path!").copy();
        RdfPath currentCopy = this.copy();
        RdfPath newTail = currentCopy.tail().appendInternal(copyToAppend);
        return Objects.requireNonNull(newTail, "Build new null path tail!");
    }

    public <E> E reduce(BiFunction<RdfPath, E, E> reducer) {
        return this.reduce(null, reducer, triple -> true);
    }

    public <E> E reduce(E initialValue, BiFunction<RdfPath, E, E> reducer) {
        return this.reduce(initialValue, reducer, triple -> true);
    }

    public <E> E reduce(E initialValue, BiFunction<RdfPath, E, E> reducer, Predicate<RdfPath> condition) {
        RdfPath current = this.head();
        E result = initialValue;
        do {
            result = reducer.apply(current, result);
        } while (condition.test(current) && (current = current.next) != null);
        return result;
    }

    public long reduceLong(long initialValue, ObjectLongToLongFunction<RdfPath> reducer, Predicate<RdfPath> condition) {
        RdfPath current = this.head();
        long result = initialValue;
        do {
            result = reducer.valueOf((Object)current, result);
        } while (condition.test(current) && (current = current.next) != null);
        return result;
    }

    public int reduceInt(int initialValue, ObjectIntToIntFunction<RdfPath> reducer, Predicate<RdfPath> condition) {
        RdfPath current = this.head();
        int result = initialValue;
        do {
            result = reducer.valueOf((Object)current, result);
        } while (condition.test(current) && (current = current.next) != null);
        return result;
    }

    public RdfPath head() {
        if (this.previous != null) {
            return this.previous.head();
        }
        return this;
    }

    public RdfPath tail() {
        if (this.next == null) {
            return this;
        }
        return this.next.tail();
    }

    public RdfPath trimHead() {
        return this.copyFrom(this).head();
    }

    public RdfPath trimTail() {
        if (!this.hasNext()) {
            return this.copy();
        }
        RdfPath current = this;
        RdfPath newHead = current.copyNode();
        while (current.hasPrevious()) {
            current = current.previous;
            newHead = current.copyNode().appendInternal(newHead).head();
        }
        return newHead;
    }

    public RdfPath copy() {
        return this.copyFrom(this.head()).head();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    private RdfPath copyFrom(RdfPath start) {
        RdfPath current = start;
        RdfPath newTail = current.copyNode();
        while (current.hasNext()) {
            current = current.next;
            newTail = newTail.appendNotValidate(current.copyNode());
        }
        return newTail;
    }

    public RdfPath next() {
        return this.next;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public RdfPath previous() {
        return this.previous;
    }

    private RdfPath appendInternal(RdfPath toAdd) {
        if (toAdd != null) {
            this.validate(this.object, toAdd.subject);
            toAdd.previous = this;
            this.next = toAdd;
        }
        return toAdd;
    }

    private RdfPath appendNotValidate(RdfPath toAdd) {
        if (toAdd != null) {
            toAdd.previous = this;
            this.next = toAdd;
        }
        return toAdd;
    }

    private RdfPath copyNode() {
        return new RdfPath(this.subject, this.predicate, this.object, this.pool);
    }

    private static <V> V validate(V node) {
        return Objects.requireNonNull(node, "Path node cannot be null");
    }

    private void validate(long last, long newNode) {
        if (last != 0L && newNode != 0L && last != newNode) {
            throw new IllegalArgumentException(String.format("The last path value %s does not match the next subject %s", this.pool.get(last), this.pool.get(newNode)));
        }
    }

    public Triple getNode() {
        return new TripleImpl(this.getSubjectValue(), this.getPredicateValue(), this.getObjectValue());
    }

    public LongTriple getLongNode() {
        return new LongTriple(this.subject, this.predicate, this.object, this.pool);
    }

    public long getSubject() {
        return this.subject;
    }

    public long getPredicate() {
        return this.predicate;
    }

    public long getObject() {
        return this.object;
    }

    public String getSubjectValue() {
        return this.pool.getString(this.subject);
    }

    public String getPredicateValue() {
        return this.pool.getString(this.predicate);
    }

    public Object getObjectValue() {
        return this.pool.get(this.object);
    }

    public EntityPool getPool() {
        return this.pool;
    }

    public int depth() {
        return this.previousCount() + 1 + this.nextCount();
    }

    public int nextCount() {
        return this.next != null ? this.next.nextCount() + 1 : 0;
    }

    public int previousCount() {
        return this.previous != null ? this.previous.previousCount() + 1 : 0;
    }

    public String toString() {
        return this.reduce(null, (node, prev) -> (String)(prev != null ? prev + "/" : "") + (String)(prev != null ? "<" + node.getPredicateValue() + "> <" + String.valueOf(node.getObjectValue()) + ">" : node.getNode().toString()), triple -> triple != this);
    }

    public String asString() {
        return this.reduce(null, (node, prev) -> (String)(prev != null ? prev + "/" : "") + (prev != null ? node.getPredicate() + " " + node.getObject() : node.getSubject() + " " + node.getPredicate() + " " + node.getObject()), triple -> triple != this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RdfPath)) {
            return false;
        }
        RdfPath other = (RdfPath)obj;
        if (this.pool != other.getPool()) {
            return Objects.equals(this.toString(), other.toString());
        }
        if (this.depth() != other.depth()) {
            return false;
        }
        RdfPath current = this.head();
        RdfPath otherCurrent = other.head();
        while (current.hasNext()) {
            if (current.subject != otherCurrent.subject || current.predicate != otherCurrent.predicate || current.object != otherCurrent.object) {
                return false;
            }
            current = current.next;
            otherCurrent = otherCurrent.next;
        }
        return true;
    }

    public int hashCode() {
        return this.reduceInt(0, (ObjectIntToIntFunction<RdfPath>)(ObjectIntToIntFunction & Serializable)(node, hash) -> {
            int result = (int)(node.subject ^ node.subject >>> 32);
            result = 31 * result + (int)(node.predicate ^ node.predicate >>> 32);
            result = 31 * result + (int)(node.object ^ node.object >>> 32);
            result = 31 * result + hash;
            return result;
        }, node -> true);
    }

    public boolean matchWildcard(long subject, long predicate, long value) {
        return RdfPath.matches(this.getSubject(), subject) && RdfPath.matches(this.getPredicate(), predicate) && RdfPath.matches(this.getObject(), value);
    }

    private static boolean matches(long value, long template) {
        return template == 0L || template == value;
    }

    public boolean isWildCardPath() {
        boolean result;
        RdfPath current = this.head();
        do {
            result = current.isWildCardNode();
        } while ((current = current.next) != null && !result);
        return result;
    }

    public boolean isWildCardNode() {
        return this.subject == 0L || this.object == 0L;
    }
}

