/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LiteralValue
extends HashMap<String, Serializable> {
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String LANG = "lang";
    private static final String GQL_TYPENAME = "__typename";
    public static final String LITERAL_TYPE = "Literal";
    public static final Set<String> PROPERTIES = Stream.of("value", "lang", "type").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));

    public LiteralValue() {
        super(5, 0.95f);
        this.put(GQL_TYPENAME, LITERAL_TYPE);
    }

    public LiteralValue(Serializable value, String type, String lang) {
        this();
        if (value != null) {
            this.setValue(value);
        }
        if (type != null) {
            this.setType(type);
        }
        if (lang != null) {
            this.setLang(lang);
        }
    }

    public String getType() {
        return Objects.toString(this.get(TYPE), null);
    }

    public void setType(String type) {
        this.put(TYPE, type);
    }

    public Serializable getValue() {
        return (Serializable)this.get(VALUE);
    }

    public void setValue(Serializable value) {
        this.put(VALUE, value);
    }

    public void setLang(String lang) {
        this.put(LANG, lang);
    }

    public String getLang() {
        return Objects.toString(this.get(LANG), null);
    }

    public String getLangLowerCase() {
        return Objects.toString(this.get(LANG), "").toLowerCase();
    }

    public String asLiteral() {
        String lang = this.getLang();
        if (lang == null) {
            return Objects.toString(this.getValue());
        }
        return "\"" + String.valueOf(this.getValue()) + "\"@" + lang;
    }
}

