/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.AbstractRdfTree;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.FastRdfData;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import it.unimi.dsi.fastutil.longs.Long2LongFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;

public class FastRdfTree
extends AbstractRdfTree<FastRdfData>
implements RdfTree {
    public FastRdfTree() {
        this(EntityPoolFactory.fast());
    }

    public FastRdfTree(EntityPool pool) {
        super(pool);
    }

    public FastRdfTree(RdfTree copyFrom) {
        super(copyFrom);
    }

    @Override
    protected AbstractRdfTree.Node createNode(long parentSubject, long parentPredicate, AbstractRdfTree.Node parent) {
        return new FastNode(parentSubject, parentPredicate, parent);
    }

    public FastRdfTree(RdfData rdfData) {
        super(rdfData);
    }

    public FastRdfTree(RdfData rdfData, List<RdfPath> rootResults) {
        super(rdfData, rootResults);
    }

    @Override
    protected void addRootPath(RdfData rdfData, RdfPath parentPath) {
        this.iterateDataMap(rdfData, parentPath, (LongSet)new LongOpenHashSet());
    }

    private void iterateDataMap(RdfData rdfData, RdfPath parentPath, LongSet visited) {
        long subject = parentPath.tail().getObject();
        Long2ObjectMap<LongSet> predicateMap = ((FastRdfData)rdfData).get(subject);
        if (predicateMap == null) {
            return;
        }
        if (!predicateMap.isEmpty()) {
            if (visited.contains(subject)) {
                return;
            }
            visited.add(subject);
        }
        for (Long2ObjectMap.Entry predicateValue : Long2ObjectMaps.fastIterable(predicateMap)) {
            long predicate = predicateValue.getLongKey();
            LongIterator longIterator = ((LongSet)predicateValue.getValue()).longIterator();
            while (longIterator.hasNext()) {
                RdfPath addedPath = this.add(parentPath, predicate, longIterator.nextLong());
                this.iterateDataMap(rdfData, addedPath, visited);
            }
        }
    }

    @Override
    public void merge(RdfTree added) {
        if (added.isEmpty()) {
            return;
        }
        LongStream resultIris = added.getResultIris(null).stream().mapToLong(this.getPool()::resolve);
        LongOpenHashSet results = new LongOpenHashSet();
        resultIris.forEach(arg_0 -> ((LongSet)results).add(arg_0));
        Long2ObjectOpenHashMap knownPaths = new Long2ObjectOpenHashMap();
        this.forEachPath(arg_0 -> FastRdfTree.lambda$merge$1((LongSet)results, (Long2ObjectMap)knownPaths, arg_0));
        Long2LongFunction valueConverter = this.getPool() == added.getPool() ? longParameter -> longParameter : longParameter -> this.toLocal(longParameter, added.getPool());
        added.forEachPath(arg_0 -> this.lambda$merge$4(valueConverter, (Long2ObjectMap)knownPaths, arg_0));
    }

    @Override
    protected <E> Collection<E> createResultCollection() {
        return new ObjectLinkedOpenHashSet();
    }

    private /* synthetic */ void lambda$merge$4(Long2LongFunction valueConverter, Long2ObjectMap knownPaths, RdfPath path) {
        if (path.depth() > 1) {
            RdfPath head = path.head();
            long objectId = valueConverter.get(head.getObject());
            List rdfPaths = (List)knownPaths.getOrDefault(objectId, Collections.emptyList());
            for (RdfPath rdfPath : rdfPaths) {
                this.add(rdfPath.append(this.getPool().toLocalPath(head.next().trimHead())));
            }
        }
    }

    private static /* synthetic */ void lambda$merge$1(LongSet results, Long2ObjectMap knownPaths, RdfPath path) {
        long lastValue = path.tail().getObject();
        if (results.contains(lastValue)) {
            ((List)knownPaths.computeIfAbsent(lastValue, key -> new LinkedList())).add(path);
        }
    }

    private class FastNode
    extends AbstractRdfTree.Node {
        private LongSet values;

        FastNode(long parentSubject, long parentPredicate, AbstractRdfTree.Node parent) {
            super(parentSubject, parentPredicate, parent);
        }

        @Override
        protected void acceptValue(long value) {
            this.getValues().add(value);
        }

        @Override
        protected void forEachValue(LongConsumer consumer) {
            if (this.values == null) {
                return;
            }
            this.values.forEach(consumer);
        }

        @Override
        protected void forEachValue(LongPredicate filter, LongConsumer consumer) {
            long value;
            LongIterator iterator = this.getValues().longIterator();
            while (iterator.hasNext() && filter.test(value = iterator.nextLong())) {
                consumer.accept(value);
            }
        }

        @Override
        protected LongStream streamValues() {
            if (this.values == null) {
                return LongStream.empty();
            }
            return this.values.longStream();
        }

        @Override
        protected boolean hasValue(long object) {
            if (this.values == null) {
                return false;
            }
            return this.values.contains(object);
        }

        @Override
        protected boolean hasValues() {
            return this.values != null && !this.values.isEmpty();
        }

        @Override
        protected void clearValues() {
            if (this.values == null) {
                return;
            }
            this.values.clear();
        }

        @Override
        protected boolean removeValue(long value) {
            if (this.values == null) {
                return false;
            }
            return this.values.remove(value);
        }

        private LongSet getValues() {
            if (this.values == null) {
                this.values = new LongLinkedOpenHashSet(FastRdfTree.this.valueCollectionSize);
            }
            return this.values;
        }

        @Override
        protected void traversePredicate(RdfPath parent, Consumer<RdfPath> pathConsumer, Long2ObjectMap<LongSet> subjPredicates, long subject, long predicate, AbstractRdfTree.Node node) {
            ((LongSet)subjPredicates.computeIfAbsent(subject, key -> new LongLinkedOpenHashSet())).add(predicate);
            FastNode fastNode = (FastNode)node;
            LongIterator it = fastNode.getValues().longIterator();
            while (it.hasNext()) {
                this.traverseNextValueNode(fastNode, parent, subject, predicate, it.nextLong(), pathConsumer);
            }
        }

        @Override
        protected void listValues(RdfPath parent, Consumer<RdfPath> pathConsumer, long subject, LongPredicate isPredicateAllowed) {
            Long2ObjectMap<LongSet> predicateValuesPair = ((FastRdfData)FastRdfTree.this.getIndexData()).get(subject);
            for (Long2ObjectMap.Entry predicateValues : Long2ObjectMaps.fastIterable(predicateValuesPair)) {
                long predicate = predicateValues.getLongKey();
                if (!isPredicateAllowed.test(predicate)) continue;
                LongIterator iterator = ((LongSet)predicateValues.getValue()).longIterator();
                while (iterator.hasNext()) {
                    RdfPath path = this.createOrAppend(parent, subject, predicate, iterator.nextLong());
                    pathConsumer.accept(path);
                }
            }
        }
    }
}

