/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.LazyTriple;
import com.ontotext.soaas.common.rdf.LongPair;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.SimpleValueReader;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractRdfTree<D extends RdfData>
implements RdfTree {
    private final Node nodes = this.createNode(0L, 0L, null);
    private final D indexData;
    protected final int predicateCollectionSize;
    protected final int valueCollectionSize;
    private final EntityPool pool;
    private ValueReader valueReader = SimpleValueReader.INSTANCE;
    private PathIndex pathIndex = new PathIndex();

    public AbstractRdfTree() {
        this(EntityPoolFactory.fast());
    }

    public AbstractRdfTree(EntityPool pool) {
        this.pool = pool;
        this.indexData = pool.emptyData();
        this.predicateCollectionSize = pool.getDefaultPredicateCollectionSize();
        this.valueCollectionSize = pool.getDefaultValueCollectionSize();
    }

    public AbstractRdfTree(RdfTree copyFrom) {
        this(copyFrom.getPool());
        this.setValueReader(copyFrom.getValueReader());
        copyFrom.forEachPath(this::add);
    }

    protected abstract Node createNode(long var1, long var3, Node var5);

    protected Node getRootNode() {
        return this.nodes;
    }

    protected D getIndexData() {
        return this.indexData;
    }

    public AbstractRdfTree(RdfData rdfData) {
        this(rdfData.getPool());
        Objects.requireNonNull(rdfData, "Input data is required!");
        List<RdfPath> rootResults = rdfData.getTriples("http://www.ontotext.com/semantic-object/result/", null, null).stream().map(triple -> this.pool.toPath(triple.getSubject(), triple.getPredicate(), triple.getObject())).collect(Collectors.toList());
        if (rootResults.isEmpty() && !rdfData.isEmpty()) {
            throw new IllegalArgumentException("At least one root result should be provided");
        }
        this.convertRdfDataToTree(rdfData, rootResults);
    }

    public AbstractRdfTree(RdfData rdfData, List<RdfPath> rootResults) {
        this(rdfData.getPool());
        Objects.requireNonNull(rdfData, "Input data is required!");
        Objects.requireNonNull(rootResults, "root results are required!");
        if (rootResults.isEmpty()) {
            throw new IllegalArgumentException("At least one root result should be provided");
        }
        this.convertRdfDataToTree(rdfData, rootResults);
    }

    private void convertRdfDataToTree(RdfData rdfData, List<RdfPath> rootResults) {
        rootResults.replaceAll(this.pool::toLocalPath);
        rootResults.forEach(this::add);
        for (RdfPath rootResult : rootResults) {
            this.addRootPath(rdfData, rootResult);
        }
        this.indexData.merge(rdfData);
    }

    protected abstract void addRootPath(RdfData var1, RdfPath var2);

    @Override
    public int add(RdfPath path) {
        path = this.pool.toLocalPath(path);
        this.getRootNode().add(Objects.requireNonNull(path, "LongRdfPath cannot be null"));
        RdfPath head = path.head();
        int objects = this.indexData.add(head.getSubject(), head.getPredicate(), head.getObject());
        RdfPath tail = path.tail();
        if (head != tail) {
            objects = this.indexData.add(tail.getSubject(), tail.getPredicate(), tail.getObject());
        }
        this.pathIndex.updateIndex(tail);
        return objects;
    }

    @Override
    public RdfPath add(RdfPath path, long predicate, long object) {
        RdfPath newPath = this.pool.toLocalPath(path).tail().add(predicate, object);
        this.add(newPath);
        return newPath;
    }

    @Override
    public RdfPath add(RdfPath path, String predicate, Object object) {
        long predicateId = this.pool.resolve(predicate);
        long objectId = this.pool.resolve(object);
        RdfPath newPath = this.pool.toLocalPath(path).tail().add(predicateId, objectId);
        this.add(newPath);
        return newPath;
    }

    @Override
    public int add(String subject, String predicate, Object object) {
        Objects.requireNonNull(subject, "Subject cannot be null");
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        Objects.requireNonNull(object, "Object cannot be null");
        long subjectId = this.pool.resolve(subject);
        long predicateId = this.pool.resolve(predicate);
        long objectId = this.pool.resolve(object);
        this.getRootNode().add(subjectId, predicateId, objectId);
        this.pathIndex.updateIndex(this.pool.toPath(subjectId, predicateId, objectId));
        return this.indexData.add(subjectId, predicateId, objectId);
    }

    @Override
    public int addLiteral(long subject, long predicate, long object) {
        return this.indexData.add(subject, predicate, object);
    }

    @Override
    public boolean remove(RdfPath path) {
        path = this.pool.toLocalPath(path);
        Node node = this.getRootNode().selectNode(path.head());
        if (node == null) {
            return false;
        }
        RdfPath tail = path.tail();
        return node.remove(tail, this.updateIndexOnRemovedNode().andThen(this.pathIndex.updatePathIndexOnDelete(tail)));
    }

    private DeleteListener updateIndexOnRemovedNode() {
        return (subject, predicate, object) -> {
            if (subject == 0L) {
                return;
            }
            this.indexData.remove(subject, predicate, object);
        };
    }

    @Override
    public void moveTo(RdfPath newParent) {
        newParent = this.pool.toLocalPath(newParent);
        RdfPath parentTail = newParent.tail();
        long oldRoot = parentTail.getObject();
        ArrayList pathsToMove = new ArrayList();
        this.forEachPath(path -> {
            if (path.head().matchWildcard(0L, 0L, oldRoot)) {
                pathsToMove.add(path);
            }
        });
        pathsToMove.forEach(this::remove);
        for (RdfPath toMove : pathsToMove) {
            RdfPath headToMove = toMove.head();
            if (!headToMove.hasNext()) continue;
            this.add(parentTail.append(headToMove.next().trimHead()));
        }
    }

    @Override
    public Collection<String> getResultIris(String queryName) {
        return this.indexData.getResultIris(queryName);
    }

    @Override
    public Collection<RdfPath> selectResults(String queryName) {
        long subjectId = this.pool.resolve("http://www.ontotext.com/semantic-object/result/");
        long predicateId = this.pool.resolve(queryName == null ? null : "http://www.ontotext.com/semantic-object/result/" + queryName);
        long objectId = 0L;
        Collection<LongTriple> triples = this.indexData.getTriples(subjectId, predicateId, objectId);
        return triples.stream().map(RdfPath::ofUnsafe).collect(Collectors.toCollection(() -> new ArrayList(triples.size())));
    }

    @Override
    public Collection<Triple> getAllTriples() {
        Collection<Triple> triples = this.createResultCollection();
        this.getRootNode().forEachPath(path -> triples.add(path.tail().getNode()));
        return triples;
    }

    @Override
    public Collection<Triple> select(RdfPath pathPattern) {
        if (pathPattern == null) {
            return Collections.emptyList();
        }
        if (this.pathIndex.canUseIndex(pathPattern) && pathPattern.depth() > 1) {
            return this.pathIndex.doIndexSearch(pathPattern);
        }
        return this.getRootNode().traverse(this.pool.toLocalPath(pathPattern.head()));
    }

    @Override
    public Collection<Triple> findAtAnyDepth(String subject, String predicate, Object value) {
        return this.indexData.getTriples(subject, predicate, value);
    }

    @Override
    public Collection<LongTriple> findAtAnyDepth(long subject, long predicate, long value) {
        return this.indexData.getTriples(subject, predicate, value);
    }

    @Override
    public boolean contains(long subject, long predicate, long value) {
        return this.indexData.contains(subject, predicate, value);
    }

    @Override
    public Collection<RdfPath> selectPaths(RdfPath pathPattern) {
        ArrayList<RdfPath> result = new ArrayList<RdfPath>();
        this.forEachPath(path -> {
            if (AbstractRdfTree.matchPath(pathPattern).test((RdfPath)path)) {
                result.add((RdfPath)path);
            }
        });
        return result;
    }

    private static Predicate<? super RdfPath> matchPath(RdfPath pattern) {
        return path -> {
            if (path.depth() != pattern.depth()) {
                return false;
            }
            RdfPath current = path.head();
            RdfPath currentPattern = pattern.head();
            while (true) {
                if (!AbstractRdfTree.matchPaths(current, currentPattern)) {
                    return false;
                }
                if (!current.hasNext()) break;
                current = current.next();
                currentPattern = currentPattern.next();
            }
            return true;
        };
    }

    private static boolean matchPaths(RdfPath path, RdfPath pattern) {
        return path.matchWildcard(pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    @Override
    public Stream<RdfPath> inOrderStream() {
        return this.getRootNode().inOrderStream();
    }

    @Override
    public Stream<RdfPath> preOrderStream() {
        return this.getRootNode().preOrderStream();
    }

    @Override
    public Collection<String> getPath(String ... path) {
        if (path == null || path.length == 0) {
            return this.getQueries().stream().flatMap(iri -> this.getResultIris((String)iri).stream()).collect(Collectors.toList());
        }
        RdfPath rdfPath = this.pool.toPath("http://www.ontotext.com/semantic-object/result/", path[0] == null ? null : "http://www.ontotext.com/semantic-object/result/" + path[0], null);
        for (int i = 1; i < path.length; ++i) {
            rdfPath = rdfPath.add(this.pool.toTriple(null, path[i], null));
        }
        return this.select(rdfPath).stream().map(Triple::getObject).map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    protected long toLocal(long value, EntityPool otherPool) {
        return this.pool.resolve(otherPool.get(value));
    }

    @Override
    public void setValueReader(ValueReader valueReader) {
        this.valueReader = valueReader;
    }

    @Override
    public ValueReader getValueReader() {
        return this.valueReader;
    }

    @Override
    public EntityPool getPool() {
        return this.pool;
    }

    @Override
    public void forEach(Consumer<Triple> tripleConsumer) {
        this.indexData.forEach(tripleConsumer);
    }

    @Override
    public void forEachPath(Consumer<RdfPath> pathConsumer) {
        this.nodes.forEachPath(pathConsumer);
    }

    protected <E> Collection<E> createResultCollection() {
        return new LinkedHashSet();
    }

    protected abstract class Node {
        private final long parentSubject;
        private final long parentPredicate;
        private final Node parent;
        protected Long2ObjectMap<Long2ObjectMap<Node>> data;

        Node(long parentSubject, long parentPredicate, Node parent) {
            this.parentSubject = parentSubject;
            this.parentPredicate = parentPredicate;
            this.parent = parent;
        }

        Node add(long subject, long predicate, long object) {
            this.addValue(subject);
            return ((Node)((Long2ObjectMap)this.getData().computeIfAbsent(subject, key -> this.createPredicatesCollection())).computeIfAbsent(predicate, key -> AbstractRdfTree.this.createNode(subject, key, this))).addValue(object);
        }

        Node add(RdfPath path) {
            return path.reduce((node, childNode) -> {
                if (childNode == null) {
                    return this.add(node.getSubject(), node.getPredicate(), node.getObject());
                }
                return childNode.add(node.getSubject(), node.getPredicate(), node.getObject());
            });
        }

        private Long2ObjectLinkedOpenHashMap<Node> createPredicatesCollection() {
            return new Long2ObjectLinkedOpenHashMap(AbstractRdfTree.this.predicateCollectionSize);
        }

        private Node addValue(long object) {
            if (object != 0L) {
                this.acceptValue(object);
            }
            return this;
        }

        protected abstract void acceptValue(long var1);

        protected abstract void forEachValue(LongConsumer var1);

        protected abstract void forEachValue(LongPredicate var1, LongConsumer var2);

        protected abstract LongStream streamValues();

        protected abstract boolean hasValue(long var1);

        private Long2ObjectMap<Long2ObjectMap<Node>> getData() {
            if (this.data == null) {
                this.data = new Long2ObjectLinkedOpenHashMap(AbstractRdfTree.this.valueCollectionSize);
            }
            return this.data;
        }

        protected abstract boolean hasValues();

        protected abstract void clearValues();

        protected abstract boolean removeValue(long var1);

        void forEachPath(Consumer<RdfPath> pathConsumer) {
            this.traverseDepthFirst(null, pathConsumer);
        }

        protected void traverseDepthFirst(RdfPath parent, Consumer<RdfPath> pathConsumer) {
            if (this.data == null || this.data.isEmpty()) {
                if (parent != null) {
                    long subject = parent.tail().getObject();
                    this.listValues(parent, pathConsumer, subject, p -> true);
                }
                return;
            }
            Long2ObjectLinkedOpenHashMap subjPredicates = new Long2ObjectLinkedOpenHashMap();
            boolean foundMatchingSubject = this.traverseSubjects(parent, pathConsumer, (Long2ObjectMap<LongSet>)subjPredicates);
            if (subjPredicates.isEmpty()) {
                if (parent != null && !foundMatchingSubject) {
                    long subject = parent.tail().getObject();
                    this.listValues(parent, pathConsumer, subject, p -> true);
                }
            } else if (parent != null) {
                Long2ObjectMaps.fastForEach((Long2ObjectMap)subjPredicates, entry -> this.listValues(parent, pathConsumer, entry.getLongKey(), p -> !((LongSet)entry.getValue()).contains(p)));
            }
        }

        protected boolean traverseSubjects(RdfPath parent, Consumer<RdfPath> pathConsumer, Long2ObjectMap<LongSet> subjPredicates) {
            boolean foundMatchingSubject = false;
            if (parent != null) {
                Long2ObjectMap predicates = (Long2ObjectMap)this.data.getOrDefault(parent.getObject(), (Object)Long2ObjectMaps.emptyMap());
                long subject = parent.getObject();
                for (Long2ObjectMap.Entry perPredicate : predicates.long2ObjectEntrySet()) {
                    foundMatchingSubject = true;
                    long predicate = perPredicate.getLongKey();
                    Node node = (Node)perPredicate.getValue();
                    this.traversePredicate(parent, pathConsumer, subjPredicates, subject, predicate, node);
                }
            } else {
                for (Long2ObjectMap.Entry perSubject : this.data.long2ObjectEntrySet()) {
                    long subject = perSubject.getLongKey();
                    for (Long2ObjectMap.Entry perPredicate : ((Long2ObjectMap)perSubject.getValue()).long2ObjectEntrySet()) {
                        foundMatchingSubject = true;
                        long predicate = perPredicate.getLongKey();
                        Node node = (Node)perPredicate.getValue();
                        this.traversePredicate(parent, pathConsumer, subjPredicates, subject, predicate, node);
                    }
                }
            }
            return foundMatchingSubject;
        }

        protected abstract void traversePredicate(RdfPath var1, Consumer<RdfPath> var2, Long2ObjectMap<LongSet> var3, long var4, long var6, Node var8);

        protected void traverseNextValueNode(Node node, RdfPath parent, long subject, long predicate, long value, Consumer<RdfPath> pathConsumer) {
            RdfPath path = this.createOrAppend(parent, subject, predicate, value);
            pathConsumer.accept(path);
            node.traverseDepthFirst(path, pathConsumer);
        }

        protected abstract void listValues(RdfPath var1, Consumer<RdfPath> var2, long var3, LongPredicate var5);

        protected RdfPath createOrAppend(RdfPath parent, long subject, long predicate, long value) {
            if (parent == null) {
                return new RdfPath(subject, predicate, value, AbstractRdfTree.this.pool);
            }
            return parent.addNotSafe(predicate, value);
        }

        Stream<RdfPath> inOrderStream() {
            return this.stream(null, this.inOder());
        }

        Stream<RdfPath> preOrderStream() {
            return this.stream(null, this.preOder());
        }

        private BiFunction<RdfPath, Node, Stream<RdfPath>> preOder() {
            return (path, node) -> Stream.concat(Stream.of(path), node.stream((RdfPath)path, this.preOder()));
        }

        private BiFunction<RdfPath, Node, Stream<RdfPath>> inOder() {
            return (path, node) -> Stream.concat(node.stream((RdfPath)path, this.inOder()), Stream.of(path));
        }

        Stream<RdfPath> stream(RdfPath parent, BiFunction<RdfPath, Node, Stream<RdfPath>> order) {
            if (this.data == null || this.data.isEmpty()) {
                return Stream.empty();
            }
            return this.data.long2ObjectEntrySet().stream().filter(this.filterByParent(parent)).flatMap(subjectEntry -> ((Long2ObjectMap)subjectEntry.getValue()).long2ObjectEntrySet().stream().flatMap(predicateEntry -> this.iterateValues(parent, subjectEntry.getLongKey(), predicateEntry.getLongKey(), (Node)predicateEntry.getValue(), order)));
        }

        private Predicate<Long2ObjectMap.Entry<Long2ObjectMap<Node>>> filterByParent(RdfPath parent) {
            return entry -> parent == null || parent.tail().getObject() == entry.getLongKey();
        }

        protected Stream<RdfPath> iterateValues(RdfPath parent, long subject, long predicate, Node subNode, BiFunction<RdfPath, Node, Stream<RdfPath>> order) {
            return subNode.streamValues().mapToObj(this.applyOrder(parent, subject, predicate, subNode, order)).flatMap(Function.identity());
        }

        protected LongFunction<Stream<RdfPath>> applyOrder(RdfPath parent, long subject, long predicate, Node subNode, BiFunction<RdfPath, Node, Stream<RdfPath>> order) {
            return value -> (Stream)order.apply(this.createOrAppend(parent, subject, predicate, value), subNode);
        }

        Collection<Triple> traverse(RdfPath path) {
            Collection<Triple> resultTriples = AbstractRdfTree.this.createResultCollection();
            this.traverseInternal(path, (triple, node) -> resultTriples.add((Triple)triple));
            return resultTriples;
        }

        private void traverseInternal(RdfPath path, BiConsumer<Triple, Node> resultConsumer) {
            if (path == null) {
                return;
            }
            long subject = path.getSubject();
            long predicate = path.getPredicate();
            long object = path.getObject();
            if (subject != 0L) {
                if (predicate != 0L) {
                    this.filterByKnownPredicate(resultConsumer, subject, predicate, object, path.next());
                } else {
                    this.filterByAnyPredicate(resultConsumer, subject, object, path.next());
                }
            } else if (predicate != 0L) {
                this.filterByPredicate(resultConsumer, predicate, object, path.next());
            } else {
                this.filterByObject(resultConsumer, object, path.next());
            }
        }

        private void filterByObject(BiConsumer<Triple, Node> resultTriples, long object, RdfPath next) {
            if (this.data == null) {
                return;
            }
            LongPredicate valueTest = this.valueComparator(object);
            for (Long2ObjectMap.Entry perSubject : this.data.long2ObjectEntrySet()) {
                for (Long2ObjectMap.Entry perPredicate : ((Long2ObjectMap)perSubject.getValue()).long2ObjectEntrySet()) {
                    long subj = perSubject.getLongKey();
                    long pred = perPredicate.getLongKey();
                    Node node = (Node)perPredicate.getValue();
                    if (next == null) {
                        this.iterateValuesWithFilter(node, subj, pred, valueTest, resultTriples);
                        continue;
                    }
                    if (!this.hasValues()) continue;
                    node.traverseInternal(next, resultTriples);
                }
            }
        }

        protected void iterateValuesWithFilter(Node node, long subj, long pred, LongPredicate valueTest, BiConsumer<Triple, Node> resultTriples) {
            node.forEachValue(valueTest, value -> resultTriples.accept(new LazyTriple(subj, pred, value, AbstractRdfTree.this.getPool()), node));
        }

        protected LongPredicate valueComparator(long object) {
            return other -> object == other;
        }

        private void filterByPredicate(BiConsumer<Triple, Node> resultTriples, long predicate, long object, RdfPath next) {
            if (this.data == null) {
                return;
            }
            for (Long2ObjectMap.Entry perSubject : this.data.long2ObjectEntrySet()) {
                long subject = perSubject.getLongKey();
                Long2ObjectMap predicates = (Long2ObjectMap)perSubject.getValue();
                Node node = (Node)predicates.get(predicate);
                if (node == null) continue;
                if (object != 0L) {
                    this.returnValueOrContinue(subject, predicate, object, next, node, resultTriples);
                    continue;
                }
                this.appendNodeValuesOrContinue(subject, predicate, resultTriples, next, node);
            }
        }

        private void appendNodeValuesOrContinue(long subject, long predicate, BiConsumer<Triple, Node> resultTriples, RdfPath next, Node node) {
            if (next == null) {
                this.appendValues(subject, predicate, resultTriples, node);
            } else {
                node.traverseInternal(next, resultTriples);
            }
        }

        private void appendValues(long subject, long predicate, BiConsumer<Triple, Node> resultTriples, Node node) {
            node.forEachValue(value -> resultTriples.accept(new LazyTriple(subject, predicate, value, AbstractRdfTree.this.pool), node));
        }

        private void filterByKnownPredicate(BiConsumer<Triple, Node> resultTriples, long subject, long predicate, long object, RdfPath next) {
            if (this.data == null) {
                return;
            }
            Long2ObjectMap predicates = (Long2ObjectMap)this.data.get(subject);
            if (predicates == null) {
                return;
            }
            Node node = (Node)predicates.get(predicate);
            if (node == null) {
                return;
            }
            if (object != 0L) {
                this.returnValueOrContinue(subject, predicate, object, next, node, resultTriples);
            } else {
                this.appendNodeValuesOrContinue(subject, predicate, resultTriples, next, node);
            }
        }

        private void filterByAnyPredicate(BiConsumer<Triple, Node> resultTriples, long subject, long object, RdfPath next) {
            if (this.data == null) {
                return;
            }
            Long2ObjectMap predicates = (Long2ObjectMap)this.data.get(subject);
            if (predicates == null) {
                return;
            }
            for (Long2ObjectMap.Entry perPredicate : predicates.long2ObjectEntrySet()) {
                long pred = perPredicate.getLongKey();
                Node node = (Node)perPredicate.getValue();
                if (object != 0L) {
                    this.returnValueOrContinue(subject, pred, object, next, node, resultTriples);
                    continue;
                }
                this.appendNodeValuesOrContinue(subject, pred, resultTriples, next, node);
            }
        }

        private void returnValueOrContinue(long subject, long pred, long object, RdfPath next, Node node, BiConsumer<Triple, Node> resultTriples) {
            if (node.hasValue(object)) {
                if (next == null) {
                    resultTriples.accept(new LazyTriple(subject, pred, object, AbstractRdfTree.this.pool), node);
                } else {
                    node.traverseInternal(next, resultTriples);
                }
            }
        }

        Node selectNode(RdfPath path) {
            if (path == null) {
                return this;
            }
            LinkedList deque = new LinkedList();
            this.traverseInternal(path, (triple, node) -> deque.add(node));
            if (deque.isEmpty()) {
                return null;
            }
            return (Node)deque.getLast();
        }

        boolean isEmpty() {
            return !this.hasValues() && (this.data == null || this.data.isEmpty());
        }

        public boolean remove(RdfPath path, DeleteListener removedNodeLister) {
            boolean removed = this.removeValueNode(path.getObject(), removedNodeLister);
            if (removed && this.parent != null) {
                this.parent.removeEmptyChildNode(this, removedNodeLister);
            }
            return removed;
        }

        private void removeEmptyChildNode(Node node, DeleteListener removedNodeLister) {
            if (!node.isEmpty()) {
                return;
            }
            Long2ObjectMap predicates = (Long2ObjectMap)this.getData().get(node.parentSubject);
            if (predicates == null) {
                return;
            }
            Node foundNode = (Node)predicates.get(node.parentPredicate);
            if (foundNode != null) {
                this.removeValueNode(node.parentSubject, removedNodeLister);
                if (this.parent != null) {
                    this.parent.removeEmptyChildNode(this, removedNodeLister);
                }
            }
        }

        private boolean removeValueNode(long value, DeleteListener removedNodeLister) {
            List nodesToRemove;
            Long2ObjectMap<Long2ObjectMap<Node>> localData = this.getData();
            boolean removedAnything = false;
            if (value == 0L) {
                this.forEachValue(each -> removedNodeLister.onDelete(this.parentSubject, this.parentPredicate, each));
                removedAnything = this.hasValues();
                this.clearValues();
                if (localData.isEmpty()) {
                    return true;
                }
                nodesToRemove = localData.long2ObjectEntrySet().stream().flatMap(perSubject -> ((Long2ObjectMap)perSubject.getValue()).long2ObjectEntrySet().stream().map(perPredicate -> Pair.of((Object)LongPair.of(perSubject.getLongKey(), perPredicate.getLongKey()), (Object)((Node)perPredicate.getValue())))).collect(Collectors.toList());
            } else {
                Long2ObjectMap predicates = (Long2ObjectMap)localData.getOrDefault(value, (Object)Long2ObjectMaps.emptyMap());
                nodesToRemove = predicates.long2ObjectEntrySet().stream().map(perPredicate -> Pair.of((Object)LongPair.of(value, perPredicate.getLongKey()), (Object)((Node)perPredicate.getValue()))).collect(Collectors.toList());
                if (this.removeValue(value)) {
                    removedNodeLister.onDelete(this.parentSubject, this.parentPredicate, value);
                    removedAnything = true;
                }
            }
            for (Pair entry : nodesToRemove) {
                long subject = ((LongPair)entry.getKey()).getFirst();
                long predicate = ((LongPair)entry.getKey()).getSecond();
                Node node = (Node)entry.getValue();
                Long2ObjectMap predicates = (Long2ObjectMap)localData.get(subject);
                if (!predicates.remove(predicate, (Object)node)) continue;
                if (predicates.isEmpty()) {
                    localData.remove(subject);
                }
                removedAnything = true;
                node.forEachValue(val -> removedNodeLister.onDelete(subject, predicate, val));
            }
            return removedAnything;
        }
    }

    private class PathIndex {
        private Object2ObjectMap<PathIndexKey, Long2ObjectMap<LongSet>> index = new Object2ObjectOpenHashMap();
        private Int2ObjectMap<LongList> pathHashCache = new Int2ObjectOpenHashMap(128);

        private PathIndex() {
        }

        private PathIndexKey createNewKey(RdfPath path) {
            if (path.hasPrevious()) {
                int pathHash = this.toPathHash(path);
                this.pathHashCache.computeIfAbsent(pathHash, hash -> this.toPredicatePath(path));
                return new PathIndexKey(path.getSubject(), pathHash);
            }
            return new PathIndexKey(path.getSubject(), 0);
        }

        private int toPathHash(RdfPath path) {
            RdfPath current = path;
            int hash = 1;
            while (current.hasPrevious()) {
                current = current.previous();
                long predicate = current.getPredicate();
                hash = 31 * hash + HashCommon.long2int((long)predicate);
            }
            return hash;
        }

        private LongList toPredicatePath(RdfPath path) {
            LongArrayList predicates = new LongArrayList(path.previousCount() + 1);
            RdfPath current = path;
            while (current.hasPrevious()) {
                current = current.previous();
                predicates.add(current.getPredicate());
            }
            return predicates;
        }

        private PathIndexKey fromPath(RdfPath path) {
            if (path.hasPrevious()) {
                return new PathIndexKey(path.getSubject(), this.toPathHash(path));
            }
            return new PathIndexKey(path.getSubject(), 0);
        }

        boolean canUseIndex(RdfPath pathPattern) {
            return pathPattern.getSubject() != 0L && pathPattern.reduce(true, (path, previous) -> {
                if (path.getPredicate() == 0L) {
                    return false;
                }
                return previous;
            }) != false;
        }

        Collection<Triple> doIndexSearch(RdfPath pathPattern) {
            RdfPath tail = pathPattern.tail();
            PathIndexKey key = this.fromPath(tail);
            LongSet values = (LongSet)((Long2ObjectMap)this.index.getOrDefault((Object)key, (Object)Long2ObjectMaps.emptyMap())).getOrDefault(tail.getPredicate(), (Object)LongSets.emptySet());
            if (values.isEmpty()) {
                return Collections.emptySet();
            }
            Collection<Triple> resultCollection = AbstractRdfTree.this.createResultCollection();
            for (Long value : values) {
                resultCollection.add(new LazyTriple(tail.getSubject(), tail.getPredicate(), value, AbstractRdfTree.this.pool));
            }
            return resultCollection;
        }

        void updateIndex(RdfPath path) {
            if (!path.hasPrevious()) {
                return;
            }
            PathIndexKey indexKey = this.createNewKey(path);
            ((LongSet)((Long2ObjectMap)this.index.computeIfAbsent((Object)indexKey, key -> this.createPredicatesCollection())).computeIfAbsent(path.getPredicate(), key -> this.createValuesCollection())).add(path.getObject());
            if (path.hasPrevious()) {
                this.updateIndex(path.previous());
            }
        }

        private Long2ObjectOpenHashMap<LongSet> createPredicatesCollection() {
            return new Long2ObjectOpenHashMap(AbstractRdfTree.this.predicateCollectionSize);
        }

        private LongLinkedOpenHashSet createValuesCollection() {
            return new LongLinkedOpenHashSet(AbstractRdfTree.this.valueCollectionSize);
        }

        DeleteListener updatePathIndexOnDelete(RdfPath tail) {
            Collection<RdfPath> rdfPaths = null;
            if (!this.canUseIndex(tail)) {
                rdfPaths = AbstractRdfTree.this.selectPaths(tail);
            }
            Collection<RdfPath> precomputedPaths = rdfPaths;
            return (subject, predicate, object) -> {
                if (subject == 0L || subject != tail.getSubject() && tail.getSubject() != 0L) {
                    return;
                }
                if (this.canUseIndex(tail)) {
                    PathIndexKey indexKey = this.fromPath(tail);
                    this.removeFromPathIndex(indexKey, predicate, object);
                    return;
                }
                if (precomputedPaths != null) {
                    for (RdfPath precomputedPath : precomputedPaths) {
                        RdfPath pathEnd = precomputedPath.tail();
                        PathIndexKey indexKey = this.fromPath(pathEnd);
                        this.removeFromPathIndex(indexKey, pathEnd.getPredicate(), pathEnd.getObject());
                    }
                }
            };
        }

        void removeFromPathIndex(PathIndexKey indexKey, long predicate, long value) {
            Long2ObjectMap predicateValues = (Long2ObjectMap)this.index.get((Object)indexKey);
            if (predicateValues == null) {
                return;
            }
            LongSet values = (LongSet)predicateValues.get(predicate);
            if (values != null) {
                values.remove(value);
                if (values.isEmpty()) {
                    predicateValues.remove(predicate);
                }
            }
            if (predicateValues.isEmpty()) {
                this.index.remove((Object)indexKey);
            }
            PathIndexKey next = indexKey.next(predicate, value, this.pathHashCache);
            this.removeFromPathIndex(next);
        }

        void removeFromPathIndex(PathIndexKey indexKey) {
            Long2ObjectMap predicateValues = (Long2ObjectMap)this.index.get((Object)indexKey);
            if (predicateValues == null) {
                return;
            }
            this.index.remove((Object)indexKey);
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable((Long2ObjectMap)predicateValues)) {
                for (Long value : (LongSet)entry.getValue()) {
                    PathIndexKey next = indexKey.next(entry.getLongKey(), value, this.pathHashCache);
                    this.removeFromPathIndex(next);
                }
            }
        }
    }

    @FunctionalInterface
    protected static interface DeleteListener {
        public void onDelete(long var1, long var3, long var5);

        default public DeleteListener andThen(DeleteListener after) {
            Objects.requireNonNull(after);
            return (subject, predicate, object) -> {
                this.onDelete(subject, predicate, object);
                after.onDelete(subject, predicate, object);
            };
        }
    }

    private static class PathIndexKey {
        private final long id;
        private final int pathHash;

        private PathIndexKey(long id, int path) {
            this.id = id;
            this.pathHash = path;
        }

        PathIndexKey next(long predicate, long nextSubject, Int2ObjectMap<LongList> pathHashCache) {
            LongList path = (LongList)pathHashCache.get(this.pathHash);
            LongArrayList predicates = new LongArrayList(pathHashCache.size());
            predicates.add(predicate);
            predicates.addAll(path);
            return new PathIndexKey(nextSubject, predicates.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PathIndexKey)) {
                return false;
            }
            PathIndexKey that = (PathIndexKey)obj;
            return this.id == that.id && this.pathHash == that.pathHash;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.pathHash ^ this.pathHash >>> 32);
            return result;
        }

        public String toString() {
            return "PIK{" + this.id + "->" + this.pathHash + "}";
        }
    }
}

