/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LazyTriple;
import com.ontotext.soaas.common.rdf.LongLongLongPredicate;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.SimpleValueReader;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public abstract class AbstractRdfData
implements RdfData {
    public static final int DEFAULT_PREDICATE_COLLECTION_SIZE = 2;
    public static final int DEFAULT_VALUE_COLLECTION_SIZE = 2;
    protected final EntityPool pool;
    protected final int predicateCollectionSize;
    protected final int valueCollectionSize;
    private ValueReader valueParser = SimpleValueReader.INSTANCE;

    public AbstractRdfData(EntityPool pool) {
        this.pool = pool;
        this.predicateCollectionSize = pool.getDefaultPredicateCollectionSize();
        this.valueCollectionSize = pool.getDefaultValueCollectionSize();
    }

    @Override
    public int add(String subject, String predicate, Object object) {
        Objects.requireNonNull(subject, "Subject cannot be null");
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        Objects.requireNonNull(object, "Object cannot be null");
        return this.add(this.pool.resolve(subject), this.pool.resolve(predicate), this.pool.resolve(object));
    }

    @Override
    public boolean remove(String subject, String predicate, Object object) {
        Objects.requireNonNull(subject, "Subject cannot be null");
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        Objects.requireNonNull(object, "Object cannot be null");
        return this.remove(this.pool.resolve(subject), this.pool.resolve(predicate), this.pool.resolve(object));
    }

    @Override
    public void setValueReader(ValueReader valueReader) {
        this.valueParser = valueReader;
    }

    @Override
    public ValueReader getValueReader() {
        return this.valueParser;
    }

    @Override
    public EntityPool getPool() {
        return this.pool;
    }

    @Override
    public Collection<Triple> getTriples(String subject, String predicate, Object object) {
        if (subject == null && predicate == null && object == null) {
            return this.returnAll();
        }
        long subjectId = this.pool.resolve(subject);
        long predicateId = this.pool.resolve(predicate);
        long objectId = this.pool.resolve(object);
        LinkedHashSet<Triple> resultTriples = new LinkedHashSet<Triple>();
        LongLongLongPredicate tripleConsumer = this.toTriple(this.acceptAllTriples(resultTriples::add));
        this.filterData(subjectId, predicateId, objectId, tripleConsumer);
        return resultTriples;
    }

    @Override
    public Collection<LongTriple> getTriples(long subject, long predicate, long object) {
        LinkedHashSet<LongTriple> resultTriples = new LinkedHashSet<LongTriple>();
        LongLongLongPredicate tripleConsumer = this.toLongTriple(this.acceptAllTriples(resultTriples::add));
        this.filterData(subject, predicate, object, tripleConsumer);
        return resultTriples;
    }

    @Override
    public boolean contains(long subject, long predicate, long object) {
        LinkedHashSet resultTriples = new LinkedHashSet();
        LongLongLongPredicate tripleConsumer = this.toLongTriple(this.acceptFirstTriple(resultTriples::add));
        this.filterData(subject, predicate, object, tripleConsumer);
        return !resultTriples.isEmpty();
    }

    private void filterData(long subjectId, long predicateId, long objectId, LongLongLongPredicate tripleConsumer) {
        if (subjectId != 0L) {
            if (predicateId != 0L) {
                this.filterByKnownPredicate(tripleConsumer, subjectId, predicateId, objectId);
            } else {
                this.filterByAnyPredicate(tripleConsumer, subjectId, objectId);
            }
        } else if (predicateId != 0L) {
            this.filterByPredicate(tripleConsumer, predicateId, objectId);
        } else {
            this.filterByObject(tripleConsumer, objectId);
        }
    }

    private LongLongLongPredicate toLongTriple(Predicate<LongTriple> tripleConsumer) {
        return (val1, val2, val3) -> tripleConsumer.test(new LongTriple(val1, val2, val3, this.pool));
    }

    private LongLongLongPredicate toTriple(Predicate<Triple> tripleConsumer) {
        return (val1, val2, val3) -> tripleConsumer.test(new LazyTriple(val1, val2, val3, this.pool));
    }

    private <E> Predicate<E> acceptAllTriples(Consumer<E> consumer) {
        return triple -> {
            consumer.accept(triple);
            return true;
        };
    }

    private <E> Predicate<E> acceptFirstTriple(Consumer<E> consumer) {
        return triple -> {
            consumer.accept(triple);
            return false;
        };
    }

    @Override
    public void forEach(Consumer<Triple> tripleConsumer) {
        this.filterByObjectTest(this.toTriple(this.acceptAllTriples(tripleConsumer)), val -> true);
    }

    private Set<Triple> returnAll() {
        LinkedHashSet<Triple> resultTriples = new LinkedHashSet<Triple>();
        this.filterByObjectTest(this.toTriple(this.acceptAllTriples(resultTriples::add)), val -> true);
        return resultTriples;
    }

    protected abstract void filterByKnownPredicate(LongLongLongPredicate var1, long var2, long var4, long var6);

    protected abstract void filterByAnyPredicate(LongLongLongPredicate var1, long var2, long var4);

    protected void filterByObject(LongLongLongPredicate resultTriples, long object) {
        this.filterByObjectTest(resultTriples, this.valueComparator(object));
    }

    protected abstract void filterByObjectTest(LongLongLongPredicate var1, LongPredicate var2);

    protected abstract void filterByPredicate(LongLongLongPredicate var1, long var2, long var4);

    protected LongPredicate valueComparator(long object) {
        return other -> object == other;
    }
}

