/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.logging;

import com.ontotext.soaas.common.ThreadLocalContext;

public class LoggingContext {
    private static final String USER = "user";

    private LoggingContext() {
    }

    public static State getState() {
        return new State();
    }

    public static State setState(State state) {
        State previous = LoggingContext.getState();
        if (state != null) {
            LoggingContext.setRequestId(state.getRequestId());
            LoggingContext.setCurrentUser(state.getUser());
        } else {
            LoggingContext.clearRequestId();
            LoggingContext.clearCurrentUser();
        }
        return previous;
    }

    public static void setCurrentUser(String username) {
        if (username == null) {
            LoggingContext.clearCurrentUser();
        } else {
            ThreadLocalContext.put(USER, username);
        }
    }

    public static void clearCurrentUser() {
        ThreadLocalContext.remove(USER);
    }

    public static String getCurrentUser() {
        return (String)ThreadLocalContext.get(USER);
    }

    public static void setRequestId(String requestId) {
        if (requestId == null) {
            LoggingContext.clearRequestId();
        } else {
            ThreadLocalContext.put("X-Request-ID", requestId);
        }
    }

    public static void clearRequestId() {
        ThreadLocalContext.remove("X-Request-ID");
    }

    public static String getRequestId() {
        return (String)ThreadLocalContext.get("X-Request-ID");
    }

    @Deprecated
    public static Runnable decorateTask(Runnable task) {
        State state = LoggingContext.getState();
        return () -> {
            State oldState = LoggingContext.getState();
            try {
                LoggingContext.setState(state);
                task.run();
            }
            finally {
                LoggingContext.setState(oldState);
            }
        };
    }

    public static class State {
        private final String requestId = (String)ThreadLocalContext.get("X-Request-ID");
        private final String user = (String)ThreadLocalContext.get("user");

        private State() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getUser() {
            return this.user;
        }
    }
}

