/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.configuration;

public class ConfigurationDefinition {
    private final String name;
    private final String oldName;
    private final Class valueType;
    private final Object defaultValue;

    public <E> ConfigurationDefinition(String name, Class<E> valueType, E defaultValue) {
        this.name = name;
        this.oldName = null;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
    }

    public <E> ConfigurationDefinition(String name, String oldName, Class<E> valueType, E defaultValue) {
        this.name = name;
        this.oldName = oldName;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
    }

    public static ConfigurationDefinition stringConfig(String name, String defaultValue) {
        return new ConfigurationDefinition(name, String.class, defaultValue);
    }

    public static ConfigurationDefinition booleanConfig(String name, Boolean defaultValue) {
        return new ConfigurationDefinition(name, Boolean.class, defaultValue);
    }

    public static ConfigurationDefinition booleanConfig(String name, String oldName, Boolean defaultValue) {
        return new ConfigurationDefinition(name, oldName, Boolean.class, defaultValue);
    }

    public static ConfigurationDefinition intConfig(String name, Integer defaultValue) {
        return new ConfigurationDefinition(name, Integer.class, defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldName;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

