/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.concurrent;

public interface Timer {
    public long getDuration();

    default public long getDurationAndRestart() {
        return this.getDuration();
    }

    public static Timer start() {
        return new DurationTimer();
    }

    public static Timer fixed(long duration) {
        return () -> duration;
    }

    public static class DurationTimer
    implements Timer {
        private long startTime = System.currentTimeMillis();

        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getDurationAndRestart() {
            long duration = this.getDuration();
            this.startTime = System.currentTimeMillis();
            return duration;
        }

        @Override
        public long getDuration() {
            return System.currentTimeMillis() - this.getStartTime();
        }
    }
}

