/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TextFileCacheLoader {
    private final Path basePath;

    public TextFileCacheLoader(Path basePath) {
        this.basePath = basePath;
        this.makeSureExists();
    }

    private void makeSureExists() {
        File file = this.basePath.toFile();
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Store location does not point to a directory: " + file.getAbsolutePath());
            }
        } else if (!file.mkdirs() && !file.exists()) {
            throw new IllegalArgumentException("Cannot create persist directory: " + file.getAbsolutePath());
        }
    }

    public String load(String name) {
        String string;
        Path childNode = this.basePath.resolve(name);
        FileInputStream input = new FileInputStream(childNode.toFile());
        try {
            string = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
        ((InputStream)input).close();
        return string;
    }

    public boolean write(String name, String value) throws IOException {
        Path childNode = this.basePath.resolve(name);
        File file = childNode.toFile();
        if (!file.exists()) {
            try {
                Files.createFile(childNode, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException faee) {
                return false;
            }
        } else {
            return false;
        }
        try (FileOutputStream output = new FileOutputStream(file);){
            IOUtils.write((String)value, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
        return true;
    }

    public void clearAll() throws IOException {
        FileUtils.cleanDirectory((File)this.basePath.toFile());
    }
}

