/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;

public class ThreadLocalContext {
    private static final InheritableThreadLocal<Map<String, Object>> INHERITABLE_THREAD_LOCAL = new InheritableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> childValue(Map<String, Object> parentValue) {
            if (parentValue == null) {
                return null;
            }
            return new HashMap<String, Object>(parentValue);
        }
    };

    private ThreadLocalContext() {
    }

    public static void put(String key, Object val) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        HashMap<String, Object> map = (HashMap<String, Object>)INHERITABLE_THREAD_LOCAL.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            INHERITABLE_THREAD_LOCAL.set(map);
        }
        map.put(key, val);
        MDC.put((String)key, (String)String.valueOf(val));
    }

    public static Object get(String key) {
        Map map = (Map)INHERITABLE_THREAD_LOCAL.get();
        if (map != null && key != null) {
            return map.get(key);
        }
        return null;
    }

    public static void remove(String key) {
        Map map = (Map)INHERITABLE_THREAD_LOCAL.get();
        if (map != null) {
            map.remove(key);
            MDC.remove((String)key);
        }
    }

    public static void clear() {
        Map map = (Map)INHERITABLE_THREAD_LOCAL.get();
        if (map != null) {
            map.clear();
            INHERITABLE_THREAD_LOCAL.remove();
            MDC.clear();
        }
    }

    public static Set<String> getKeys() {
        Map map = (Map)INHERITABLE_THREAD_LOCAL.get();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    public static Map<String, Object> getCopyOfContextMap() {
        Map oldMap = (Map)INHERITABLE_THREAD_LOCAL.get();
        if (oldMap != null) {
            return new HashMap<String, Object>(oldMap);
        }
        return null;
    }

    public static void setContextMap(Map<String, Object> contextMap) {
        if (contextMap == null) {
            INHERITABLE_THREAD_LOCAL.remove();
        } else {
            INHERITABLE_THREAD_LOCAL.set(new HashMap<String, Object>(contextMap));
        }
    }
}

