/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common;

import com.ontotext.soaas.common.CachingSupplier;
import com.ontotext.soaas.common.sparql.SparqlPrettyPrinter;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;

public class SparqlUtil {
    private static final Supplier<Class<?>> REPO_EXCEPTION = new CachingSupplier<Class>(() -> {
        try {
            return Class.forName("org.eclipse.rdf4j.repository.RepositoryException");
        }
        catch (ClassNotFoundException cnfe) {
            throw new MissingResourceException("org.eclipse.rdf4j:rdf4j-repository-api not present", "org.eclipse.rdf4j.repository.RepositoryException", "");
        }
    });
    public static final Pattern VAR_PATTERN_WITH_PATH = Pattern.compile("[?$]([\\w]+(?:\\.[\\w]+)*)");

    private SparqlUtil() {
    }

    public static String prettyPrint(String sparql) {
        return SparqlPrettyPrinter.prettyPrint(sparql);
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        return SparqlUtil.escapeCharacters(string, SparqlUtil::sparqlEscapeReplacements).toString();
    }

    private static StringBuilder escapeCharacters(String value, EscapeFunction replacements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char current = value.charAt(i);
            String replacement = replacements.getReplacementOf(current);
            if (replacement != null) {
                builder.append(replacement);
                continue;
            }
            builder.append(current);
        }
        return builder;
    }

    public static String escapeStringLiteral(String value) {
        if (value == null) {
            return null;
        }
        return SparqlUtil.escapeCharacters(value, SparqlUtil::sparqlStringEscapeReplacements).toString();
    }

    public static String escapeXsdStringType(String value) {
        if (value == null) {
            return null;
        }
        return SparqlUtil.escapeCharacters(value, SparqlUtil::sparqlStringEscapeReplacements).insert(0, '\"').append('\"').toString();
    }

    public static String getExceptionMessage(Throwable ex) {
        String message = SparqlUtil.getRepositoryExceptionMessage(ex);
        if (message != null) {
            return message;
        }
        return Objects.requireNonNull(ex, "Exception argument should not be null").getMessage();
    }

    private static String getRepositoryExceptionMessage(Throwable ex) {
        if (ex == null) {
            return null;
        }
        Class<?> repositoryExceptionType = REPO_EXCEPTION.get();
        if (repositoryExceptionType.isInstance(ex.getCause())) {
            return ex.getCause().getMessage();
        }
        if (repositoryExceptionType.isInstance(ex)) {
            return ex.getMessage();
        }
        return SparqlUtil.getRepositoryExceptionMessage(ex.getCause());
    }

    public static String escapeExternalPropertyBindings(String template) {
        Matcher matcher = VAR_PATTERN_WITH_PATH.matcher(template);
        StringBuilder resultBody = new StringBuilder();
        int idx = 0;
        while (matcher.find(idx)) {
            String var = matcher.group(1);
            resultBody.append(template, idx, matcher.start(1));
            if (var.startsWith("_")) {
                resultBody.append(var.replace('.', '_'));
            } else {
                resultBody.append(var);
            }
            idx = matcher.end(1);
        }
        resultBody.append(template, idx, template.length());
        return resultBody.toString();
    }

    public static String resourceAsString(Object value) {
        if (value instanceof BNode) {
            return ((BNode)value).getID();
        }
        if (value instanceof IRI || value instanceof Triple) {
            return ((Value)value).stringValue();
        }
        if (value instanceof Value) {
            return ((Value)value).stringValue();
        }
        return Objects.toString(value, null);
    }

    public static boolean isSparqlTemplate(String value) {
        if (value != null) {
            return value.chars().anyMatch(c -> c == 63 || c == 36 || c == 123 || c == 125);
        }
        return false;
    }

    private static String sparqlStringEscapeReplacements(char value) {
        switch (value) {
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
            case '\"': {
                return "\\\"";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        return null;
    }

    private static String sparqlEscapeReplacements(char value) {
        switch (value) {
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface EscapeFunction {
        public String getReplacementOf(char var1);
    }
}

