/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.licensecheck;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.licensecheck.DefaultLicenseCheck;
import com.ontotext.licensecheck.GraphQlExtendedFeatures;
import com.ontotext.licensecheck.LicenseCheck;
import com.ontotext.licensecheck.LicenseRestrictionException;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LicenseCheckUtil {
    private static LicenseCheck instance;
    protected static final String NO_IMPLEMENTATION_FOUND;
    protected static final String MULTIPLE_IMPLEMENTATIONS_FOUND;

    private LicenseCheckUtil() {
    }

    private static LicenseCheck loadImplementation() {
        new DefaultLicenseCheck();
        List<LicenseCheck> implementations = PluginsManager.loadPlugins(LicenseCheck.class);
        if (implementations.size() != 1) {
            throw new IllegalStateException(implementations.isEmpty() ? NO_IMPLEMENTATION_FOUND : MULTIPLE_IMPLEMENTATIONS_FOUND);
        }
        return implementations.getFirst();
    }

    public static boolean hasGraphQlExtendedLicense() {
        if (Objects.isNull(instance)) {
            instance = LicenseCheckUtil.loadImplementation();
        }
        return instance.hasGraphQlExtendedLicense();
    }

    public static void requireGraphQlExtendedLicense(GraphQlExtendedFeatures ... features) {
        if (!LicenseCheckUtil.hasGraphQlExtendedLicense()) {
            String featuresString = Arrays.stream(features).map(GraphQlExtendedFeatures::getName).collect(Collectors.joining(", "));
            String message = String.format("This %s only available with GraphQL extended license", features.length > 1 ? "features are" : "feature is");
            if (!featuresString.isEmpty()) {
                message = String.format("You are using an endpoint with %s. %s", featuresString, message);
            }
            throw new LicenseRestrictionException(message);
        }
    }

    @VisibleForTesting
    public static void reset() {
        instance = null;
    }

    static {
        NO_IMPLEMENTATION_FOUND = String.format("No %s implementation found", LicenseCheck.class.getSimpleName());
        MULTIPLE_IMPLEMENTATIONS_FOUND = String.format("Multiple %s implementations found", LicenseCheck.class.getSimpleName());
    }
}

