/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.jmx.rest;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.jmx.domain.ClusterStatisticsBean;
import com.ontotext.forest.jmx.domain.GlobalPageCacheStatistics;
import com.ontotext.forest.jmx.domain.backup.BackupOperationBean;
import com.ontotext.forest.jmx.domain.infrastructure.ResourceUsage;
import com.ontotext.forest.jmx.domain.repository.RepositoryMonitorStatisticsBean;
import com.ontotext.forest.jmx.rest.MonitoringService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/rest/monitor/"})
@Controller
@Tag(name="Monitoring", description="Monitor different GraphDB processes")
public class MonitoringController {
    public static final String MAPPING = "/rest/monitor/";
    public static final String REPOSITORY_ID_NAME = "repositoryID";
    public static final String REPOSITORY_ID_QUERY_PATH_STRING = "repository/{repositoryID}/query";
    public static final String REPOSITORY_ID_OPERATIONS_PATH_STRING = "repository/{repositoryID}/operations";
    @Autowired
    private MonitoringService monitoringService;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;

    @Operation(description="Monitor data structures and schema", summary="Get structures statistics", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GlobalPageCacheStatistics.class)), @Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(value={"structures"}, produces={"text/plain", "application/json"})
    public ResponseEntity<?> getStructureStatistics(HttpServletRequest request) throws Exception {
        try {
            return this.monitoringService.getStructuresStatistics(request);
        }
        catch (GraphDBWorkbenchException e) {
            if (this.monitoringService.shouldReturnPrometheusFormat(request)) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            throw e;
        }
    }

    @Operation(description="Monitor running backup operations", summary="Track backup operations", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=BackupOperationBean.class)), @Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(value={"backup"}, produces={"text/plain", "application/json"})
    public ResponseEntity<?> getBackupOperation(HttpServletRequest request, HttpServletResponse response) {
        try {
            SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
            if (this.monitoringService.shouldReturnPrometheusFormat(request)) {
                return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> new ResponseEntity((Object)this.monitoringService.getBackupRecoveryOperationString(), (HttpStatusCode)HttpStatus.OK));
            }
            return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> new ResponseEntity(this.monitoringService.getBackupRecoveryOperation(), (HttpStatusCode)HttpStatus.OK));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
    }

    @Operation(description="Monitor cluster health and performance", summary="Get cluster statistics", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClusterStatisticsBean.class)), @Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(value={"cluster"}, produces={"text/plain", "application/json"})
    public ResponseEntity<?> getClusterStatistics(HttpServletRequest request) {
        try {
            if (this.monitoringService.shouldReturnPrometheusFormat(request)) {
                return new ResponseEntity((Object)this.monitoringService.getClusterStatisticsString(), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)this.monitoringService.getClusterStatisticsBean(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalStateException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
    }

    @Operation(description="Monitor infrastructure health and performance", summary="Get all infrastructure statistics", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResourceUsage.class)), @Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping(value={"infrastructure"}, produces={"text/plain", "application/json"})
    public ResponseEntity<?> get(HttpServletRequest request) throws Exception {
        return this.monitoringService.getInfrastructureStatistics(request);
    }

    @Operation(summary="Perform a garbage collection", hidden=true)
    @PostMapping(value={"infrastructure/gc"})
    public ResponseEntity<Object> performGC() {
        ManagementFactory.getMemoryMXBean().gc();
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @GetMapping(value={"repository/{repositoryID}/operations"}, produces={"application/json"})
    public ResponseEntity<?> getActiveOperations(HttpServletRequest request, @PathVariable String repositoryID, HttpServletResponse response) throws Exception {
        try {
            SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
            return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
                if (this.monitoringService.shouldReturnEmptyResult(semanticLocation, repositoryID)) {
                    return new ResponseEntity(Collections.emptyList(), (HttpStatusCode)HttpStatus.OK);
                }
                return new ResponseEntity((Object)this.monitoringService.getActiveOperationsBean(repositoryID), (HttpStatusCode)HttpStatus.OK);
            });
        }
        catch (IllegalStateException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
    }

    @Hidden
    @GetMapping(value={"repository/{repositoryID}/query/active"}, produces={"application/json"})
    public ResponseEntity<?> getActiveQueries(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repositoryID) throws Exception {
        SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            if (this.monitoringService.shouldReturnEmptyResult(semanticLocation, repositoryID)) {
                return new ResponseEntity(Collections.emptyList(), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity(this.monitoringService.getActiveQueries(repositoryID, semanticLocation), (HttpStatusCode)HttpStatus.OK);
        });
    }

    @Hidden
    @GetMapping(value={"repository/{repositoryID}/query/count"}, produces={"application/json"})
    public ResponseEntity<Integer> getCount(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repositoryID) throws Exception {
        SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            if (this.monitoringService.shouldReturnEmptyResult(semanticLocation, repositoryID)) {
                return new ResponseEntity((Object)0, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)this.monitoringService.getQueriesCount(repositoryID, semanticLocation), (HttpStatusCode)HttpStatus.OK);
        });
    }

    @Hidden
    @DeleteMapping(value={"repository/{repositoryID}/query"}, params={"query"}, produces={"application/json"})
    public ResponseEntity<?> stop(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="query") String query, @PathVariable(value="repositoryID") String repositoryID) throws Exception {
        SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            this.monitoringService.deleteQuery(repositoryID, query, semanticLocation);
            return new ResponseEntity((Object)"Query was requested to abort and will be terminated if possible.", (HttpStatusCode)HttpStatus.OK);
        });
    }

    @Hidden
    @GetMapping(value={"repository/{repositoryID}/query"}, params={"query"})
    public ResponseEntity<?> getQuery(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="query") String query, @PathVariable(value="repositoryID") String repositoryID) throws Exception {
        ResponseEntity<?> responseEntity = this.downloadQuery(request, response, query, repositoryID, "query_" + query + ".rq");
        response.setContentType("application/sparql-query");
        return responseEntity;
    }

    @Hidden
    @GetMapping(value={"repository/{repositoryID}/query/download"}, params={"query"})
    public ResponseEntity<?> downloadQuery(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="query") String query, @PathVariable(value="repositoryID") String repositoryID, @RequestParam(value="filename", defaultValue="query.rq") String filename) throws Exception {
        SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            String queryString = this.monitoringService.getQuery(repositoryID, query, semanticLocation);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename.replace("\"", "_") + "\"");
            response.setContentType("application/sparql-query");
            return new ResponseEntity((Object)queryString, (HttpStatusCode)HttpStatus.OK);
        });
    }

    @Operation(description="Monitor repository usage and performance", summary="Get repository statistics", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RepositoryMonitorStatisticsBean.class)), @Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="204", description="No content", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping(value={"repository/{repositoryID}"}, produces={"text/plain", "application/json"})
    public ResponseEntity<?> getRepositoryStatistics(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repositoryID) throws Exception {
        SemanticLocation semanticLocation = this.monitoringService.getSemanticLocation();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> this.monitoringService.getRepositoryStatistics(request, repositoryID, semanticLocation));
    }
}

