/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.jmx.domain.operations;

import com.ontotext.forest.jmx.domain.operations.OperationStatus;
import com.ontotext.forest.recovery.BackupOperationStatus;

public class ActiveOperation {
    private String value;
    private OperationStatus status;
    private String type;

    public ActiveOperation(OperationType type, long activeQueries) {
        this.type = type.getMessage();
        this.status = OperationStatus.INFORMATION;
        this.value = Long.toString(activeQueries);
    }

    public ActiveOperation(BackupOperationStatus.BackupOperationInProgress backupOperation) {
        this.type = OperationType.BACKUP_RESTORE.getMessage();
        this.status = OperationStatus.WARNING;
        this.value = backupOperation.name();
    }

    public ActiveOperation(OperationType type, ClusterStatus clusterStatus) {
        this.type = type.getMessage();
        this.value = clusterStatus.name();
        this.status = clusterStatus == ClusterStatus.IN_SYNC ? OperationStatus.INFORMATION : (clusterStatus == ClusterStatus.RECOVERING || clusterStatus == ClusterStatus.UNAVAILABLE_NODES ? OperationStatus.WARNING : OperationStatus.CRITICAL);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "{\"type\":\"" + this.type + "\", \"operationStatus\":\"" + String.valueOf((Object)this.status) + "\", \"message\":\"" + this.value + "\"}";
    }

    public static enum OperationType {
        CLUSTER_STATUS("clusterHealth"),
        BACKUP_RESTORE("backupAndRestore"),
        QUERIES("queries"),
        UPDATES("updates"),
        IMPORTS("imports");

        final String message;

        private OperationType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum ClusterStatus {
        IN_SYNC,
        RECOVERING,
        OUT_OF_SYNC,
        UNAVAILABLE_NODES;

    }
}

