/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.jmx.domain.backup;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.forest.jmx.domain.backup.SnapshotOptionsBean;
import com.ontotext.forest.recovery.BackupOperationStatus;
import java.util.Set;

public class BackupOperationBean {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String username;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final BackupOperationStatus.BackupOperationInProgress operation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Set<String> affectedRepositories;
    private final long msSinceCreated;
    @JsonProperty(value="snapshotOptions")
    private final SnapshotOptionsBean snapshotOptionsBean;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String nodePerformingClusterBackup;

    public BackupOperationBean(BackupOperationStatus backupOperationStatus, Set<String> affectedRepositories) {
        this.id = String.valueOf(backupOperationStatus.getIdBackupRecoveryOperation());
        this.username = backupOperationStatus.getUsername();
        this.operation = backupOperationStatus.getOperation();
        this.msSinceCreated = System.currentTimeMillis() - backupOperationStatus.getCreatedTimestamp();
        this.nodePerformingClusterBackup = backupOperationStatus.getNodePerformingClusterBackup();
        this.snapshotOptionsBean = new SnapshotOptionsBean(backupOperationStatus.getSnapshotOptions());
        this.affectedRepositories = affectedRepositories;
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public BackupOperationStatus.BackupOperationInProgress getOperation() {
        return this.operation;
    }

    public Set<String> getAffectedRepositories() {
        return this.affectedRepositories;
    }

    public long getMsSinceCreated() {
        return this.msSinceCreated;
    }

    public SnapshotOptionsBean getSnapshotOptionsBean() {
        return this.snapshotOptionsBean;
    }

    public String getNodePerformingClusterBackup() {
        return this.nodePerformingClusterBackup;
    }
}

