/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.GraphDBInternalConfigParameters;
import com.ontotext.config.ParametersSource;
import com.ontotext.graphdb.importrdf.Load;
import com.ontotext.load.AbortRDFHandlingException;
import com.ontotext.rio.parallel.BaseParser;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.SailConnectionImpl;
import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.io.FileSystemHealth;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.sail.SailException;

public class SerialParser
extends BaseParser {
    private final OwlimSchemaRepository owlim;
    private final FileSystemHealth.DiskChecker diskChecker;
    private FileSystemHealth.FreeSpaceSnapshot freeSpaceSnapshot;

    public SerialParser(SailConnectionImpl conn, long[] statementCount, OwlimSchemaRepository owlim) {
        super(conn, statementCount);
        this.owlim = owlim;
        this.diskChecker = FileSystemHealth.getInstance().createOperationBasedDiskCheck();
    }

    public void startRDF() throws RDFHandlerException {
        try {
            Load.LOG.info("Loading file: " + this.getFileName());
            this.freeSpaceSnapshot = FileSystemHealth.getInstance().canStartTransaction(this.owlim.getRepositoryId());
            this.conn.begin();
            this.start = System.currentTimeMillis();
            this.startStatementCount = this.statementCount[0];
            this.prevTime = this.start;
            this.conn.addStatement((Resource)this.conn.getValueFactory().createBNode("_:"), SystemGraphs.COMMIT_STATISTICS.getUri(), (Value)this.conn.getValueFactory().createBNode("_:"), new Resource[0]);
        }
        catch (SailException ex) {
            throw new RDFHandlerException((Throwable)ex);
        }
    }

    public void handleStatement(Statement s) throws RDFHandlerException {
        this.statementCount[0] = this.statementCount[0] + 1L;
        this.printStatus(false);
        try {
            this.diskChecker.check();
        }
        catch (SailException se) {
            throw new AbortRDFHandlingException((Exception)((Object)se));
        }
        if (ParametersSource.parameters().isEnabled(GraphDBInternalConfigParameters.LOAD_DATA)) {
            try {
                if (s.getContext() != null) {
                    this.conn.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{s.getContext()});
                }
                this.conn.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[0]);
            }
            catch (SailException ex) {
                throw new RDFHandlerException((Throwable)ex);
            }
        } else if (ParametersSource.parameters().isEnabled(GraphDBInternalConfigParameters.RESOLVE)) {
            throw new IllegalArgumentException("RESOLVE feature of load no longer supported!");
        }
    }

    public void endRDF() throws RDFHandlerException {
        FileSystemHealth.getInstance().canCommitTransaction(this.freeSpaceSnapshot);
        try {
            this.conn.commit();
            this.printStatus(true);
        }
        catch (SailException ex) {
            throw new RDFHandlerException((Throwable)ex);
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (this.conn.getNamespace(prefix) == null) {
            this.conn.setNamespace(prefix, uri);
        }
    }

    public void processException(Exception e) throws AbortRDFHandlingException {
        if (e instanceof UnsupportedRDFormatException) {
            if (Load.ignoreCorruptFiles.booleanValue()) {
                Load.LOG.warn("Skip file {} due to unsupported rdf format! {}", (Object)this.getFileName(), (Object)e.getMessage());
                this.ignoredFiles.add(this.getFileName());
                return;
            }
            throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)e);
        }
        if (e instanceof RDFParseException) {
            if (Load.ignoreCorruptLines.booleanValue()) {
                Load.LOG.warn("Load only part of file {} due to parsing exception! {}", (Object)this.getFileName(), (Object)e.getMessage());
                try {
                    this.conn.commit();
                }
                catch (SailException ex) {
                    throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)ex);
                }
                this.partiallyLoadedFiles.add(this.getFileName());
                return;
            }
            try {
                this.conn.rollback();
            }
            catch (SailException ex) {
                throw new AbortRDFHandlingException((Exception)((Object)ex));
            }
            if (Load.ignoreCorruptFiles.booleanValue()) {
                Load.LOG.warn("Skip file {} due to parsing exception! {}", (Object)this.getFileName(), (Object)e.getMessage());
                this.ignoredFiles.add(this.getFileName());
                return;
            }
            throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)e);
        }
        if (e instanceof RuntimeException) {
            if (this.conn != null) {
                this.conn.rollback();
            }
            throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)e);
        }
        super.processException(e);
    }

    public String toString() {
        return "serial";
    }
}

