/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.graphdb.importrdf.Preload;
import com.ontotext.graphdb.importrdf.ReportError;
import com.ontotext.trree.util.CompressedSortedChunksFileQueue;
import com.ontotext.trree.util.Formats;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RestoreManager
implements Runnable,
ReportError {
    private final Preload preload;
    boolean bDirty;
    int mode = 1;
    int TRIGGER_INTERVAL = 3600;
    long TriggerInMillis = TimeUnit.SECONDS.toMillis(this.TRIGGER_INTERVAL);
    boolean shutDown = false;
    Thread runner = null;
    int permits = 0;
    Semaphore trigger = null;
    AtomicInteger numParserWaiting = new AtomicInteger(0);
    long nextMs;
    Thread hook = null;
    ReentrantLock lock = new ReentrantLock();
    Condition forParsers = this.lock.newCondition();
    Condition fromSorter = this.lock.newCondition();
    AtomicBoolean enter = new AtomicBoolean(false);
    AtomicBoolean fromResolver = new AtomicBoolean(false);
    AtomicBoolean createRestore = new AtomicBoolean(false);

    RestoreManager(Preload preload) {
        this.preload = preload;
        this.bDirty = !preload.inrecoverMode;
        this.TRIGGER_INTERVAL = Preload.recoveryPointInterval;
        this.TriggerInMillis = TimeUnit.SECONDS.toMillis(this.TRIGGER_INTERVAL);
    }

    public void parserEnterWait() {
        this.numParserWaiting.incrementAndGet();
    }

    public void parserLeaveWait() {
        this.numParserWaiting.decrementAndGet();
    }

    public void setDirtyInPhaseOne() {
        this.bDirty = true;
        this.setNextMs();
    }

    public void setNextMs() {
        this.nextMs = System.currentTimeMillis() + this.TriggerInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int count = 0;
        long total = 0L;
        try {
            this.runner = Thread.currentThread();
            this.runner.setName("restore-point-manager");
            while (!this.shutDown) {
                long stillToGo;
                this.setNextMs();
                while ((stillToGo = this.nextMs - System.currentTimeMillis()) > 0L && !this.shutDown) {
                    try {
                        Thread.sleep(stillToGo);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.shutDown) {
                    Preload.LOG.debug("Shutdown while still waiting for another " + (this.nextMs - System.currentTimeMillis()) + "ms");
                    break;
                }
                this.lock.lock();
                try {
                    long s = System.nanoTime();
                    this.createRestorePoint();
                    total += System.nanoTime() - s;
                    ++count;
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.runner = null;
        }
        catch (Exception e) {
            Preload.LOG.error("Restore manager caught an exception", (Throwable)e);
            this.preload.handleError(this, e);
        }
        catch (Error e) {
            Preload.LOG.error("Restore manager caught an error", (Throwable)e);
            this.preload.handleError(this, e);
        }
        finally {
            Preload.LOG.debug("Created automatically " + count + " restore points. Total time spent was " + Formats.number((long)TimeUnit.NANOSECONDS.toMillis(total)) + "ms");
        }
    }

    public void shutDown() {
        if (!this.shutDown) {
            if (this.hook != null) {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
            Thread t = this.runner;
            this.shutDown = true;
            while (t != null && t.isAlive()) {
                try {
                    t.interrupt();
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void deleteRecoverPointOnSuccess() {
        File location = new File(this.preload.storageLocation);
        File recoverPointExisting = new File(location, "preload.recover");
        File recoverPoint = new File(location, "preload.recover.new");
        recoverPointExisting.delete();
        recoverPoint.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initFromRestorePoint(File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            this.mode = dis.readInt();
            switch (this.mode) {
                case 0: {
                    this.initFromInitialRestorePoint(dis);
                    return;
                }
                case 1: {
                    this.initFromPhaseOneRestorePoint(dis);
                    return;
                }
                case 2: {
                    this.initFromPhaseTwoRestorePoint(dis);
                    return;
                }
                case 3: {
                    this.initFromPhaseThreeRestorePoint(dis);
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid mode detected from restore point! Aborting!");
                }
            }
        }
    }

    private void initFromPhaseTwoRestorePoint(DataInputStream dis) throws IOException {
        this.readCommonSettings(dis);
        this.readQueueState(dis);
    }

    public void start(int permits) {
        this.permits = permits;
        this.trigger = new Semaphore(permits);
        Preload.LOG.info("Restore manager started. Interval is " + TimeUnit.MILLISECONDS.toSeconds(this.TriggerInMillis) + " seconds.");
        new Thread(this).start();
        this.hook = new Thread(){

            @Override
            public void run() {
                if (RestoreManager.this.lock != null && !RestoreManager.this.shutDown) {
                    try {
                        if (RestoreManager.this.lock.tryLock()) {
                            Preload.LOG.info("Shutdown hook invoked: creating restore point ...");
                            RestoreManager.this.createRestorePoint();
                        } else {
                            Preload.LOG.info("Shutdown hook invoked: waiting to finish creating restore point ...");
                            RestoreManager.this.lock.lock();
                        }
                    }
                    finally {
                        RestoreManager.this.lock.unlock();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    public void allocateSlot() {
        this.trigger.acquireUninterruptibly();
    }

    public void releaseSlot() {
        this.trigger.release();
    }

    public boolean isInCreateRestore() {
        return this.createRestore.get();
    }

    public void setIndexMode() {
        this.mode = 2;
        this.createRestorePoint();
        if (this.enter.get() && this.createRestore.get()) {
            this.fromSorter.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRestorePoint() {
        block32: {
            try {
                File location = new File(this.preload.storageLocation);
                File recoverPointExisting = new File(location, "preload.recover");
                File recoverPoint = new File(location, "preload.recover.new");
                if (recoverPoint.exists() && !recoverPoint.delete()) {
                    Preload.LOG.warn("Cannot remove existing recover file! " + recoverPoint.getAbsolutePath());
                    return;
                }
                if (this.mode == 0) {
                    this.createInitialRestorePoint(recoverPointExisting, recoverPoint);
                    return;
                }
                if (this.mode == 1) {
                    if (!this.bDirty) {
                        Preload.LOG.info("No new data in phase one - skipping");
                        return;
                    }
                    try {
                        Preload.LOG.info("Create parse mode restore point ...");
                        this.enterPhaseOne();
                        if (this.mode != 1) {
                            Preload.LOG.info("No data changes detected! Skip restore point ");
                            return;
                        }
                        try {
                            Preload.LOG.info("Entities flush");
                            this.preload.estorage.flush(true);
                            Preload.LOG.info("Entities map flush");
                            this.preload.hashmap.flush();
                            if (this.preload.buildLiteralProperties) {
                                Preload.LOG.info("Entities types flush");
                                this.preload.entityTypes.flush();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.createPhaseOneRestorePoint(recoverPointExisting, recoverPoint);
                        break block32;
                    }
                    finally {
                        this.leavePhaseOne();
                    }
                }
                if (this.mode == 2) {
                    Preload.LOG.info("All data parsed! Create intermediate restore point ...");
                    DataOutputStream dos = null;
                    boolean normal = false;
                    try {
                        dos = new DataOutputStream(new FileOutputStream(recoverPoint));
                        dos.writeInt(2);
                        this.persistCommonSettings(dos);
                        this.persistQueuesState(dos);
                        normal = true;
                    }
                    catch (Throwable t) {
                        this.preload.handleError(this, t);
                    }
                    finally {
                        this.closeAndSwap(recoverPointExisting, recoverPoint, dos, normal);
                    }
                    Preload.LOG.info("Intermediate restore point created!");
                    break block32;
                }
                if (this.mode != 3) break block32;
                Preload.LOG.info("Create index mode restore point ...");
                try {
                    boolean[] flags = this.enterPhaseThree();
                    try {
                        this.createPhaseThreeRestorePoint(recoverPointExisting, recoverPoint, flags);
                    }
                    finally {
                        this.leavePhaseThree(flags);
                    }
                }
                catch (Throwable t) {
                    this.preload.handleError(this, t);
                }
                Preload.LOG.info("Index mode restore point created!");
            }
            catch (Throwable t) {
                this.preload.handleError(this, t);
            }
            finally {
                this.setNextMs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPhaseThreeRestorePoint(File recoverPointExisting, File recoverPoint, boolean[] flags) {
        DataOutputStream dos = null;
        boolean normal = false;
        try {
            dos = new DataOutputStream(new FileOutputStream(recoverPoint));
            dos.writeInt(3);
            this.persistCommonSettings(dos);
            for (boolean flag : flags) {
                dos.writeBoolean(flag);
            }
            if (flags[0]) {
                this.preload.statePOSC.write(dos);
                if (this.preload.statePOSC.q != null) {
                    this.preload.statePOSC.q.writeState(dos);
                    this.preload.statePOSC.commitAction.run();
                } else {
                    this.preload.posq.writeState(dos);
                }
            }
            if (flags[1]) {
                this.preload.statePSOC.write(dos);
                if (this.preload.statePSOC.q != null) {
                    this.preload.statePSOC.q.writeState(dos);
                    this.preload.statePSOC.commitAction.run();
                } else {
                    this.preload.psoq.writeState(dos);
                }
            }
            if (flags[2]) {
                this.preload.stateCPSO.write(dos);
                if (this.preload.stateCPSO.q != null) {
                    this.preload.stateCPSO.q.writeState(dos);
                    this.preload.stateCPSO.commitAction.run();
                } else {
                    this.preload.cpsoq.writeState(dos);
                }
            }
            if (flags[3]) {
                this.preload.statePredLists.write(dos);
                if (this.preload.statePredLists.q != null) {
                    this.preload.plistsq.writeState(dos);
                    this.preload.statePredLists.commitAction.run();
                } else {
                    this.preload.plistsq.writeState(dos);
                }
            }
            if (flags[4]) {
                if (this.preload.stateLiterals.mode == 0 && this.preload.numericsq.finish) {
                    this.preload.stateLiterals.mode = 1;
                }
                this.preload.stateLiterals.write(dos);
                if (this.preload.stateLiterals.q != null && !this.preload.stateLiterals.done) {
                    if (this.preload.stateLiterals.mode == 0) {
                        if (!this.preload.numericsq.finish) {
                            this.preload.numericsq.writeState(dos);
                        }
                        this.preload.datesq.writeState(dos);
                    } else {
                        this.preload.datesq.writeState(dos);
                    }
                }
                this.preload.stateLiterals.commitAction.run();
            }
            if (flags[5]) {
                this.preload.statePOST.write(dos);
                if (this.preload.statePOST.q != null) {
                    this.preload.statePOST.q.writeState(dos);
                    this.preload.statePOST.commitAction.run();
                } else {
                    this.preload.post.writeState(dos);
                }
            }
            if (flags[6]) {
                this.preload.statePSOT.write(dos);
                if (this.preload.statePSOT.q != null) {
                    this.preload.statePSOT.q.writeState(dos);
                    this.preload.statePSOT.commitAction.run();
                } else {
                    this.preload.psot.writeState(dos);
                }
            }
            dos.writeBoolean(this.preload.preadStatCreated);
            if (!this.preload.preadStatCreated) {
                this.preload.writePredicateStatistics(this.preload.map, dos);
                this.preload.writePredicateStatistics(this.preload.tripleMap, dos);
            }
            normal = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.closeAndSwap(recoverPointExisting, recoverPoint, dos, normal);
        }
    }

    private void initFromPhaseThreeRestorePoint(DataInputStream dis) throws IOException {
        this.readCommonSettings(dis);
        String msg = "Restoring {} queue, skipping to position {} ...";
        Preload.LOG.info("Indexing mode: --chunk-size={}, --iterator-cache={}", (Object)Formats.number((long)Preload.chunkSize), (Object)Preload.iteratorCache);
        boolean[] flags = new boolean[7];
        for (int i = 0; i < 5; ++i) {
            flags[i] = dis.readBoolean();
        }
        if (flags[0]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.statePOSC = new Preload.POSCIndexData(preload, dis);
            Preload.LOG.info(msg, (Object)"POSC", (Object)Formats.number((long)this.preload.statePOSC.count));
            this.preload.posq = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
        }
        if (flags[1]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.statePSOC = new Preload.PSOCIndexData(preload, dis);
            Preload.LOG.info(msg, (Object)"PSOC", (Object)Formats.number((long)this.preload.statePSOC.count));
            this.preload.psoq = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
        }
        if (flags[2]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.stateCPSO = new Preload.RuntimeData(preload, dis);
            Preload.LOG.info(msg, (Object)"CPSO", (Object)Formats.number((long)this.preload.stateCPSO.count));
            this.preload.cpsoq = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
        }
        if (flags[3]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.statePredLists = new Preload.RuntimeData(preload, dis);
            Preload.LOG.info(msg, (Object)"PredLists", (Object)Formats.number((long)this.preload.statePredLists.count));
            this.preload.plistsq = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
        }
        if (flags[4]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.stateLiterals = new Preload.LiteralsIndexData(preload, dis);
            if (this.preload.stateLiterals.mode == 0) {
                Preload.LOG.info(msg, (Object)"Numerics and dates", (Object)Formats.number((long)this.preload.stateLiterals.count));
                this.preload.numericsq = new CompressedSortedChunksFileQueue(Preload.iteratorCache, dis);
                this.preload.datesq = new CompressedSortedChunksFileQueue(Preload.iteratorCache, dis);
            } else if (this.preload.stateLiterals.mode == 1) {
                Preload.LOG.info(msg, (Object)"Dates", (Object)Formats.number((long)this.preload.stateLiterals.count));
                this.preload.datesq = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
            }
        }
        if (flags[5]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.statePOST = new Preload.POSTIndexData(preload, dis);
            Preload.LOG.info(msg, (Object)"POST", (Object)Formats.number((long)this.preload.statePOST.count));
            this.preload.post = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
        }
        if (flags[6]) {
            Preload preload = this.preload;
            Objects.requireNonNull(preload);
            this.preload.statePSOT = new Preload.PSOTIndexData(preload, dis);
            Preload.LOG.info(msg, (Object)"PSOT", (Object)Formats.number((long)this.preload.statePSOT.count));
            this.preload.psot = new CompressedSortedChunksFileQueue(Preload.iteratorCache * 1024, dis);
        }
        this.preload.preadStatCreated = dis.readBoolean();
        if (!this.preload.preadStatCreated) {
            if (this.preload.map == null) {
                this.preload.map = new HashMap();
            }
            this.preload.readPredicateStatistics(this.preload.map, dis);
            if (this.preload.tripleMap == null) {
                this.preload.tripleMap = new HashMap();
            }
            this.preload.readPredicateStatistics(this.preload.tripleMap, dis);
        }
    }

    private void closeAndSwap(File recoverPointExisting, File recoverPoint, DataOutputStream dos, boolean normal) {
        if (dos != null) {
            try {
                dos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (normal) {
                File oldOne = new File(recoverPointExisting.getParentFile(), recoverPointExisting.getName() + ".old");
                recoverPointExisting.renameTo(oldOne);
                recoverPoint.renameTo(recoverPointExisting);
                oldOne.delete();
            }
        }
    }

    private boolean[] enterPhaseThree() {
        boolean[] flags = new boolean[7];
        if (this.preload.statePOSC != null && !this.preload.statePOSC.done) {
            if (this.preload.statePOSC.adapter != null) {
                this.preload.statePOSC.adapter.pauseOperation();
            }
            if (!this.preload.statePOSC.done) {
                flags[0] = true;
            } else {
                this.preload.statePOSC.adapter.resumeOperation();
            }
        }
        if (this.preload.statePSOC != null && !this.preload.statePSOC.done) {
            if (this.preload.statePSOC.adapter != null) {
                this.preload.statePSOC.adapter.pauseOperation();
            }
            if (!this.preload.statePSOC.done) {
                flags[1] = true;
            } else {
                this.preload.statePSOC.adapter.resumeOperation();
            }
        }
        if (this.preload.stateCPSO != null && !this.preload.stateCPSO.done) {
            if (this.preload.stateCPSO.adapter != null) {
                this.preload.stateCPSO.adapter.pauseOperation();
            }
            if (!this.preload.stateCPSO.done) {
                flags[2] = true;
            } else {
                this.preload.stateCPSO.adapter.resumeOperation();
            }
        }
        if (this.preload.statePredLists != null && !this.preload.statePredLists.done) {
            if (this.preload.statePredLists.adapter != null) {
                this.preload.statePredLists.adapter.pauseOperation();
            }
            if (!this.preload.statePredLists.done) {
                flags[3] = true;
            } else {
                this.preload.statePredLists.adapter.resumeOperation();
            }
        }
        if (this.preload.stateLiterals != null && !this.preload.stateLiterals.done) {
            if (this.preload.stateLiterals.adapter != null) {
                this.preload.stateLiterals.adapter.pauseOperation();
            }
            if (!this.preload.stateLiterals.done) {
                flags[4] = true;
            } else {
                this.preload.stateLiterals.adapter.resumeOperation();
            }
        }
        if (this.preload.statePOST != null && !this.preload.statePOST.done) {
            if (this.preload.statePOST.adapter != null) {
                this.preload.statePOST.adapter.pauseOperation();
            }
            if (!this.preload.statePOST.done) {
                flags[5] = true;
            } else {
                this.preload.statePOST.adapter.resumeOperation();
            }
        }
        if (this.preload.statePSOT != null && !this.preload.statePSOT.done) {
            if (this.preload.statePSOT.adapter != null) {
                this.preload.statePSOT.adapter.pauseOperation();
            }
            if (!this.preload.statePSOT.done) {
                flags[6] = true;
            } else {
                this.preload.statePSOT.adapter.resumeOperation();
            }
        }
        return flags;
    }

    private void leavePhaseThree(boolean[] flags) {
        if (flags[0] && this.preload.statePOSC.adapter != null) {
            this.preload.statePOSC.adapter.resumeOperation();
        }
        if (flags[1] && this.preload.statePSOC.adapter != null) {
            this.preload.statePSOC.adapter.resumeOperation();
        }
        if (flags[2] && this.preload.stateCPSO.adapter != null) {
            this.preload.stateCPSO.adapter.resumeOperation();
        }
        if (flags[3] && this.preload.statePredLists.adapter != null) {
            this.preload.statePredLists.adapter.resumeOperation();
        }
        if (flags[4] && this.preload.stateLiterals.adapter != null) {
            this.preload.stateLiterals.adapter.resumeOperation();
        }
        if (flags[5] && this.preload.statePOST.adapter != null) {
            this.preload.statePOST.adapter.resumeOperation();
        }
        if (flags[6] && this.preload.statePSOT.adapter != null) {
            this.preload.statePSOT.adapter.resumeOperation();
        }
    }

    private void createInitialRestorePoint(File recoverPointExisting, File recoverPoint) {
        DataOutputStream dos = null;
        boolean normal = false;
        try {
            dos = new DataOutputStream(new FileOutputStream(recoverPoint));
            dos.writeInt(0);
            this.persistCommonSettings(dos);
            long count = this.persisitRDFFilesInfo(dos);
            normal = true;
            Preload.LOG.info("Initial restore point created, count so far " + Formats.number((long)count));
        }
        catch (FileNotFoundException e1) {
            Preload.LOG.error("Error while creating an initial restore point", (Throwable)e1);
        }
        catch (IOException e1) {
            Preload.LOG.error("Error while persisting the initial restore point", (Throwable)e1);
        }
        catch (Error e1) {
            Preload.LOG.error("Error while creating an initial restore point", (Throwable)e1);
            throw e1;
        }
        finally {
            this.closeAndSwap(recoverPointExisting, recoverPoint, dos, normal);
        }
    }

    private void createPhaseOneRestorePoint(File recoverPointExisting, File recoverPoint) {
        DataOutputStream dos = null;
        boolean normal = false;
        try {
            dos = new DataOutputStream(new FileOutputStream(recoverPoint));
            dos.writeInt(1);
            this.persistCommonSettings(dos);
            long count = this.persisitRDFFilesInfo(dos);
            this.persistQueuesState(dos);
            normal = true;
            Preload.LOG.info("Parsing mode restore point created, count so far " + Formats.number((long)count));
        }
        catch (FileNotFoundException e1) {
            Preload.LOG.error("Error while creating a restore point", (Throwable)e1);
        }
        catch (IOException e1) {
            Preload.LOG.error("Error while persisting restore point", (Throwable)e1);
        }
        catch (Error e1) {
            Preload.LOG.error("Error while creating a restore point", (Throwable)e1);
            throw e1;
        }
        finally {
            this.closeAndSwap(recoverPointExisting, recoverPoint, dos, normal);
        }
    }

    private void initFromInitialRestorePoint(DataInputStream dis) throws IOException {
        this.readCommonSettings(dis);
        this.readRDFFilesInfo(dis);
    }

    private void initFromPhaseOneRestorePoint(DataInputStream dis) throws IOException {
        this.readCommonSettings(dis);
        this.readRDFFilesInfo(dis);
        this.readQueueState(dis);
    }

    private void enterPhaseOne() {
        this.fromResolver.set(false);
        this.enter.set(true);
        Preload.LOG.info("Pause parsers ... ");
        this.lock.unlock();
        for (int i = 0; i < this.permits; ++i) {
            this.trigger.acquireUninterruptibly();
        }
        while (this.numParserWaiting.get() < this.permits) {
            Preload.LOG.info("Still waiting for parsers to pause!");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException i) {}
        }
        this.lock.lock();
        Preload.LOG.info("Permits acquired");
        this.createRestore.set(true);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.fromSorter.awaitUninterruptibly();
        this.fromResolver.set(false);
    }

    private void leavePhaseOne() {
        this.enter.set(false);
        this.forParsers.signalAll();
        this.fromResolver.set(false);
        this.trigger.release(this.permits);
        this.createRestore.set(false);
    }

    private long persisitRDFFilesInfo(DataOutputStream dos) throws IOException {
        dos.writeInt(this.preload.enumeratedFiles.size());
        long count = 0L;
        for (Preload.ItemToProcess item : this.preload.enumeratedFiles) {
            dos.writeUTF(item.absolutePath);
            dos.writeBoolean(item.started);
            dos.writeBoolean(item.completed);
            dos.writeLong(item.currentParsedTupple.get());
            if (item.started && !item.completed) {
                Preload.LOG.info("Storing parsing state for file " + item.absolutePath + ", at position " + Formats.number((long)item.currentParsedTupple.get()) + ", completed=" + item.completed);
            }
            count += item.currentParsedTupple.get();
        }
        return count;
    }

    private void readRDFFilesInfo(DataInputStream dis) throws IOException {
        int countiles = dis.readInt();
        for (int i = 0; i < countiles; ++i) {
            String name = dis.readUTF();
            boolean started = dis.readBoolean();
            boolean completed = dis.readBoolean();
            long count = dis.readLong();
            Preload.ItemToProcess item = new Preload.ItemToProcess(name, started, completed, count);
            this.preload.enumeratedFiles.add(item);
        }
    }

    private void persistCommonSettings(DataOutputStream dos) throws IOException {
        dos.writeInt(Preload.chunkSize);
        dos.writeInt(Preload.iteratorCache);
        dos.writeBoolean(this.preload.buildContextIndex);
        dos.writeBoolean(this.preload.buildPredLists);
        dos.writeBoolean(this.preload.buildLiteralIndexCollections);
        dos.writeBoolean(this.preload.buildLiteralProperties);
        dos.writeLong(this.preload.countResolved);
        dos.writeLong(this.preload.countSorted);
    }

    private void readCommonSettings(DataInputStream dis) throws IOException {
        Preload.chunkSize = dis.readInt();
        Preload.iteratorCache = dis.readInt();
        this.preload.buildContextIndex = dis.readBoolean();
        this.preload.buildPredLists = dis.readBoolean();
        this.preload.buildLiteralIndexCollections = dis.readBoolean();
        this.preload.buildLiteralProperties = dis.readBoolean();
        this.preload.countResolved = dis.readLong();
        this.preload.countSorted = dis.readLong();
    }

    private void persistQueuesState(DataOutputStream dos) throws IOException {
        Preload.LOG.info("Storing POS q");
        this.preload.posq.writeState(dos);
        Preload.LOG.info("Storing PSO q");
        this.preload.psoq.writeState(dos);
        if (this.preload.buildContextIndex) {
            Preload.LOG.info("Storing CPSO q");
            this.preload.cpsoq.writeState(dos);
        }
        if (this.preload.buildPredLists) {
            Preload.LOG.info("Storing predlists q");
            this.preload.plistsq.writeState(dos);
        }
        if (this.preload.buildLiteralIndexCollections) {
            dos.writeLong(this.preload.num_literals);
            dos.writeLong(this.preload.num_numbers);
            dos.writeLong(this.preload.num_dates);
            Preload.LOG.info("Storing NUM q");
            this.preload.numericsq.writeState(dos);
            Preload.LOG.info("Storing DATES q");
            this.preload.datesq.writeState(dos);
        }
        Preload.LOG.info("Storing POST q");
        this.preload.post.writeState(dos);
        Preload.LOG.info("Storing PSOT q");
        this.preload.psot.writeState(dos);
    }

    private void readQueueState(DataInputStream dis) throws IOException {
        this.preload.posq = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
        this.preload.psoq = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
        if (this.preload.buildContextIndex) {
            this.preload.cpsoq = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
        }
        if (this.preload.buildPredLists) {
            this.preload.plistsq = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
        }
        if (this.preload.buildLiteralIndexCollections) {
            this.preload.num_literals = dis.readLong();
            this.preload.num_numbers = dis.readLong();
            this.preload.num_dates = dis.readLong();
            this.preload.numericsq = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
            this.preload.datesq = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
        }
        this.preload.post = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
        this.preload.psot = new CompressedSortedChunksFileQueue(Preload.chunkSize, dis);
    }
}

