/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.graphdb.importrdf.Load;
import com.ontotext.load.AbortRDFHandlingException;
import com.ontotext.raft.repository.DummyTransactionNotify;
import com.ontotext.rio.parallel.BaseParser;
import com.ontotext.rio.parallel.ParallelLoader;
import com.ontotext.trree.OwlimConnection;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.RepositoryMonitorTrackRecordImpl;
import com.ontotext.trree.SailConnectionImpl;
import com.ontotext.trree.entitypool.EntityPoolConnection;
import com.ontotext.trree.io.FileSystemHealth;
import com.ontotext.trree.transactions.TransactionException;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.sail.SailException;

public class ParallelizedParser
extends BaseParser {
    private final OwlimSchemaRepository owlim;
    private OwlimConnection connection;
    private FileSystemHealth.FreeSpaceSnapshot freeSpaceSnapshot;
    FileSystemHealth.DiskChecker diskChecker;

    public ParallelizedParser(SailConnectionImpl conn, long[] statementCount, OwlimSchemaRepository owlim) {
        super(conn, statementCount);
        this.owlim = owlim;
        this.diskChecker = FileSystemHealth.getInstance().createOperationBasedDiskCheck();
    }

    public void startRDF() throws RDFHandlerException {
        try {
            Load.LOG.info("Loading file: " + this.getFileName());
            this.freeSpaceSnapshot = FileSystemHealth.getInstance().canStartTransaction(this.owlim.getRepositoryId());
            this.start = System.currentTimeMillis();
            this.startStatementCount = this.statementCount[0];
            this.prevTime = this.start;
            this.connection = this.owlim.getOwlimConnection();
            this.connection.getEntityPoolConnection().beginExclusive();
            this.connection.getRepositoryConnection().beginTransaction();
            this.connection.getPropertiesConnection().beginTransaction();
            RepositoryMonitorTrackRecordImpl dummyTrackRecord = new RepositoryMonitorTrackRecordImpl(0L);
            this.owlim.getParallelLoader().begin(this.connection, dummyTrackRecord, x -> DummyTransactionNotify.INSTANCE);
        }
        catch (TransactionException | SailException ex) {
            throw new RDFHandlerException(ex);
        }
    }

    public void handleStatement(Statement s) throws RDFHandlerException {
        this.statementCount[0] = this.statementCount[0] + 1L;
        this.printStatus(false);
        try {
            this.diskChecker.check();
        }
        catch (SailException se) {
            throw new AbortRDFHandlingException((Exception)((Object)se));
        }
        this.owlim.getParallelLoader().handleStatement(s.getSubject(), s.getPredicate(), s.getObject(), s.getContext());
    }

    public void endRDF() throws RDFHandlerException {
        try {
            FileSystemHealth.getInstance().canCommitTransaction(this.freeSpaceSnapshot);
            EntityPoolConnection entities = this.connection.getEntityPoolConnection();
            entities.precommit();
            this.owlim.getParallelLoader().end(this.conn);
            entities.commit();
            this.connection.getRepositoryConnection().commit();
            this.connection.getPropertiesConnection().commit();
            this.owlim.getParallelLoader().transactionCompleted();
            this.printStatus(true);
            this.connection.close();
        }
        catch (Exception ex) {
            throw new RDFHandlerException((Throwable)ex);
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.owlim.getParallelLoader().addNamespaceIfMissing(prefix, uri);
    }

    public void processException(Exception e) throws AbortRDFHandlingException {
        if (e instanceof UnsupportedRDFormatException) {
            if (Load.ignoreCorruptFiles.booleanValue()) {
                Load.LOG.warn("Skip file {} due to unsupported rdf format! {}", (Object)this.getFileName(), (Object)e.getMessage());
                this.ignoredFiles.add(this.getFileName());
                return;
            }
            throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)e);
        }
        if (e instanceof RDFParseException) {
            if (Load.ignoreCorruptLines.booleanValue()) {
                Load.LOG.warn("Load only part of file {} due to parsing exception! {}", (Object)this.getFileName(), (Object)e.getMessage());
                try {
                    this.endRDF();
                }
                catch (RDFHandlerException ex) {
                    throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)ex);
                }
                this.partiallyLoadedFiles.add(this.getFileName());
                return;
            }
            this.rollback();
            if (Load.ignoreCorruptFiles.booleanValue()) {
                Load.LOG.warn("Skip file {} due to parsing exception! {}", (Object)this.getFileName(), (Object)e.getMessage());
                this.ignoredFiles.add(this.getFileName());
                return;
            }
            throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)e);
        }
        if (e instanceof RuntimeException) {
            this.rollback();
            throw new AbortRDFHandlingException("Abort loading at file: " + this.getFileName(), (Throwable)e);
        }
        super.processException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollback() {
        if (this.connection == null) {
            return;
        }
        long transactionId = -1L;
        try {
            try {
                ParallelLoader loader = this.owlim.getParallelLoader();
                transactionId = loader.getTransactionId();
                loader.end(this.conn);
                return;
            }
            catch (Exception e) {
                Load.LOG.error("Rollback step failed!", (Throwable)e);
                return;
            }
            finally {
                try {
                    this.connection.getEntityPoolConnection().rollback();
                }
                catch (Exception e) {
                    Load.LOG.error("Rollback step failed!", (Throwable)e);
                }
                finally {
                    try {
                        this.connection.getPropertiesConnection().rollback();
                    }
                    catch (Exception e) {
                        Load.LOG.error("Rollback step failed!", (Throwable)e);
                    }
                    finally {
                        try {
                            this.connection.getRepositoryConnection().rollback();
                        }
                        catch (Exception e) {
                            Load.LOG.error("Rollback step failed!", (Throwable)e);
                        }
                        finally {
                            if (transactionId > -1L) {
                                this.owlim.getPluginManager().transactionAborted(transactionId);
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.connection.close();
        }
    }

    public String toString() {
        return "parallel";
    }
}

