/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MemoryUtil {
    static DecimalFormat myFormatter = new DecimalFormat("#,###");
    MemoryMXBean memBean;
    List<BufferPoolMXBean> direct;
    long maxDirectMemory = MemoryUtil.calcMaxDirectMemory();
    long physicalMemory = -1L;

    static String formatThousentSeparator(long value) {
        return myFormatter.format(value);
    }

    private static long calcMaxDirectMemory() {
        try {
            Class<?> VM = Class.forName("sun.misc.VM");
            Method maxDirectMemory = VM.getDeclaredMethod("maxDirectMemory", new Class[0]);
            Object result = maxDirectMemory.invoke(null, (Object[])null);
            return (Long)result;
        }
        catch (Exception e) {
            return Runtime.getRuntime().maxMemory();
        }
    }

    public long getPhysicalMemory() {
        return this.physicalMemory;
    }

    public MemoryUtil() {
        this.memBean = ManagementFactory.getMemoryMXBean();
        this.direct = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        String data = null;
        try {
            data = ManagementFactory.getPlatformMBeanServer().getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize").toString();
            this.physicalMemory = Long.parseLong(data);
            if (this.maxDirectMemory > this.physicalMemory) {
                this.maxDirectMemory = this.physicalMemory;
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            e.printStackTrace();
        }
    }

    public long directMax() {
        return this.maxDirectMemory;
    }

    public long directFree() {
        long used = 0L;
        for (BufferPoolMXBean b : this.direct) {
            used += b.getMemoryUsed();
        }
        return this.maxDirectMemory - used - this.memBean.getNonHeapMemoryUsage().getUsed();
    }

    public long heapFree() {
        MemoryUsage b = this.memBean.getHeapMemoryUsage();
        return b.getMax() - b.getUsed();
    }

    public long heapMax() {
        MemoryUsage b = this.memBean.getHeapMemoryUsage();
        return b.getMax();
    }

    public void gc() {
        System.gc();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

