/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.importrdf.BaseLoadTool;
import com.ontotext.graphdb.importrdf.ParallelizedParser;
import com.ontotext.graphdb.importrdf.SerialParser;
import com.ontotext.load.AbortRDFHandlingException;
import com.ontotext.load.GraphdbRDFLoader;
import com.ontotext.rio.parallel.BaseParser;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.SailConnectionImpl;
import com.ontotext.trree.util.Formats;
import com.ontotext.trree.util.lru.Metrics;
import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="load", description={"Loads data using an algorithm very similar to the online data loading."}, separator=" ")
public class Load
extends BaseLoadTool {
    @CommandLine.Option(names={"-m", "--mode"}, description={"Singlethreaded (serial) or multithreaded (parallel) mode for parse/load/infer."}, paramLabel="<serial|parallel>", defaultValue="serial", required=true)
    private static Modes mode;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Whether to print metrics during load."}, defaultValue="false")
    private static Boolean verbose;
    @CommandLine.Option(names={"-p", "--partial-load"}, description={"Whether to allow partial load of file that contains corrupt line."}, defaultValue="false")
    protected static Boolean ignoreCorruptLines;
    @CommandLine.Option(names={"-s", "--stop-on-error"}, description={"Whether to stop process if the dataset contains a corrupt file."}, defaultValue="true")
    protected static Boolean ignoreCorruptFiles;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    @Override
    protected void logUserInput() {
        LOG.info("STOP ON FIRST ERROR: " + (ignoreCorruptFiles == false));
        LOG.info("PARTIAL LOAD: " + ignoreCorruptLines);
        LOG.info("MODE: " + String.valueOf((Object)mode));
        super.logUserInput();
    }

    @Override
    public Integer call() throws Exception {
        LOG = LoggerFactory.getLogger(Load.class);
        this.validate();
        this.logUserInput();
        mainProcess = Load::mainLoadRDFInternal;
        return this.mainInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainLoadRDFInternal(OwlimSchemaRepository owlim, GraphDBRepositoryManager localRepositoryManager) throws Exception {
        BaseParser rdfHandler;
        long[] statementCount = new long[1];
        ParserConfig pconfig = Load.getParserConfig(ignoreCorruptLines);
        GraphdbRDFLoader loader = new GraphdbRDFLoader(pconfig, (ValueFactory)SimpleValueFactory.getInstance());
        try (SailConnectionImpl conn = (SailConnectionImpl)owlim.getConnection();){
            if (mode.equals((Object)Modes.serial)) {
                rdfHandler = new SerialParser(conn, statementCount, owlim);
            } else if (mode.equals((Object)Modes.parallel)) {
                rdfHandler = new ParallelizedParser(conn, statementCount, owlim);
            } else {
                LOG.error("Unsupported parser mode.");
                int n = 1;
                return n;
            }
            Slf4jReporter reporter = null;
            if (verbose.booleanValue()) {
                MetricRegistry metrics = Metrics.registryFromStoragePath((String)owlim.getStorageFolder());
                reporter = Slf4jReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(LOG).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).build();
            }
            for (MetricRegistry file : filesToBeLoaded) {
                try {
                    loader.load((File)file, "http://www.ontotext.com/", null, (RDFHandler)rdfHandler);
                    if (!verbose.booleanValue()) continue;
                    reporter.report();
                }
                catch (AbortRDFHandlingException ahe) {
                    conn.close();
                    localRepositoryManager.shutDown();
                    LOG.error(String.format("%s Reason: %s", ahe.getMessage(), ahe.getCause().getMessage()));
                    int n = 1;
                    if (conn != null) {
                        conn.close();
                    }
                    localRepositoryManager.shutDown();
                    return n;
                }
            }
        }
        finally {
            localRepositoryManager.shutDown();
        }
        long time = System.currentTimeMillis() - rdfHandler.getStartTime();
        long rate = statementCount[0] * 1000L / time;
        long endTime = System.currentTimeMillis() - rdfHandler.getStartTime();
        LOG.info("Job finished successfully on " + String.valueOf(new Date()) + ". Parsed " + Formats.number((long)statementCount[0]) + " statements in " + Formats.number((long)endTime) + " ms, avg rate = " + Formats.number((long)rate) + " st/s.");
        if (rdfHandler.getIgnoredFiles().size() > 0) {
            LOG.warn("## Ignored files during load: ##");
            for (String file : rdfHandler.getIgnoredFiles()) {
                LOG.warn(file);
            }
        }
        if (rdfHandler.getPartiallyLoadedFiles().size() > 0) {
            LOG.warn("## Partially loaded files during load: ##");
            for (String file : rdfHandler.getPartiallyLoadedFiles()) {
                LOG.warn(file);
            }
        }
        return 0;
    }

    public static enum Modes {
        serial,
        parallel;

    }
}

