/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.GraphDBConfigParameters;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.trree.GraphDBParserConfig;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.config.OWLIMSailSchema;
import com.ontotext.trree.util.FileUtils;
import com.ontotext.trree.util.PreloadRecoverCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.DelegatingRepository;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.helpers.SailWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class BaseLoadTool
implements Callable<Integer> {
    protected static Logger LOG;
    public static boolean testing;
    @CommandLine.Parameters(index="0", paramLabel="FILE", arity="1..*", description={"Files to be loaded."})
    protected static File[] filesToBeLoaded;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display this message and exit!"})
    boolean help;
    @CommandLine.Option(names={"-f", "--force"}, description={"Whether to overwrite the existing repository."}, defaultValue="false")
    protected static Boolean forceOverwrite;
    @CommandLine.ArgGroup(multiplicity="1")
    RepositoryConfig repoConf;
    protected static MainProcess mainProcess;
    protected static boolean foundRecoverPoint;
    protected static PreloadRecoverCheck preload;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    public boolean isRestart() {
        return false;
    }

    protected void validate() {
        this.validateFilesToBeLoaded();
        this.validateRepositoryId();
        this.validateConfigFile();
    }

    private void validateFilesToBeLoaded() {
        for (File file : filesToBeLoaded) {
            if (file.exists()) continue;
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("File: '%s' does not exist.", file.getAbsolutePath()));
        }
    }

    private void validateConfigFile() {
        if (RepositoryConfig.configFile == null) {
            return;
        }
        if (!RepositoryConfig.configFile.exists()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Config file '%s' does not exist!", RepositoryConfig.configFile.getAbsolutePath()));
        }
        if (RepositoryConfig.configFile.isDirectory()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Entry for config file '%s' is a directory!", RepositoryConfig.configFile.getAbsolutePath()));
        }
        if (!RepositoryConfig.configFile.getAbsolutePath().endsWith(".ttl")) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Config file '%s' is nota standard GraphDB config file(.ttl)!", RepositoryConfig.configFile.getAbsolutePath()));
        }
    }

    private void validateRepositoryId() {
        if (RepositoryConfig.repositoryId == null) {
            return;
        }
        if (RepositoryConfig.repositoryId.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Repository id '%s' is an empty string!", RepositoryConfig.repositoryId));
        }
    }

    protected void logUserInput() {
        if (RepositoryConfig.configFile != null) {
            LOG.info("CONFIG FILE: " + String.valueOf(RepositoryConfig.configFile));
        } else {
            LOG.info("REPOSITORY NAME: " + RepositoryConfig.repositoryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainInternal() throws Exception {
        OwlimSchemaRepository owlim;
        System.setProperty(GraphDBConfigParameters.PARAM_USE_SHUTDOWN_HOOKS.name(), "false");
        if (LOG == null) {
            LOG = LoggerFactory.getLogger(BaseLoadTool.class);
        }
        GraphDBRepositoryManager localRepositoryManager = new GraphDBRepositoryManager(new File(Config.getDataDirectory()));
        LOG.info("Attaching to location: {}", (Object)Config.getDataDirectory());
        localRepositoryManager.init();
        boolean ignoreRestorePointIfPresent = this.isRestart();
        if (RepositoryConfig.repositoryId != null) {
            boolean hasRepository = localRepositoryManager.hasRepositoryConfig(RepositoryConfig.repositoryId);
            if (!hasRepository) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Repository '%s' does not exist!", RepositoryConfig.repositoryId));
            }
            File toRemove = BaseLoadTool.detectRecoveryFile(localRepositoryManager, RepositoryConfig.repositoryId, null);
            try {
                if ((toRemove == null || ignoreRestorePointIfPresent) && forceOverwrite.booleanValue()) {
                    File storage = localRepositoryManager.getRepositoryDir(RepositoryConfig.repositoryId);
                    if (storage.exists()) {
                        for (String file : storage.list()) {
                            File subFile = new File(storage, file);
                            if (!subFile.isDirectory()) continue;
                            FileUtils.recursiveDelete((File)subFile);
                        }
                    }
                    foundRecoverPoint = false;
                    owlim = BaseLoadTool.getSail(localRepositoryManager.getRepository(RepositoryConfig.repositoryId));
                }
                if (toRemove == null || ignoreRestorePointIfPresent) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "When using repository id, the --force option is required in order to overwrite the existing repository image!");
                }
                owlim = BaseLoadTool.getSail(localRepositoryManager.getRepository(RepositoryConfig.repositoryId));
            }
            finally {
                if (toRemove != null) {
                    toRemove.delete();
                }
            }
        } else {
            try {
                owlim = this.createRepositoryInSystemLocation(localRepositoryManager, RepositoryConfig.configFile, forceOverwrite);
            }
            catch (IllegalArgumentException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage());
            }
        }
        return mainProcess.mainProcess(owlim, localRepositoryManager);
    }

    private static File detectRecoveryFile(GraphDBRepositoryManager localRepositoryManager, String repositoryId, Model graph) {
        File storageFileFolder;
        Value val;
        File base = localRepositoryManager.getRepositoryDir(repositoryId);
        if (graph == null) {
            if (!localRepositoryManager.hasRepositoryConfig(repositoryId)) {
                return null;
            }
            org.eclipse.rdf4j.repository.config.RepositoryConfig conf = localRepositoryManager.getRepositoryConfig(repositoryId);
            graph = new TreeModel();
            conf.export(graph);
        }
        if ((val = (Value)Models.object((Model)graph.filter(null, OWLIMSailSchema.storagefolder, null, new Resource[0])).orElse(null)) != null) {
            String storageFolderString = val.stringValue();
            storageFileFolder = new File(storageFolderString);
        } else {
            storageFileFolder = new File((String)GraphDBConfigParameters.STORAGE_FOLDER.defaultValue());
        }
        if (!storageFileFolder.isAbsolute()) {
            storageFileFolder = new File(base, storageFileFolder.getName());
        }
        File toRemove = null;
        preload = new PreloadRecoverCheck(storageFileFolder.getAbsolutePath());
        boolean valid = false;
        if (BaseLoadTool.preload.preload.exists()) {
            if (BaseLoadTool.preload.preloadNew.exists()) {
                preload.deleteNew();
            }
            valid = true;
        } else if (BaseLoadTool.preload.preloadOld.exists()) {
            if (BaseLoadTool.preload.preloadNew.exists()) {
                BaseLoadTool.preload.preloadNew.renameTo(BaseLoadTool.preload.preload);
                BaseLoadTool.preload.preloadOld.delete();
                valid = true;
            } else {
                BaseLoadTool.preload.preloadOld.renameTo(BaseLoadTool.preload.preload);
                valid = true;
            }
        }
        if (valid) {
            toRemove = BaseLoadTool.preload.preloadIgnore;
            try {
                toRemove.createNewFile();
                foundRecoverPoint = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.warn("Recovery point detected !");
        }
        return toRemove;
    }

    protected static OwlimSchemaRepository getSail(Repository repository) {
        while (repository instanceof DelegatingRepository) {
            repository = ((RepositoryWrapper)repository).getDelegate();
        }
        if (!(repository instanceof SailRepository)) {
            throw new IllegalStateException("Only sail repositories are supported");
        }
        Sail sail = ((SailRepository)repository).getSail();
        while (sail instanceof SailWrapper) {
            sail = ((SailWrapper)sail).getBaseSail();
        }
        if (!(sail instanceof OwlimSchemaRepository)) {
            throw new IllegalStateException("Only graphdb repositories are supported");
        }
        return (OwlimSchemaRepository)sail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OwlimSchemaRepository createRepositoryInSystemLocation(GraphDBRepositoryManager localRepositoryManager, File configFile, boolean force) throws Exception {
        try (FileInputStream fis = new FileInputStream(configFile);){
            OwlimSchemaRepository owlimSchemaRepository;
            block15: {
                TreeModel graph = new TreeModel();
                RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
                rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph));
                rdfParser.parse((InputStream)fis, "tag:rdf4j.org,2023:config/");
                Resource repositoryNode = Configurations.getSubjectByType((Model)graph, (IRI)CONFIG.Rep.Repository, (IRI)RepositoryConfigSchema.REPOSITORY).orElse(null);
                org.eclipse.rdf4j.repository.config.RepositoryConfig repositoryConfig = org.eclipse.rdf4j.repository.config.RepositoryConfig.create((Model)graph, (Resource)repositoryNode);
                String repositoryId = repositoryConfig.getID();
                File toRemove = null;
                boolean ignoreRestorePointIfPresent = this.isRestart();
                if (localRepositoryManager.hasRepositoryConfig(repositoryId)) {
                    toRemove = BaseLoadTool.detectRecoveryFile(localRepositoryManager, repositoryId, (Model)graph);
                    if (force) {
                        if (!foundRecoverPoint || ignoreRestorePointIfPresent) {
                            File storage = localRepositoryManager.getRepositoryDir(repositoryId);
                            FileUtils.recursiveDelete((File)storage);
                            localRepositoryManager.removeRepository(repositoryId);
                            foundRecoverPoint = false;
                        }
                    } else if (!foundRecoverPoint) {
                        throw new IllegalArgumentException("Repository " + repositoryId + " already exists, use --force in order to overwrite repo configuration and image.");
                    }
                }
                if (!foundRecoverPoint) {
                    localRepositoryManager.addRepositoryConfig(repositoryConfig);
                }
                try {
                    owlimSchemaRepository = BaseLoadTool.getSail(localRepositoryManager.getRepository(repositoryConfig.getID()));
                    if (toRemove == null) break block15;
                    toRemove.delete();
                }
                catch (Throwable throwable) {
                    if (toRemove != null) {
                        toRemove.delete();
                    }
                    throw throwable;
                }
            }
            return owlimSchemaRepository;
        }
    }

    protected static ParserConfig getParserConfig(boolean ignoreCorruptLines) {
        ParserConfig pconfig = GraphDBParserConfig.newInstance();
        if (ignoreCorruptLines) {
            pconfig.set((RioSetting)BasicParserSettings.VERIFY_URI_SYNTAX, (Object)false);
        }
        pconfig.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)false);
        pconfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        pconfig.set((RioSetting)BasicParserSettings.VERIFY_LANGUAGE_TAGS, (Object)false);
        pconfig.set((RioSetting)XMLParserSettings.LOAD_EXTERNAL_DTD, (Object)false);
        pconfig.set((RioSetting)XMLParserSettings.PARSE_STANDALONE_DOCUMENTS, (Object)true);
        HashSet<BooleanRioSetting> nonFatalErrors = new HashSet<BooleanRioSetting>();
        nonFatalErrors.add(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        nonFatalErrors.add(XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID);
        pconfig.setNonFatalErrors(nonFatalErrors);
        return pconfig;
    }

    static {
        testing = false;
    }

    protected static class RepositoryConfig {
        @CommandLine.Option(names={"-c", "--config-file"}, description={"Repository defining .ttl file."}, paramLabel="<file>", defaultValue="_NULL_", required=true)
        static File configFile;
        @CommandLine.Option(names={"-i", "--id"}, description={"ID of an existing repository."}, paramLabel="<repository-id>", defaultValue="_NULL_", required=true)
        static String repositoryId;

        protected RepositoryConfig() {
        }
    }

    protected static interface MainProcess {
        public int mainProcess(OwlimSchemaRepository var1, GraphDBRepositoryManager var2) throws Exception;
    }
}

