/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.persistent;

import com.github.jsonldjava.shaded.com.google.common.collect.Sets;
import com.ontotext.models.ConfigInfo;
import com.ontotext.platform.owl2soml.BaseDataAccess;
import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.Constants;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.NamespaceMapping;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.RoleAction;
import com.ontotext.platform.owl2soml.SomlOntology;
import com.ontotext.platform.owl2soml.Utils;
import com.ontotext.platform.owl2soml.memory.InMemoryOntology;
import com.ontotext.platform.owl2soml.persistent.ModelQueryDao;
import com.ontotext.platform.owl2soml.persistent.OntologyReference;
import com.ontotext.platform.owl2soml.persistent.QueryShaclPathResolver;
import com.ontotext.platform.owl2soml.persistent.ResourceOntologyReference;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.sparql.AskRequest;
import com.ontotext.sparql.ConsumingTupleQueryResultHandler;
import com.ontotext.sparql.MapPropertyResultHandler;
import com.ontotext.sparql.OneToManyDistinctPropertyResultHandler;
import com.ontotext.sparql.OneToManyPropertyResultHandler;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SinglePropertyResultHandler;
import com.ontotext.sparql.SparqlConnection;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Rdf4jModelQueryDaoImpl
implements ModelQueryDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String PREFIX_OWL = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
    public static final String PREFIX_SO = "PREFIX so: <http://www.ontotext.com/semantic-object/>\n";
    public static final String PREFIX_RDF = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
    public static final String PREFIX_SCHEMA_ORG = "PREFIX schema: <http://schema.org/>\n";
    public static final String PREFIX_RDFS = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n";
    public static final String PREFIX_GRAPHQL = "PREFIX graphql: <http://datashapes.org/graphql#>\n";
    public static final String PREFIX_SHACL = "PREFIX sh: <http://www.w3.org/ns/shacl#>\n";
    public static final String PREFIX_DASH = "PREFIX dash: <http://datashapes.org/dash#>\n";
    public static final String PREFIX_VANN = "PREFIX vann: <http://purl.org/vocab/vann/>\n";
    public static final String PREFIX_SWC = "PREFIX dash: <http://schema.semantic-web.at/ppt/>\n";
    public static final String PREFIX_XSD = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\n";
    public static final String PREFIX_VOID = "PREFIX void: <http://rdfs.org/ns/void#>\n";
    public static final IRI EXPLICIT = vf.createIRI("http://www.ontotext.com/explicit");
    public static final IRI IMPLICIT = vf.createIRI("http://www.ontotext.com/implicit");
    private final SparqlConnection connection;
    private Namespaces namespaces;
    private Config config;
    private final Set<IRI> contexts = new LinkedHashSet<IRI>();
    private final Map<String, AtomicInteger> statistics = new LinkedHashMap<String, AtomicInteger>();

    public Rdf4jModelQueryDaoImpl(SparqlConnection connection) {
        this.connection = connection;
    }

    @Override
    public void updateStatistics(String key) {
        this.statistics.computeIfAbsent(key, k -> new AtomicInteger()).getAndIncrement();
    }

    @Override
    public void configure(Config config, Namespaces namespaces) {
        this.config = config;
        this.namespaces = namespaces;
    }

    @Override
    public void configureWith(Ontology ontology) {
        Timer timer = Timer.start();
        if (ontology instanceof OntologyReference) {
            if (!this.isOntology(ontology.getOntologyId()) && this.isContext(ontology.getOntologyId())) {
                if (this.isShapesContext(ontology.getOntologyId())) {
                    IRI newContext = this.copyShapesToNewContext(ontology.getOntologyId());
                    ontology.setStoredContext(newContext);
                } else {
                    ontology.setStoredContext(ontology.getOntologyId());
                    this.contexts.add(ontology.getOntologyId());
                }
            }
        } else if (ontology instanceof InMemoryOntology) {
            InMemoryOntology inMemoryOntology = (InMemoryOntology)ontology;
            IRI context = this.addOntologyWithTransaction(() -> this.addStatementsToContext(inMemoryOntology));
            ontology.setStoredContext(context);
            LOGGER.debug("Data loading of {} statements took: {} ms ", (Object)inMemoryOntology.getModel().size(), (Object)timer.getDuration());
        } else if (ontology instanceof ResourceOntologyReference) {
            ResourceOntologyReference ontologyReference = (ResourceOntologyReference)ontology;
            IRI context = this.addOntologyWithTransaction(() -> this.addResourcesToContext(ontologyReference));
            ontology.setStoredContext(context);
            LOGGER.debug("Data loading of {} took: {} ms ", (Object)ontologyReference.getResourceName(), (Object)timer.getDuration());
        }
    }

    private IRI copyShapesToNewContext(IRI shaclContext) {
        IRI context = Values.iri((String)"http://www.ontotext.com/semantic-object/", (String)(UUID.randomUUID().toString().substring(0, 8) + "/" + shaclContext.getLocalName()));
        return this.addOntologyWithTransaction(() -> {
            try (Stream stream = this.connection.stream(null, null, null, new Resource[]{shaclContext});){
                stream.map(st -> Statements.statement((Resource)st.getSubject(), (IRI)st.getPredicate(), (Value)st.getObject(), (Resource)context)).forEach(arg_0 -> ((SparqlConnection)this.connection).addStatement(arg_0));
            }
            return context;
        });
    }

    private boolean isShapesContext(IRI iri) {
        AskRequest ask = AskRequest.newSimpleQuery((String)String.format("ASK { GRAPH <%s> { ?s <http://www.w3.org/ns/shacl#property> ?o . } }", iri.stringValue()));
        return this.connection.hasStatement(null, SHACL.PROPERTY, null, new Resource[]{iri}) && this.connection.executeAsk(ask).isNo();
    }

    @NotNull
    static String outputResource(Resource resource) {
        if (resource instanceof IRI) {
            IRI iri = (IRI)resource;
            return "<" + String.valueOf(iri) + ">";
        }
        if (resource instanceof BNode) {
            return resource.toString();
        }
        if (resource instanceof Triple) {
            return resource.stringValue();
        }
        throw new IllegalArgumentException("Unsupported resource format " + String.valueOf(resource));
    }

    @Override
    public Map<String, Map<String, Role>> findRbacRoles(IRI ontologyId) {
        this.updateStatistics("findAllRbacRoles");
        String filter = "FILTER (isBLANK(?schema)) .";
        if (ontologyId != null) {
            filter = String.format("FILTER (isBLANK(?schema) || ?schema = %s) .", Rdf4jModelQueryDaoImpl.outputResource((Resource)ontologyId));
        }
        String query = String.format("PREFIX so: <http://www.ontotext.com/semantic-object/>\nPREFIX graphql: <http://datashapes.org/graphql#>\nSELECT ?schema ?roleName ?description ?object ?property ?action ?filter\n?notObject ?notProperty ?notAction ?notFilter\n%s\nWHERE {\n    ?schema so:permissions ?permission .\n    %s\n    ?permission %s ?roleName .\n    {\n        OPTIONAL {\n            ?permission %s ?description.\n        }\n    } UNION {\n        ?permission so:actions ?actions.\n        ?actions so:object ?object.\n        ?actions so:property ?property .\n        ?actions so:action ?action .\n        OPTIONAL {\n            ?actions so:filter ?filter .\n        }\n    } UNION {\n        ?permission so:notActions ?notActions.\n        ?notActions so:object ?notObject.\n        ?notActions so:property ?notProperty .\n        ?notActions so:action ?notAction .\n        OPTIONAL {\n            ?notActions so:filter ?notFilter .\n        }\n    }\n}\n", this.createFromClause(), filter, Rdf4jModelQueryDaoImpl.outputIriList((Collection<IRI>)Sets.union(this.config.getNames(), Set.of(SomlOntology.ROLE_NAME)), " | "), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getDescriptionProps(), " | "));
        LinkedHashMap<String, Map<String, Role>> map = new LinkedHashMap<String, Map<String, Role>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.populatePermissions(map));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return map;
    }

    private Consumer<BindingSet> populatePermissions(Map<String, Map<String, Role>> map) {
        return bindingSet -> {
            Value schemaIdValue = bindingSet.getValue("schema");
            String schemaId = schemaIdValue instanceof BNode ? "unbound" : schemaIdValue.toString();
            Map roles = map.computeIfAbsent(schemaId, k -> new TreeMap());
            String roleName = bindingSet.getValue("roleName").stringValue();
            Role role = roles.computeIfAbsent(roleName, k -> new Role(roleName));
            Utils.readStringValue("description", bindingSet, role::setDescription);
            this.readActions(role.getActions(), (BindingSet)bindingSet);
            this.readNotActions(role.getNotActions(), (BindingSet)bindingSet);
        };
    }

    private void readActions(List<RoleAction> actions, BindingSet bindingSet) {
        RoleAction roleAction = new RoleAction();
        Utils.readIriValue("object", bindingSet, roleAction::setObject);
        Utils.readIriValue("property", bindingSet, roleAction::setProperty);
        Utils.readIriValue("action", bindingSet, roleAction::setAction);
        Utils.readStringValue("filter", bindingSet, roleAction::setFilter);
        if (Objects.nonNull(roleAction.getObject())) {
            actions.add(roleAction);
        }
    }

    private void readNotActions(List<RoleAction> nonActions, BindingSet bindingSet) {
        RoleAction roleAction = new RoleAction();
        Utils.readIriValue("notObject", bindingSet, roleAction::setObject);
        Utils.readIriValue("notProperty", bindingSet, roleAction::setProperty);
        Utils.readIriValue("notAction", bindingSet, roleAction::setAction);
        Utils.readStringValue("notFilter", bindingSet, roleAction::setFilter);
        if (Objects.nonNull(roleAction.getObject())) {
            nonActions.add(roleAction);
        }
    }

    @Override
    public Map<String, Map<IRI, Value>> findGenerationConfigs() {
        this.updateStatistics("findGenerationConfigs");
        String query = String.format("SELECT * WHERE {\n  ?schema ?config ?value .\n} VALUES ?config { %s }\n", Rdf4jModelQueryDaoImpl.outputIriList(Config.getConfigInfo().values().stream().map(ConfigInfo::iri).toList(), " "));
        HashMap<String, Map<IRI, Value>> map = new HashMap<String, Map<IRI, Value>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.populateGenerationConfigs(map));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return map;
    }

    private Consumer<BindingSet> populateGenerationConfigs(Map<String, Map<IRI, Value>> map) {
        return bindingSet -> {
            Value schemaIdValue = bindingSet.getValue("schema");
            String schemaId = schemaIdValue instanceof BNode ? "unbound" : schemaIdValue.toString();
            Map configs = map.computeIfAbsent(schemaId, k -> new LinkedHashMap());
            IRI predicate = (IRI)bindingSet.getValue("config");
            Value value = bindingSet.getValue("value");
            configs.put(predicate, value);
        };
    }

    protected IRI addOntologyWithTransaction(Supplier<IRI> ontologyAdder) {
        boolean shaclEnabled = this.connection.isShaclEnabled();
        try {
            this.connection.setShaclEnabled(false);
            this.connection.begin();
            IRI context = ontologyAdder.get();
            this.contexts.add(context);
            this.connection.commit();
            IRI iRI = context;
            return iRI;
        }
        catch (RuntimeException re) {
            this.connection.rollback();
            throw re;
        }
        finally {
            this.connection.setShaclEnabled(shaclEnabled);
        }
    }

    protected IRI addStatementsToContext(InMemoryOntology ontology) {
        for (Namespace namespace : ontology.getModel().getNamespaces()) {
            this.connection.setNamespace(namespace.getPrefix(), namespace.getName());
        }
        IRI context = vf.createIRI("http://www.ontotext.com/semantic-object/", UUID.randomUUID().toString());
        Model model = ontology.getModel();
        for (Statement statement : model) {
            this.connection.addStatement(vf.createStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), (Resource)context));
        }
        return context;
    }

    protected IRI addResourcesToContext(ResourceOntologyReference ontology) {
        IRI context = Values.iri((String)"http://www.ontotext.com/semantic-object/", (String)(UUID.randomUUID().toString().substring(0, 8) + "/" + ontology.getResourceName().replaceAll("\\s+", "_")));
        RDFFormat format = Rio.getParserFormatForFileName((String)ontology.getResourceName()).orElse(RDFFormat.TURTLE);
        try {
            this.connection.add(ontology.getInputStream(), "", format, new Resource[]{context});
        }
        catch (IOException | RDFParseException ex) {
            throw new BadRequestException("Unable to read " + ontology.getResourceName() + " due to: " + ex.getMessage(), ErrorCode.COULD_NOT_READ_INPUT_FILE);
        }
        return context;
    }

    @Override
    public void close() {
        this.statistics.forEach((key, count) -> LOGGER.debug("{} called {} times\n", key, (Object)count.get()));
        LOGGER.debug("Total queries evaluated: {}", (Object)this.statistics.values().stream().mapToInt(AtomicInteger::get).sum());
        this.statistics.clear();
        try {
            List<String> contextsToRemove = this.contexts.stream().map(Value::stringValue).filter(iri -> iri.startsWith("http://www.ontotext.com/semantic-object/")).toList();
            this.connection.dropGraphs(contextsToRemove);
        }
        finally {
            this.connection.close();
        }
    }

    @Override
    public boolean isContext(IRI iri) {
        return this.connection.hasStatement(null, null, null, new Resource[]{iri});
    }

    @Override
    public boolean isOntology(IRI iri) {
        return this.connection.hasStatement((Resource)iri, RDF.TYPE, (Value)OWL.ONTOLOGY, new Resource[0]);
    }

    @Override
    public Optional<Value> getConfiguration(IRI modelId, IRI configPredicate) {
        Object values = "";
        if (modelId != null) {
            values = " VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputResource((Resource)modelId) + "}";
        }
        String query = PREFIX_SO + String.format("SELECT ?config WHERE {\n  {\n    ?model %s ?config .\n  } union {\n    [] %1$s ?config .\n  }\n} %s\n", Rdf4jModelQueryDaoImpl.outputResource((Resource)configPredicate), values);
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("config", 1);
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults().stream().findFirst();
    }

    @Override
    public Optional<Value> readOntologyId(IRI modelId) {
        this.updateStatistics("readOntologyId");
        String query = "PREFIX dash: <http://schema.semantic-web.at/ppt/>\nSELECT ?ontologyIri " + this.createFromClause() + " WHERE {   ?model " + Rdf4jModelQueryDaoImpl.outputIriList(List.of(SomlOntology.ONTOLOGY_IRI, RDFS.ISDEFINEDBY), "|") + " ?ontologyIri .} VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputResource((Resource)modelId) + "}";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("ontologyIri");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults().stream().findFirst();
    }

    @Override
    public SinglePropertyResultHandler findAlternativeConfigurationsOf(@Nullable IRI modelId, Set<IRI> iris) {
        this.updateStatistics("findAlternativeConfigurationsOf");
        String sparql = modelId != null ? "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT distinct ?config " + this.createFromClause() + "WHERE {\n   { ?predicate owl:sameAs|so:sameAs|^so:sameAs|^owl:sameAs ?config .\n    ?predicate rdfs:isDefinedBy " + Rdf4jModelQueryDaoImpl.outputResource((Resource)modelId) + " .\n } UNION {\n GRAPH " + Rdf4jModelQueryDaoImpl.outputResource((Resource)modelId) + "  { ?predicate owl:sameAs|so:sameAs|^so:sameAs|^owl:sameAs ?config .\n } }} VALUES ?predicate { " + Rdf4jModelQueryDaoImpl.outputIriList(iris, " ") + " }" : "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nSELECT distinct ?config " + this.createFromClause() + "WHERE {\n    ?predicate owl:sameAs|so:sameAs|^so:sameAs|^owl:sameAs ?config .\n} VALUES ?predicate { " + Rdf4jModelQueryDaoImpl.outputIriList(iris, " ") + " }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("config");
        this.connection.executeSelect((QueryRequest)QueryRequest.newSimpleQuery((String)sparql).disableRequestLogging(), (TupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public boolean isConfigurationEnabled(@Nullable IRI modelId, IRI configPredicate) {
        this.updateStatistics("isConfigurationEnabled");
        String subject = "?_";
        Object filter = " FILTER(isBLANK(" + subject + ")) .";
        if (modelId != null) {
            subject = Rdf4jModelQueryDaoImpl.outputResource((Resource)modelId);
            filter = "";
        }
        String query = String.format("ASK %s { %s %s true .%s }", this.createFromClause(), subject, Rdf4jModelQueryDaoImpl.outputResource((Resource)configPredicate), filter);
        AskRequest request = (AskRequest)AskRequest.newSimpleQuery((String)query).disableRequestLogging();
        return this.connection.executeAsk(request).isYes();
    }

    @Override
    public SinglePropertyResultHandler getCustomDataTypes() {
        this.updateStatistics("getCustomDataTypes");
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX schema: <http://schema.org/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT distinct ?type " + this.createFromClause() + " WHERE {\n    ?type rdfs:subClassOf*/rdf:type schema:DataType .\n} ";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("type");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public SinglePropertyResultHandler getGraphQlName(IRI graphqlModelId) {
        this.updateStatistics("getGraphQlName");
        String query = String.format("SELECT distinct ?name %s WHERE { ?iri ?predicate ?name . } LIMIT 1 VALUES (?iri ?predicate) { %s } ", this.createFromClause(), this.outputConfigValuesPair((Resource)graphqlModelId, this.config.getNames()));
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("name", 1);
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @NotNull
    private String outputConfigValuesPair(Resource resource, Set<IRI> iris) {
        return iris.stream().map(name -> String.format("(%s %s) ", Rdf4jModelQueryDaoImpl.outputResource(resource), Rdf4jModelQueryDaoImpl.outputResource((Resource)name))).collect(Collectors.joining());
    }

    @Override
    public SinglePropertyResultHandler getPublicReferencedOntologies(IRI graphqlModelId) {
        this.updateStatistics("getPublicReferencedOntologies");
        String query = "PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT distinct ?ontology  WHERE {\n    ?iri (graphql:publicClass|graphql:publicShape)/rdfs:isDefinedBy ?ontology .\n} VALUES ?iri { " + Rdf4jModelQueryDaoImpl.outputResource((Resource)graphqlModelId) + " }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("ontology");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public SinglePropertyResultHandler getImportedOntologies(Set<IRI> primaryOntologies) {
        this.updateStatistics("getImportedOntologies");
        String query = String.format("PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nselect distinct ?ontology %s where {\n    ?iri owl:imports+ ?ontology .\n    ?ontology a ?type .\n    FILTER(?type in (owl:Ontology, graphql:Schema, sh:Schema)) . \n} VALUES ?iri {%s}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(primaryOntologies, " "));
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("ontology");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public Stream<Namespace> getSystemNamespaces() {
        this.updateStatistics("getSystemNamespaces");
        return this.connection.getNamespaces().stream();
    }

    @Override
    public List<Namespace> getNamespaces(Ontology ontology) {
        this.updateStatistics("getNamespaces");
        String iris = Stream.concat(Stream.of(ontology.getGraphqlModelId(), ontology.getOntologyId()), ontology.getOntologyImports().stream()).filter(Objects::nonNull).distinct().map(ModelQueryDao::outputResource).collect(Collectors.joining(" "));
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT DISTINCT ?prefix ?namespace " + this.createFromClause() + "WHERE { ?ontology sh:declare [ sh:prefix ?prefix ; sh:namespace ?namespace ] .\n} VALUES ?ontology { " + iris + " }";
        LinkedList<Namespace> list = new LinkedList<Namespace>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(bindings -> list.add((Namespace)new SimpleNamespace(bindings.getValue("prefix").stringValue(), bindings.getValue("namespace").stringValue())));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return list;
    }

    @Override
    public GraphQlSchema loadGraphQlModel(IRI modelId) {
        this.updateStatistics("loadGraphQlModel");
        String findRelatedModels = "PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\n" + String.format("SELECT DISTINCT ?relatedModel %s WHERE {\n  ?schema graphql:publicNamespace/sh:namespace ?publicNamespace .\n  ?relatedModel graphql:defaultPrefix/sh:namespace ?publicNamespace .\n} VALUES ?schema { %s }\n", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputResource((Resource)modelId));
        SinglePropertyResultHandler resultHandler = new SinglePropertyResultHandler("relatedModel");
        this.executeQuery(findRelatedModels, (AbstractTupleQueryResultHandler)resultHandler);
        Set relatedModels = resultHandler.getAsDistinctIri();
        relatedModels.add(modelId);
        String query = String.format("PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT DISTINCT ?publicClass ?protectedClass ?publicShape ?protectedShape ?privateShape ?publicNamespace ?defaultPrefix ?defaultNamespace ?privateProperty ?protectedProperty \n%s WHERE {\n    {\n        { ?schema graphql:publicClass ?publicClass.\n        } UNION { ?schema graphql:publicClass ?type.\n            ?publicClass rdfs:subClassOf|sh:node ?type .}\n    } UNION { { ?schema graphql:protectedClass ?protectedClass.\n        } UNION { ?schema graphql:protectedClass ?type.\n            ?protectedClass rdfs:subClassOf|sh:node ?type . }\n    } UNION {\n        {\n            ?schema graphql:publicShape ?publicShape .\n        } UNION {\n            ?schema graphql:publicShape/(rdfs:subClassOf|sh:node)?/(sh:property/(sh:class|sh:node)) ?publicShape .\n            FILTER(isIRI(?publicShape)) .\n        } UNION {\n            ?schema graphql:publicShape/(rdfs:subClassOf|sh:node)?/sh:property/sh:or/rdf:rest*/rdf:first/(sh:class|sh:node) ?publicShape .\n            FILTER(isIRI(?publicShape)) .\n        }    } UNION {\n        {\n            ?schema graphql:protectedShape ?protectedShape .\n        } UNION {\n            ?schema graphql:protectedShape/(rdfs:subClassOf|sh:node)?/(sh:property/(sh:class|sh:node)) ?protectedShape.\n            FILTER(isIRI(?protectedShape)) .\n        }  UNION {\n            ?schema graphql:protectedShape/(rdfs:subClassOf|sh:node)?/sh:property/sh:or/rdf:rest*/rdf:first/(sh:class|sh:node) ?protectedShape .\n            FILTER(isIRI(?protectedShape)) .\n        }    } UNION { ?schema graphql:privateShape ?privateShape .\n    } UNION { ?schema graphql:publicNamespace/sh:namespace ?publicNamespace .\n    } UNION { ?schema %s ?privateProperty .\n    } UNION { ?schema %s ?protectedProperty .\n    } UNION { ?schema graphql:defaultPrefix         [ sh:prefix ?defaultPrefix ; sh:namespace ?defaultNamespace ; ] .\n    } UNION {         ?schema graphql:defaultPrefix ?defaultPrefix .         FILTER(isLiteral(?defaultPrefix)) . }\n} VALUES ?schema { %s }", this.createFromClause(), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getPrivatePropertiesConfig()), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getProtectedPropertiesConfig()), Rdf4jModelQueryDaoImpl.outputIriList(relatedModels, " "));
        GraphQlSchema schema = new GraphQlSchema();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.populateGraphqlSchema(schema));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        schema.subtractPrivateShapes();
        return schema;
    }

    private Consumer<BindingSet> populateGraphqlSchema(GraphQlSchema schema) {
        return binding -> {
            Utils.readIriValue("publicClass", binding, schema.getPublicClasses()::add);
            Utils.readIriValue("protectedClass", binding, schema.getProtectedClasses()::add);
            Utils.readIriValue("publicShape", binding, schema.getPublicShapes()::add);
            Utils.readIriValue("protectedShape", binding, schema.getProtectedShapes()::add);
            Utils.readIriValue("privateShape", binding, schema.getPrivateShapes()::add);
            Utils.readIriValue("publicNamespace", binding, schema.getPublicNamespaces()::add);
            Utils.readIriValue("privateProperty", binding, schema.getPrivateProperties()::add);
            Utils.readIriValue("protectedProperty", binding, schema.getProtectedProperties()::add);
            Utils.readIriValue("defaultNamespace", binding, schema::setDefaultNamespace);
            Value value = binding.getValue("defaultPrefix");
            if (value != null && (schema.getDefaultPrefix() == null || schema.getDefaultNamespace() == null)) {
                schema.setDefaultPrefix(value);
            }
        };
    }

    @Override
    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes() {
        String query = String.format("PREFIX graphql: <http://datashapes.org/graphql#>\nselect * %s where {\n    ?model a graphql:Schema .\n    optional {\n      { ?model %s ?name . }\n      union { ?model %s ?label . }\n      union { ?model %s ?description . }\n    }\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getNames(), "|"), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getLabelProps(), "|"), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getDescriptionProps(), "|"));
        LinkedHashMap<IRI, GraphQlSchemaShape> shapes = new LinkedHashMap<IRI, GraphQlSchemaShape>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.populateGraphqlSchemaShapes(shapes));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return shapes.values();
    }

    private Consumer<BindingSet> populateGraphqlSchemaShapes(Map<IRI, GraphQlSchemaShape> shapes) {
        return binding -> {
            IRI model = Utils.readIriValue("model", binding);
            GraphQlSchemaShape graphqlSchemaShape = shapes.computeIfAbsent(model, k -> new GraphQlSchemaShape());
            Utils.readIriValue("model", binding, graphqlSchemaShape::setId);
            if (graphqlSchemaShape.getName() == null) {
                Utils.readLiteralValue("name", binding, graphqlSchemaShape::setName);
            }
            if (graphqlSchemaShape.getLabel() == null) {
                Utils.readLiteralValue("label", binding, graphqlSchemaShape::setLabel);
            }
            if (graphqlSchemaShape.getDescription() == null) {
                Utils.readLiteralValue("description", binding, graphqlSchemaShape::setDescription);
            }
        };
    }

    @Override
    public SinglePropertyResultHandler findAllExplicitClasses() {
        this.updateStatistics("findAllExplicitClasses");
        String query = String.format("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX dash: <http://datashapes.org/dash#>\nSELECT ?instance %s  WHERE {    { ?instance rdf:type/rdfs:subClassOf* ?type . }      UNION    { ?_ sh:class|sh:targetClass|dash:applicableToClass ?instance . }  } VALUES ?type { %s }", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getClasses(), " "));
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("instance");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public Set<Resource> getDeactivatedShapes() {
        return this.connection.stream(null, SHACL.DEACTIVATED, (Value)BaseDataAccess.TRUE, (Resource[])this.contexts.toArray(Resource[]::new)).map(Statement::getSubject).collect(Collectors.toSet());
    }

    @Override
    public SinglePropertyResultHandler findReferencedShaclNodes(Set<IRI> iris) {
        this.updateStatistics("findReferencedShaclNodes");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX dash: <http://datashapes.org/dash#>\nSELECT DISTINCT ?node " + this.createFromClause() + " WHERE {\n   { ?shape sh:node+ ?node .\n }    UNION { ?node (sh:node+|sh:targetClass|dash:applicableToClass) ?shape .\n }} VALUES ?shape {" + Rdf4jModelQueryDaoImpl.outputIriList(iris, " ") + "}";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("node");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public SinglePropertyResultHandler findReferencedShaclTypes(Set<IRI> iris) {
        this.updateStatistics("findReferencedShaclTypes");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX dash: <http://datashapes.org/dash#>\nSELECT DISTINCT ?node " + this.createFromClause() + " WHERE {\n    ?shape sh:node*/(sh:targetClass|dash:applicableToClass) ?node .\n } VALUES ?shape {" + Rdf4jModelQueryDaoImpl.outputIriList(iris, " ") + "}";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("node");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public Map<Value, List<BindingSet>> getClassMetadata() {
        this.updateStatistics("getClassMetadata");
        String query = String.format("PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX vann: <http://purl.org/vocab/vann/>\nPREFIX dash: <http://datashapes.org/dash#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nPREFIX void: <http://rdfs.org/ns/void#>\nselect ?type ?uriTemplate ?preferredNamespacePrefix ?preferredNamespaceUri ?isShacl ?target ?parents ?union ?typeName ?federatedService ?serviceName %s where {\n   {\n      VALUES ?typeOf { %s } \n      ?type rdf:type/rdfs:subClassOf* ?typeOf .\n    } UNION {\n      ?_ sh:class|sh:targetClass|dash:applicableToClass ?type .\n    }\n    {\n      {        OPTIONAL { ?type so:sparqlFederatedService ?federatedService . }.\n      } UNION {        OPTIONAL { ?type so:sparqlFederatedService [                       void:sparqlEndpoint|so:sparqlEndpoint ?federatedService ;                       graphql:name|so:name|so:endpointName ?serviceName ; ] .         }.\n      }      OPTIONAL { ?type so:name ?typeName}.\n      OPTIONAL { ?type graphql:uriTemplate|so:pattern ?uriTemplate . }\n     OPTIONAL { ?type vann:preferredNamespacePrefix ?preferredNamespacePrefix .}      OPTIONAL { ?type vann:preferredNamespaceUri ?preferredNamespaceUri . }\n      OPTIONAL { ?type a sh:NodeShape . BIND(true as ?isShacl). } \n    } UNION {\n      ?type sh:targetClass|dash:applicableToClass ?target .\n    } UNION {\n      ?type a sh:NodeShape .\n      ?type sh:targetClass|dash:applicableToClass|(sh:node/(sh:targetClass|dash:applicableToClass))+ ?target .\n       ?target rdfs:subClassOf+ ?parents .\n     } UNION {\n      ?type a ?typeValue .\n      FILTER(?typeValue = owl:Class || ?typeValue = rdfs:Class) .\n        ?type (rdfs:subClassOf|sh:node)+ ?parents . \n    } UNION {         ?type a sh:NodeShape .\n        ?type sh:or/rdf:rest*/rdf:first ?union.     }\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getClasses(), " "));
        LinkedHashMap<Value, List<BindingSet>> map = new LinkedHashMap<Value, List<BindingSet>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(bindings -> {
            Value type = bindings.getValue("type");
            map.computeIfAbsent(type, key -> new LinkedList()).add(bindings);
        });
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return map;
    }

    @Override
    public List<BindingSet> getClassMetadata(Resource id) {
        this.updateStatistics("getClassMetadataById");
        String query = String.format("PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX vann: <http://purl.org/vocab/vann/>\nPREFIX dash: <http://datashapes.org/dash#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nselect ?type ?uriTemplate ?preferredNamespacePrefix ?preferredNamespaceUri ?isShacl ?target ?parents ?union ?federatedService ?serviceName %s where {\n    {\n      {        OPTIONAL { ?type so:sparqlFederatedService ?federatedService . }.\n      } UNION {        OPTIONAL { ?type so:sparqlFederatedService [                       void:sparqlEndpoint|so:sparqlEndpoint ?federatedService ;                       graphql:name|so:name|so:endpointName ?serviceName ; ] .         }.\n      }      OPTIONAL { ?type so:name ?typeName}.\n      OPTIONAL { ?type graphql:uriTemplate|so:pattern ?uriTemplate . }\n     OPTIONAL { ?type vann:preferredNamespacePrefix ?preferredNamespacePrefix .}      OPTIONAL { ?type vann:preferredNamespaceUri ?preferredNamespaceUri . }\n      OPTIONAL { ?type a sh:NodeShape . BIND(true as ?isShacl). } \n    } UNION {\n      ?type sh:targetClass|dash:applicableToClass ?target .\n    } UNION {\n      ?type a sh:NodeShape .\n      ?type sh:targetClass|dash:applicableToClass|(sh:node/(sh:targetClass|dash:applicableToClass))+ ?target .\n       ?target rdfs:subClassOf+ ?parents .\n     } UNION {\n      ?type a ?typeValue .\n      FILTER(?typeValue = owl:Class || ?typeValue = rdfs:Class) .\n        ?type (rdfs:subClassOf|sh:node)+ ?parents . \n    } UNION {         ?type a sh:NodeShape .\n        ?type sh:or/rdf:rest*/rdf:first ?union. }\n}", this.createFromClause());
        LinkedList<BindingSet> list = new LinkedList<BindingSet>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(list::add);
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return list;
    }

    @Override
    public Consumer<BindingSet> populateTypeMetadata(Classes.Class target, Ontology ontology) {
        return bindings -> {
            Utils.readStringValue("uriTemplate", bindings, target::setPattern);
            Utils.readValue("federatedService", bindings, target::setSparqlFederatedService);
            Utils.readStringValue("serviceName", bindings, target::setServiceName);
            this.readPreferredNamespaceAndPrefix(target, (BindingSet)bindings);
            Utils.readBooleanValue("isShacl", bindings, target::setShaclShape);
            Utils.readIriValue("target", bindings, target::setShaclTarget);
            Value parent = bindings.getValue("parents");
            if (parent instanceof IRI) {
                IRI parentIri = (IRI)parent;
                if (this.config.isValidClass(parent) && ontology.isTypeAllowed(parent)) {
                    target.addParentIri(parentIri);
                }
            }
            Utils.readIriValue("union", bindings, target::addUnionMember);
            Utils.readValue("typeName", bindings, target::setTypeName);
        };
    }

    private void readPreferredNamespaceAndPrefix(Classes.Class target, BindingSet bindings) {
        Value namespaceUri;
        Value namespacePrefix = bindings.getValue("preferredNamespacePrefix");
        if (namespacePrefix != null) {
            target.setPrefix(namespacePrefix.stringValue());
        }
        if (target.getPrefix() == null && (namespaceUri = bindings.getValue("preferredNamespaceUri")) != null) {
            this.namespaces.getNamespace(namespaceUri.stringValue()).ifPresent(target::setPrefix);
        }
        if ((namespaceUri = bindings.getValue("preferredNamespaceUri")) != null) {
            target.setPreferredNamespace(namespaceUri.stringValue());
        }
    }

    @Override
    public Map<Value, Boolean> getInterfaceTypes() {
        this.updateStatistics("getInterfaceTypes");
        String query = String.format("PREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?modelId ?value %s WHERE {   { ?modelId %s ?value . }  UNION { ?shape sh:targetClass ?modelId . ?shape (%2$s) ?value . } . }", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getIsInterface(), "|"));
        MapPropertyResultHandler handler = new MapPropertyResultHandler("modelId", "value");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Literal)entry.getValue()).booleanValue()));
    }

    @Override
    public Map<Value, List<Value>> getLabels() {
        this.updateStatistics("getLabels");
        String query = String.format("SELECT ?type ?label %s WHERE {\n    ?type %s ?label .\n    FILTER(!LANGMATCHES(LANG(?label), \"*\") || LANGMATCHES(LANG(?label), \"en\")) .\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getLabelProps(), "|"));
        OneToManyPropertyResultHandler handler = new OneToManyPropertyResultHandler("type", "label");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, Set<Value>> getDescriptions() {
        this.updateStatistics("getDescriptions");
        String query = String.format("SELECT ?type ?label %s WHERE {\n    ?type %s ?label .\n    filter(!LANGMATCHES(LANG(?label), \"*\") || LANGMATCHES(LANG(?label), \"en\")) .\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getDescriptionProps(), "|"));
        OneToManyDistinctPropertyResultHandler handler = new OneToManyDistinctPropertyResultHandler("type", "label");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, List<Value>> gqlTypeNames() {
        this.updateStatistics("gqlTypeName");
        String query = String.format("PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX dash: <http://datashapes.org/dash#>\nSELECT ?class ?name %s WHERE {\n    VALUES ?type { %s }\n    ?class rdf:type/rdfs:subClassOf* ?type.\n    {\n        ?shape sh:targetClass|dash:applicableToClass ?class .\n        ?shape %3$s ?name .\n    } UNION {\n        ?class %3$s ?name .\n    } UNION {\n        ?class (sh:targetClass|dash:applicableToClass)/(%3$s) ?name .\n    }\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getClasses(), " "), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getNames()));
        OneToManyPropertyResultHandler handler = new OneToManyPropertyResultHandler("class", "name");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, Set<Value>> gqlPropertyNames() {
        this.updateStatistics("gqlPropertyNames");
        String query = String.format("PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT ?property ?name %s WHERE {\n    {\n        VALUES ?propType { %s }         ?property a ?propType .\n        OPTIONAL {\n            ?property %3$s ?name .\n        }\n    } UNION {\n        ?_ sh:property ?property .\n        {\n            ?property %3$s ?name .\n        } UNION {\n            ?property sh:path/(%3$s) ?name .\n        }\n    }\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getPropertyClasses(), " "), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getNames()));
        OneToManyDistinctPropertyResultHandler handler = new OneToManyDistinctPropertyResultHandler("property", "name");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, Set<Value>> getInverseOf() {
        this.updateStatistics("getInverseOf");
        String query = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX schema: <http://schema.org/>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?property ?inverse " + this.createFromClause() + " WHERE {\n    { ?property owl:inverseOf|schema:inverseOf|so:inverseOf|^owl:inverseOf|^schema:inverseOf|^so:inverseOf ?inverse .\n }     UNION \n    { ?property sh:path/(owl:inverseOf|schema:inverseOf|so:inverseOf|^owl:inverseOf|^schema:inverseOf|^so:inverseOf) ?inverse .\n } }";
        OneToManyDistinctPropertyResultHandler handler = new OneToManyDistinctPropertyResultHandler("property", "inverse");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public SinglePropertyResultHandler getExplicitProperties() {
        this.updateStatistics("findAllExplicitProperties");
        String query = String.format("PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT DISTINCT ?property %sWHERE {\n    {\n        VALUES ?propType { %s }         ?property a ?propType .\n    } UNION {\n        ?_ sh:property ?property .\n    }\n    OPTIONAL {\n        ?property sh:deactivated true.\n        BIND(true as ?deactivated).\n    }\n    FILTER (!BOUND(?deactivated) && ?property not in (%s)).\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getPropertyClasses(), " "), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getIgnoredProperties(), ", "));
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("property");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler;
    }

    @Override
    public Set<Resource> getShaclProperties() {
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?property " + this.createFromClause() + " WHERE {   { ?_ sh:property ?property . }   UNION { ?property a sh:PropertyShape . } }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("property");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return (Set)handler.getResultsAs(Resource.class, LinkedHashSet::new);
    }

    @Override
    public Set<Value> getTypes(Resource key) {
        this.updateStatistics("getTypes");
        return this.connection.stream(key, RDF.TYPE, null, (Resource[])this.contexts.toArray(Resource[]::new)).map(Statement::getObject).collect(Collectors.toSet());
    }

    @Override
    public Map<Value, Set<Value>> getPropertyTypes() {
        this.updateStatistics("getPropertyTypes");
        String query = String.format("PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT ?property ?type %s WHERE {\n    {\n        VALUES ?propType { %s } \n        ?property a ?propType .\n        ?property a ?type . \n    } UNION {\n        ?_ sh:property ?property .\n         { ?property a ?type . }         UNION { ?property sh:path/rdf:type ?type . }    }\n    FILTER (?property not in (%s)).\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getPropertyClasses(), " "), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getIgnoredProperties(), ", "));
        OneToManyDistinctPropertyResultHandler handler = new OneToManyDistinctPropertyResultHandler("property", "type");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, List<BindingSet>> readShaclPropertiesMetadata() {
        this.updateStatistics("readShaclPropertiesMetadata");
        String query = String.format("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX dash: <http://datashapes.org/dash#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nSELECT ?property ?label ?description ?maxCount ?minCount ?minLength ?maxLength ?minExclusive ?minInclusive ?maxExclusive ?maxInclusive ?pattern ?flags ?equals ?nodeKind ?order ?datatype ?class ?node ?in ?hasValueIn ?isTypeName ?defaultValue ?languageIn ?uniqueLang ?fetch ?dateOrDateTime ?stringOrLangString ?or\n%sWHERE {\n    {\n        VALUES ?propType { %s }         ?property a ?propType .\n    } UNION {\n        ?_ sh:property ?property .\n    }\n    OPTIONAL {\n        ?property sh:deactivated true.\n        BIND(true as ?deactivated).\n    }\n    FILTER (!BOUND(?deactivated) && ?property not in (%s)).\n    {\n        OPTIONAL { ?property sh:name ?label .\n            filter(!LANGMATCHES(LANG(?label), \"*\") || LANGMATCHES(LANG(?label), \"en\")) . }   \n        OPTIONAL { ?property sh:description ?description .\n            filter(!LANGMATCHES(LANG(?description), \"*\") || LANGMATCHES(LANG(?description), \"en\")) . }\n        OPTIONAL { ?property sh:maxCount ?maxCount . }\n        OPTIONAL { ?property sh:minCount ?minCount . }\n        OPTIONAL { ?property sh:minLength ?minLength . }\n        OPTIONAL { ?property sh:maxLength ?maxLength . }\n        OPTIONAL { ?property sh:minExclusive ?minExclusive . }\n        OPTIONAL { ?property sh:minInclusive ?minInclusive . }\n        OPTIONAL { ?property sh:maxExclusive ?maxExclusive . }\n        OPTIONAL { ?property sh:maxInclusive ?maxInclusive . }\n        OPTIONAL { ?property sh:pattern ?pattern . }\n        OPTIONAL { ?property sh:flags ?flags . }\n        OPTIONAL { ?property sh:equals ?equals . }\n        OPTIONAL { ?property sh:order ?order . }\n        OPTIONAL { ?property sh:nodeKind ?nodeKind . }\n        OPTIONAL { ?property sh:datatype ?datatype . }\n        OPTIONAL { ?property sh:class ?class . }\n        OPTIONAL { ?property sh:node ?node . }\n        OPTIONAL { ?property so:isTypeName ?isTypeName . }\n        OPTIONAL { ?property sh:defaultValue|so:gen ?defaultValue . }\n    } \n    UNION {\n        ?property sh:in/rdf:rest*/rdf:first ?in .\n    } UNION {\n        ?property dash:hasValueIn/rdf:rest*/rdf:first ?hasValueIn .\n    } UNION {\n        OPTIONAL { ?property sh:languageIn/rdf:rest*/rdf:first ?languageIn . }\n        OPTIONAL { ?property sh:uniqueLang ?uniqueLang . }\n        OPTIONAL { ?property %s ?fetch . }\n    } UNION {\n        {\n            OPTIONAL {\n                ?property sh:or dash:DateOrDateTime .\n                bind(true as ?dateOrDateTime) .\n            }\n            OPTIONAL {\n                ?property sh:or dash:StringOrLangString .\n                bind(true as ?stringOrLangString) .\n            }\n        } UNION {\n            ?property sh:or/rdf:rest*/rdf:first ?or.\n            { ?or sh:datatype ?datatype . }\n             UNION { ?or sh:class ?class . }\n             UNION { ?or sh:node ?node . }\n        } UNION {\n            ?property sh:and/rdf:rest*/rdf:first ?and.\n            { ?and sh:datatype ?datatype . }\n             UNION { ?and sh:class ?class . }\n             UNION { ?and sh:node ?node . }\n        }\n    }\n}", this.createFromClause(), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getPropertyClasses(), " "), Rdf4jModelQueryDaoImpl.outputIriList(this.config.getIgnoredProperties(), ", "), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getLanguage()));
        LinkedHashMap<Value, List<BindingSet>> map = new LinkedHashMap<Value, List<BindingSet>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(bindings -> {
            Value property = bindings.getValue("property");
            map.computeIfAbsent(property, key -> new LinkedList()).add(bindings);
        });
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return map;
    }

    @Override
    public void readShaclPropertyPath(Properties.Property property, Resource shaclId, Value path) {
        new QueryShaclPathResolver(this.connection, (Resource[])this.contexts.toArray(Resource[]::new), this.namespaces).resolve(property, shaclId, path);
    }

    @Override
    public List<PropertyInverseInfo> readShaclInverseRelations() {
        this.updateStatistics("readShaclInverseRelations");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\n select distinct ?property ?propShape ?domainClass ?domainShape\n                 ?inverseProperty ?inversePropShape ?rangeClass ?rangeShape\n                 where {\n     ?property owl:inverseOf|^owl:inverseOf ?inverseProperty .\n     ?propShape sh:path ?property .\n     {\n         # ?domainShape === ?domainClass\n         # ?domainShape a ?domainType .\n         # FILTER(?domainType in (sh:NodeShape, owl:Class, rdfs:Class)).\n         ?domainShape sh:property ?propShape .\n         ?propShape sh:class|sh:node ?rangeShape .\n         optional {\n             ?rangeShape sh:property ?inversePropShape .\n             ?inversePropShape sh:path ?inverseProperty .\n             ?inversePropShape sh:class|sh:node ?domainShape .\n         }\n     } union {\n         ?domainShape sh:property ?propShape .\n         ?propShape sh:class ?rangeClass .\n         ?domainShape sh:targetClass ?domainClass .\n         optional {\n             ?rangeShape sh:targetClass ?rangeClass .\n             ?rangeShape sh:property ?inversePropShape .\n             ?inversePropShape sh:path ?inverseProperty .\n             ?inversePropShape sh:class ?domainClass .\n         }\n     } union {\n         ?propShape sh:node ?rangeShape .\n         ?domainShape sh:targetClass ?domainClass .\n         optional {\n             optional { ?rangeShape sh:targetClass ?rangeClass } .\n             ?rangeShape sh:property ?inversePropShape .\n             ?inversePropShape sh:path ?inverseProperty .\n             ?inversePropShape sh:class ?domainClass .\n         }\n     } union {\n         ?propShape sh:node ?rangeShape .\n         ?domainShape sh:targetClass ?domainClass .\n         optional {\n             ?rangeShape sh:targetClass ?rangeClass .\n             ?rangeShape sh:property ?inversePropShape .\n             ?inversePropShape sh:path ?inverseProperty .\n             ?inversePropShape sh:node ?domainShape .\n         }\n     } union {\n         ?propShape sh:class ?rangeClass .\n         ?domainShape sh:targetClass ?domainClass .\n         optional {\n             ?rangeShape sh:targetClass ?rangeClass .\n             ?rangeShape sh:property ?inversePropShape .\n             ?inversePropShape sh:path ?inverseProperty .\n             ?inversePropShape sh:node ?domainShape .\n         }\n     }\n     FILTER(BOUND(?inversePropShape)).\n }\n";
        ArrayList<PropertyInverseInfo> inverseInfos = new ArrayList<PropertyInverseInfo>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.readPropertyInverseInfo(inverseInfos));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return inverseInfos;
    }

    private Consumer<BindingSet> readPropertyInverseInfo(List<PropertyInverseInfo> infoList) {
        return bindings -> {
            PropertyInverseInfo propInfo = new PropertyInverseInfo();
            Utils.readIriValue("property", bindings, propInfo::setPredicate);
            Utils.readResourceValue("propShape", bindings, propInfo::setPropertyShape);
            Utils.readResourceValue("domainShape", bindings, propInfo::setNodeShape);
            Utils.readIriValue("domainClass", bindings, propInfo::setNodeTargetClass);
            PropertyInverseInfo inverseInfo = new PropertyInverseInfo();
            Utils.readIriValue("inverseProperty", bindings, inverseInfo::setPredicate);
            Utils.readResourceValue("inversePropShape", bindings, inverseInfo::setPropertyShape);
            Utils.readResourceValue("rangeShape", bindings, inverseInfo::setNodeShape);
            Utils.readIriValue("rangeClass", bindings, inverseInfo::setNodeTargetClass);
            propInfo.setInverse(inverseInfo);
            inverseInfo.setInverse(propInfo);
            infoList.add(propInfo);
            infoList.add(inverseInfo);
        };
    }

    @Override
    public Map<Value, Value> getShaclPropertyPaths() {
        this.updateStatistics("getShaclPropertyPaths");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nSELECT ?property ?path " + this.createFromClause() + " WHERE {\n    ?shape sh:property ?property .\n    ?property sh:path|so:sparqlTemplate ?path\n}";
        MapPropertyResultHandler handler = new MapPropertyResultHandler("property", "path");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Consumer<BindingSet> populatePropertyShaclMetadata(Properties.Property property, Ontology ontology, ModelQueryDao.LangConfig langConfig, ModelQueryDao.PropTypeConfig typeConfig) {
        Consumer<BindingSet> rangeResolver;
        if (ontology.isProtectedProperty(property)) {
            property.setKind("object");
            property.setRange("iri");
            rangeResolver = bindings -> {};
        } else {
            rangeResolver = this.readPropertyRange(property, typeConfig);
        }
        return bindings -> {
            Utils.readStringValue("label", bindings, property::setLabel);
            Utils.readStringValue("description", bindings, property::setDescription);
            Utils.readIntegerValue("maxCount", bindings, property::overrideMax);
            Utils.readIntegerValue("minCount", bindings, property::overrideMin);
            Utils.readIntegerValue("minLength", bindings, property::setMinLength);
            Utils.readIntegerValue("maxLength", bindings, property::setMaxLength);
            Utils.readStringValue("minExclusive", bindings, property::setMinExclusive);
            Utils.readStringValue("maxExclusive", bindings, property::setMaxExclusive);
            Utils.readStringValue("minInclusive", bindings, property::setMinInclusive);
            Utils.readStringValue("maxInclusive", bindings, property::setMaxInclusive);
            Utils.readStringValue("defaultValue", bindings, property::setDefaultValue);
            Utils.readStringValue("in", bindings, property::addValuesIn);
            Utils.readStringValue("hasValueIn", bindings, value -> {
                property.addValuesIn(value);
                property.setValuesListExclusive(Boolean.TRUE);
            });
            Utils.readStringValue("pattern", bindings, property::setPattern);
            Utils.readStringValue("flags", bindings, property::setFlags);
            Utils.readStringValue("equals", bindings, equals -> property.setEquals(this.namespaces.shortIri((String)equals)));
            Utils.readStringValue("languageIn", bindings, langConfig::addLanguage);
            Utils.readBooleanValue("uniqueLang", bindings, langConfig::setUnique);
            Utils.readStringValue("fetch", bindings, langConfig::setFetch);
            Utils.readDoubleValue("order", bindings, property::setOrder);
            Utils.readBooleanValue("isTypeName", bindings, property::setIsTypeName);
            rangeResolver.accept((BindingSet)bindings);
        };
    }

    @NotNull
    private Consumer<BindingSet> readPropertyRange(Properties.Property property, ModelQueryDao.PropTypeConfig typeConfig) {
        return bindings -> {
            Value or;
            Value stringOrLangString;
            Value kindValue = bindings.getValue("nodeKind");
            Rdf4jModelQueryDaoImpl.setNodeKindValue(property, kindValue);
            Value dateOrDateTime = bindings.getValue("dateOrDateTime");
            if (dateOrDateTime != null) {
                property.setKind("literal");
                property.setRange("dateOrDateTime");
            }
            if ((stringOrLangString = bindings.getValue("stringOrLangString")) != null) {
                property.setKind("literal");
                property.setRange("stringOrLangString");
            }
            if ((or = bindings.getValue("or")) != null) {
                Utils.readIriValue("datatype", bindings, typeConfig.orDef::addDataType);
                Utils.readIriValue("class", bindings, typeConfig.orDef::addClass);
                Utils.readResourceValue("node", bindings, typeConfig.orDef::addNode);
            } else {
                Value and = bindings.getValue("and");
                if (and != null) {
                    Utils.readIriValue("datatype", bindings, typeConfig.andDef::addDataType);
                    Utils.readIriValue("class", bindings, typeConfig.andDef::addClass);
                    Utils.readResourceValue("node", bindings, typeConfig.andDef::addNode);
                } else {
                    Utils.readIriValue("datatype", bindings, typeConfig::setDatatype);
                    Utils.readIriValue("class", bindings, typeConfig::setClazz);
                    Utils.readResourceValue("node", bindings, typeConfig::setNode);
                }
            }
        };
    }

    private static void setNodeKindValue(Properties.Property property, Value kindValue) {
        if (kindValue != null) {
            if (SHACL.IRI.equals((Object)kindValue) || SHACL.BLANK_NODE_OR_IRI.equals((Object)kindValue) || SHACL.BLANK_NODE.equals((Object)kindValue)) {
                property.setKind("object");
                property.setRange("iri");
            } else if (SHACL.LITERAL.equals((Object)kindValue) || SHACL.BLANK_NODE_OR_LITERAL.equals((Object)kindValue)) {
                property.setKind("literal");
            }
        }
    }

    @Override
    public Map<String, Object> readOntologyMetadata(IRI ontologyIri) {
        this.updateStatistics("readOntologyMetadata");
        String query = String.format("SELECT ?ontology ?label ?creator ?version ?created\n?updated ?parents ?union %s WHERE {\n    { ?ontology %s ?label . }\n     UNION { ?ontology %s ?creator . }\n     UNION { ?ontology %s ?version . }\n     UNION { ?ontology %s ?created . }\n     UNION { ?ontology %s ?updated . }\n} VALUES ?ontology { %s }", this.createFromClause(), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getLabelProps()), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getCreator()), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getVersion()), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getCreated()), Rdf4jModelQueryDaoImpl.toPredicateAlternative(this.config.getModified()), Rdf4jModelQueryDaoImpl.outputResource((Resource)ontologyIri));
        ModelQueryDao.OntologyMetadata metadata = new ModelQueryDao.OntologyMetadata();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(metadata.createHandler());
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return metadata.formatMetadata();
    }

    private static String toPredicateAlternative(Collection<IRI> iris) {
        return Rdf4jModelQueryDaoImpl.outputIriList(iris, "|");
    }

    @Override
    public Set<Resource> getDataProperties() {
        this.updateStatistics("getDataProperties");
        String dataRangeTypes = String.format("} UNION {?_ sh:property ?prop. ?prop sh:nodeKind ?kind .   FILTER(?kind in (sh:Literal, sh:BlankNodeOrLiteral)) . }  UNION {?_ sh:property ?prop. ?prop sh:datatype ?_ . }  UNION {?_ sh:property ?prop. ?prop sh:class ?type.    FILTER(?type in (%s)) . }", Utils.createTypeMapping(Constants.DATATYPES_ONLY).keySet().stream().map(IRI::toString).collect(Collectors.joining(">, <", "<", ">")));
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?prop " + this.createFromClause() + " WHERE { " + Stream.concat(this.config.getDataPropertyClasses().stream(), this.config.getCustomDataTypes().stream()).map(type -> String.format(" ?prop rdf:type|sh:path/rdf:type %s .", Rdf4jModelQueryDaoImpl.outputResource((Resource)type))).collect(Collectors.joining("} UNION {", "{", dataRangeTypes)) + " }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("prop");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return (Set)handler.getResultsAs(Resource.class, LinkedHashSet::new);
    }

    @Override
    public Set<Resource> getObjectProperties() {
        this.updateStatistics("getObjectProperties");
        String iriRangeTypes = String.format("} UNION { ?prop rdfs:range ?range. FILTER(?range in (%s)) . }  UNION {?_ sh:property ?prop. ?prop sh:nodeKind ?kind .   FILTER(?kind in (sh:IRI, sh:BlankNodeOrIRI, sh:BlankNode)) . }  UNION {?_ sh:property ?prop. ?prop sh:class ?_ . }  UNION {?_ sh:property ?prop. ?prop sh:datatype ?type.    FILTER(?type in (%1$s)) . }", String.join((CharSequence)", ", Constants.IRI_BASED_TYPES.keySet()));
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX schema: <http://schema.org/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nSELECT ?prop " + this.createFromClause() + " WHERE { " + this.config.getObjectPropertyClasses().stream().map(type -> String.format(" ?prop rdf:type|sh:path/rdf:type %s .", Rdf4jModelQueryDaoImpl.outputResource((Resource)type))).collect(Collectors.joining("} UNION {", "{", iriRangeTypes)) + " }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("prop");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return (Set)handler.getResultsAs(Resource.class, LinkedHashSet::new);
    }

    @Override
    public Map<Value, List<Value>> findRangeClasses() {
        this.updateStatistics("findRangeClasses");
        String query = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX schema: <http://schema.org/>\nPREFIX so: <http://www.ontotext.com/semantic-object/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?prop ?range " + this.createFromClause() + " WHERE {\n    ?prop (rdfs:range|schema:rangeIncludes|so:range)/(owl:unionOf/rdf:rest*/rdf:first)? ?range .\n    FILTER(isIRI(?range)) .\n}";
        OneToManyPropertyResultHandler handler = new OneToManyPropertyResultHandler("prop", "range");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, List<Value>> findDomainClasses() {
        this.updateStatistics("findDomainClasses");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX schema: <http://schema.org/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT ?prop ?domain " + this.createFromClause() + " WHERE {\n    { ?prop (rdfs:domain|schema:domainIncludes)/(rdf:subClassOf*|(owl:unionOf/rdf:rest*/rdf:first)) ?domain . } \n    FILTER(isIRI(?domain)).\n}";
        OneToManyPropertyResultHandler handler = new OneToManyPropertyResultHandler("prop", "domain");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, List<Value>> resolveShaclPropertyDomains() {
        this.updateStatistics("resolveShaclPropertyDomain");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?prop ?shape " + this.createFromClause() + " WHERE {\n    ?shape sh:property ?prop .\n}";
        OneToManyPropertyResultHandler handler = new OneToManyPropertyResultHandler("prop", "shape");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @Override
    public Map<Value, List<Value>> getSubClasses() {
        this.updateStatistics("getSubClasses");
        String query = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?parent ?child " + this.createFromClause() + " WHERE {\n    ?child rdfs:subClassOf+|sh:node ?parent .\n    FILTER(isIRI(?child) && isIRI(?parent) && ?child != ?parent) .\n}";
        OneToManyPropertyResultHandler handler = new OneToManyPropertyResultHandler("parent", "child");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults();
    }

    @NotNull
    private static String outputIriList(Collection<IRI> collection, String separator) {
        return collection.stream().map(ModelQueryDao::outputResource).collect(Collectors.joining(separator));
    }

    @Override
    @NotNull
    public Map<IRI, Map<IRI, OwlRestrictionsInfo>> getOwlRestrictions() {
        this.updateStatistics("getOwlRestrictions");
        String query = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?class ?property ?onClass ?onDataRange ?required ?minQualifiedCardinality ?maxQualifiedCardinality ?qualifiedCardinality ?range ?cardinality ?minCardinality ?maxCardinality " + this.createFromClause() + " WHERE {\n    ?class rdfs:subClassOf/(owl:unionOf/rdf:rest*/rdf:first)? ?restr .\n    ?restr a owl:Restriction .\n    ?restr owl:onProperty ?property .\n    OPTIONAL {\n        ?restr owl:someValuesFrom ?someValuesFrom .\n        BIND(true as ?required).\n    }\n    OPTIONAL { ?restr owl:onClass ?onClass . }\n    OPTIONAL { ?restr owl:onDataRange ?onDataRange . }\n    {\n        ?restr owl:onClass|owl:onDataRange ?_ .\n        OPTIONAL { ?restr owl:minQualifiedCardinality ?minQualifiedCardinality . }\n        OPTIONAL { ?restr owl:maxQualifiedCardinality ?maxQualifiedCardinality . }\n        OPTIONAL { ?restr owl:qualifiedCardinality ?qualifiedCardinality . }\n    } UNION {\n        ?restr owl:someValuesFrom|owl:allValuesFrom ?range .\n    } UNION {\n        OPTIONAL { ?restr owl:cardinality ?cardinality . }\n        OPTIONAL { ?restr owl:minCardinality ?minCardinality . }\n        OPTIONAL { ?restr owl:maxCardinality ?maxCardinality . }\n    }\n}";
        LinkedHashMap<IRI, Map<IRI, OwlRestrictionsInfo>> propertyToRestriction = new LinkedHashMap<IRI, Map<IRI, OwlRestrictionsInfo>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.readOwlRestrictions(propertyToRestriction));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return propertyToRestriction;
    }

    private Consumer<BindingSet> readOwlRestrictions(Map<IRI, Map<IRI, OwlRestrictionsInfo>> classToProperty) {
        return bindings -> {
            IRI property = (IRI)bindings.getValue("property");
            IRI clazz = (IRI)bindings.getValue("class");
            OwlRestrictionsInfo info = classToProperty.computeIfAbsent(clazz, type -> new LinkedHashMap()).computeIfAbsent(property, prop -> new OwlRestrictionsInfo(clazz, (IRI)prop));
            Utils.readBooleanValue("required", bindings, info::setAtLeastOneValueRequired);
            Utils.readIriValue("onClass", bindings, info::addPossibleClassRange);
            Utils.readIriValue("onDataRange", bindings, info::addPossibleDatatypeRange);
            Utils.readIriValue("range", bindings, info::addPossibleRange);
            Utils.readIntegerValue("minQualifiedCardinality", bindings, info::setMinCardinality);
            Utils.readIntegerValue("maxQualifiedCardinality", bindings, info::setMaxCardinality);
            Utils.readIntegerValue("qualifiedCardinality", bindings, cardinality -> {
                info.setMinCardinality(cardinality);
                info.setMaxCardinality(cardinality);
            });
            Utils.readIntegerValue("minCardinality", bindings, info::setMinCardinality);
            Utils.readIntegerValue("maxCardinality", bindings, info::setMaxCardinality);
            Utils.readIntegerValue("cardinality", bindings, cardinality -> {
                info.setMinCardinality(cardinality);
                info.setMaxCardinality(cardinality);
            });
        };
    }

    @Override
    public Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> shapeIris) {
        this.updateStatistics("getTargetClassToShapes");
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX dash: <http://datashapes.org/dash#>\nSELECT ?shape ?type " + this.createFromClause() + " WHERE {\n    ?shape sh:targetClass|dash:applicableToClass ?type .\n    FILTER(isIRI(?type)).\n}";
        if (!shapeIris.isEmpty()) {
            query = query + " VALUES ?shape { " + Rdf4jModelQueryDaoImpl.outputIriList(shapeIris, " ") + " }";
        }
        LinkedHashMap<IRI, Set<IRI>> mapping = new LinkedHashMap<IRI, Set<IRI>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.readTargetShapeInfo(mapping));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return mapping;
    }

    private Consumer<BindingSet> readTargetShapeInfo(Map<IRI, Set<IRI>> map) {
        return bindings -> {
            Value shape = bindings.getValue("shape");
            Value type = bindings.getValue("type");
            if (shape instanceof IRI) {
                IRI shapeIri = (IRI)shape;
                if (type instanceof IRI) {
                    IRI typeIri = (IRI)type;
                    map.computeIfAbsent(typeIri, id -> new LinkedHashSet()).add(shapeIri);
                }
            }
        };
    }

    private String createFromClause() {
        if (this.contexts.isEmpty() || this.contexts.contains(EXPLICIT) || this.contexts.contains(IMPLICIT)) {
            return "";
        }
        return this.contexts.stream().map(iri -> "FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)iri)).collect(Collectors.joining(" \n", "", " \n"));
    }

    @Override
    public List<IRI> getOntologies(IRI context) {
        this.updateStatistics("getOntologies");
        Object localContext = "";
        if (context != null) {
            localContext = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)context);
        }
        String query = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT ?ontology " + (String)localContext + " WHERE { ?ontology a owl:Ontology . }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("ontology");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getAsIri();
    }

    @Override
    public List<IRI> getGraphQlModels(IRI context) {
        this.updateStatistics("getGraphQlModels");
        Object localContext = "";
        if (context != null) {
            localContext = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)context);
        }
        String query = "PREFIX graphql: <http://datashapes.org/graphql#>\nSELECT ?model " + (String)localContext + " WHERE { ?model a graphql:Schema . }";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("model");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getAsIri();
    }

    @Override
    public Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI ontology, IRI storeContext) {
        this.updateStatistics("extractIriAndPrefixFromVann");
        Object context = "";
        if (storeContext != null || ontology != null) {
            context = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)Objects.requireNonNullElse(storeContext, ontology));
        }
        Object values = "";
        if (ontology != null) {
            values = " VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputResource((Resource)ontology) + "}";
        }
        String query = "PREFIX vann: <http://purl.org/vocab/vann/>\nSELECT ?prefix ?namespace " + (String)context + " WHERE {   ?model vann:preferredNamespaceUri ?namespace .   ?model vann:preferredNamespacePrefix ?prefix .} " + (String)values;
        MapPropertyResultHandler handler = new MapPropertyResultHandler("prefix", "namespace");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults().entrySet().stream().map(Pair::of).findFirst();
    }

    @Override
    public Optional<Value> extractIriAndPrefixFromSwc(IRI ontologyIri, IRI storedContext) {
        this.updateStatistics("extractIriAndPrefixFromSwc");
        Object context = "";
        if (storedContext != null || ontologyIri != null) {
            context = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)Objects.requireNonNullElse(storedContext, ontologyIri));
        }
        Object values = "";
        if (ontologyIri != null) {
            values = " VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputResource((Resource)ontologyIri) + "}";
        }
        String query = PREFIX_SWC + String.format("SELECT ?identifier %s\n WHERE { ?model %s ?identifier . } %s\n", context, Rdf4jModelQueryDaoImpl.outputResource((Resource)Constants.SWC_IDENTIFIER), values);
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("identifier");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults().stream().findFirst();
    }

    @Override
    public Optional<String> extractBaseIri(IRI ontologyIri, IRI graphqlModelId, IRI storedContext) {
        this.updateStatistics("extractBaseIri");
        Object context = "";
        if (storedContext != null || ontologyIri != null) {
            context = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)Objects.requireNonNullElse(storedContext, ontologyIri));
        }
        String query = PREFIX_SWC + "SELECT ?baseIri %s WHERE { ?model %s ?baseIri .} VALUES ?model {%s}".formatted(context, Rdf4jModelQueryDaoImpl.outputIriList(List.of(Constants.SWC_BASE_URL, SomlOntology.BASE_IRI), "|"), Stream.of(ontologyIri, graphqlModelId).filter(Objects::nonNull).map(Rdf4jModelQueryDaoImpl::outputResource).collect(Collectors.joining(" ")));
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("baseIri");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getResults().stream().map(Value::stringValue).findFirst().or(() -> this.connection.getNamespaces().stream().filter(namespace -> "".equals(namespace.getPrefix())).map(Namespace::getName).findFirst());
    }

    @Override
    public Optional<Pair<String, String>> getDefaultPrefix(IRI graphqlModelId, IRI ontologyId, IRI storedContext) {
        this.updateStatistics("getDefaultPrefix");
        List<IRI> source = Stream.of(graphqlModelId, ontologyId).filter(Objects::nonNull).distinct().toList();
        if (source.isEmpty()) {
            return Optional.empty();
        }
        Object context = "";
        if (storedContext != null || ontologyId != null) {
            context = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)Objects.requireNonNullElse(storedContext, ontologyId));
        }
        String query = "PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?prefix ?namespace" + (String)context + " WHERE {   ?model graphql:defaultPrefix [ sh:prefix ?prefix; sh:namespace ?namespace] .} VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputIriList(source, " ") + "}";
        MapPropertyResultHandler handler = new MapPropertyResultHandler("prefix", "namespace");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        Map results = handler.getResults();
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return results.entrySet().stream().map(entry -> Pair.of((Object)((Value)entry.getKey()).stringValue(), (Object)((Value)entry.getValue()).stringValue())).findFirst();
    }

    @Override
    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> models, IRI storedContext) {
        this.updateStatistics("getDeclaredPrefixes");
        Object context = "";
        if (storedContext != null) {
            context = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)storedContext);
        }
        String query = "PREFIX graphql: <http://datashapes.org/graphql#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?prefix ?namespace" + (String)context + " WHERE {   ?model sh:declare [ sh:prefix ?prefix; sh:namespace ?namespace] .} VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputIriList(models, " ") + "}";
        MapPropertyResultHandler handler = new MapPropertyResultHandler("prefix", "namespace");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        Map results = handler.getResults();
        if (results.isEmpty()) {
            return List.of();
        }
        return results.entrySet().stream().map(entry -> Pair.of((Object)((Value)entry.getKey()).stringValue(), (Object)((Value)entry.getValue()).stringValue())).toList();
    }

    @Override
    public Optional<IRI> getDefinedBy(IRI graphqlModelId, IRI storedContext) {
        this.updateStatistics("getDefinedBy");
        Object context = "";
        if (storedContext != null) {
            context = " FROM " + Rdf4jModelQueryDaoImpl.outputResource((Resource)storedContext);
        }
        String query = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?definedBy" + (String)context + " WHERE {   ?model rdfs:isDefinedBy ?definedBy .} VALUES ?model {" + Rdf4jModelQueryDaoImpl.outputResource((Resource)graphqlModelId) + "}";
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("definedBy");
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        return handler.getAsIri().stream().findFirst();
    }

    @Override
    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repositoryId) {
        String query = "PREFIX sh: <http://www.w3.org/ns/shacl#>\nPREFIX vann: <http://purl.org/vocab/vann/>\nSELECT *\nWHERE {\n    {\n        ?model sh:declare [ sh:prefix ?prefix;\n            sh:namespace ?namespace] .\n    } UNION {\n        ?model vann:preferredNamespacePrefix ?prefix .\n        ?model vann:preferredNamespaceUri ?namespace .\n    }\n}";
        LinkedHashMap<NamespaceMapping, List<String>> namespaceMappingsSourcesMap = new LinkedHashMap<NamespaceMapping, List<String>>();
        ConsumingTupleQueryResultHandler handler = new ConsumingTupleQueryResultHandler(this.populatePairSourcesMap(namespaceMappingsSourcesMap));
        this.executeQuery(query, (AbstractTupleQueryResultHandler)handler);
        this.connection.getNamespaces().forEach(namespace -> {
            NamespaceMapping mapping = new NamespaceMapping(namespace.getPrefix(), namespace.getName());
            namespaceMappingsSourcesMap.computeIfAbsent(mapping, key -> new ArrayList()).add(repositoryId);
        });
        return this.convertNamespaceMappingsSourcesMap(namespaceMappingsSourcesMap);
    }

    protected void executeQuery(String query, AbstractTupleQueryResultHandler handler) {
        QueryRequest request = QueryRequest.newSimpleQuery((String)query);
        request.setIncludeInferred(Boolean.FALSE);
        request.disableRequestLogging();
        this.connection.executeSelect(request, (TupleQueryResultHandler)handler);
    }

    private Consumer<BindingSet> populatePairSourcesMap(Map<NamespaceMapping, List<String>> namespaceMappingsSourcesMap) {
        return namespaceMapping -> {
            String prefix = namespaceMapping.getValue("prefix").stringValue();
            String namespace = namespaceMapping.getValue("namespace").stringValue();
            String model = namespaceMapping.getValue("model").stringValue();
            namespaceMappingsSourcesMap.computeIfAbsent(new NamespaceMapping(prefix, namespace), k -> new ArrayList()).add(model);
        };
    }

    private List<PrefixNamespaceResponse> convertNamespaceMappingsSourcesMap(Map<NamespaceMapping, List<String>> namespaceMappingsSourcesMap) {
        ArrayList<PrefixNamespaceResponse> responseList = new ArrayList<PrefixNamespaceResponse>(namespaceMappingsSourcesMap.size() + 1);
        for (Map.Entry<NamespaceMapping, List<String>> entry : namespaceMappingsSourcesMap.entrySet()) {
            NamespaceMapping pair = entry.getKey();
            List<String> sources = entry.getValue();
            responseList.add(new PrefixNamespaceResponse(pair.prefix(), pair.namespace(), sources));
        }
        return responseList;
    }
}

