/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.persistent;

import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OntologyMetadata;
import com.ontotext.platform.owl2soml.persistent.PersistentOntologyMetadata;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;

public class OntologyReference
extends Ontology {
    public OntologyReference(IRI ontologyId, DataAccess dataAccess, List<Message> messages) {
        super(dataAccess, messages);
        this.ontologyId = ontologyId;
    }

    @Override
    public OntologyMetadata readMetadata() {
        return new PersistentOntologyMetadata(this);
    }

    @Override
    public void resolveOntologyByGraphQlModel() {
        if (this.graphqlModelId != null) {
            Optional<IRI> definedBy = this.dataAccess.getDefinedBy(this.graphqlModelId, this.storedContext);
            definedBy.ifPresent(ontology -> {
                this.ontologyId = ontology;
            });
            List<IRI> referencedOntologies = this.dataAccess.getPublicReferencedOntologies(this.graphqlModelId);
            if (!referencedOntologies.isEmpty()) {
                this.ontologyIds = referencedOntologies;
            }
        }
    }

    @Override
    public Ontology createAllowAllOntology() {
        return new OntologyReference(null, this.dataAccess, this.messages);
    }
}

