/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.persistent;

import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.persistent.ModelQueryDao;
import com.ontotext.sparql.SinglePropertyResultHandler;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.query.BindingSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ModelQueryDaoCache
implements Closeable {
    private final ModelQueryDao dao;
    private Set<Resource> deactivatedShapes;
    private Map<Value, List<Value>> labels;
    private Map<Value, Set<Value>> descriptions;
    private Map<Value, List<Value>> gqlTypeNames;
    private Map<Value, Set<Value>> gqlPropNames;
    private Map<Value, Set<Value>> inverseOf;
    private Set<Resource> shaclProperties;
    private Map<Value, Set<Value>> propertyTypes;
    private Set<Resource> dataProperties;
    private Set<Resource> objectProperties;
    private Map<Value, List<Value>> propertyRanges;
    private Map<Value, List<Value>> propertyDomains;
    private Map<Value, List<Value>> shaclPropertyDomains;
    private Map<Value, List<Value>> parentToChildMapping;
    private Map<IRI, Set<IRI>> classToShapes;
    private Map<IRI, Set<IRI>> shapesToClass;
    private Map<Value, Value> shaclPropertyPaths;
    private Map<Value, List<BindingSet>> propertyMedata;
    private Map<Value, List<BindingSet>> classMetadata;
    private Map<Value, Boolean> interfaces;
    private Map<Resource, List<PropertyInverseInfo>> propertyInverseInfo;
    private Map<String, Map<IRI, Value>> generationConfigs;

    public ModelQueryDaoCache(ModelQueryDao dao) {
        this.dao = dao;
    }

    void configure(Config config, Namespaces namespaces) {
        this.dao.configure(config, namespaces);
    }

    void configureWith(Ontology ontology) {
        this.dao.configureWith(ontology);
    }

    @Override
    public void close() {
        try {
            this.deactivatedShapes = ModelQueryDaoCache.reset(this.deactivatedShapes);
            this.dataProperties = ModelQueryDaoCache.reset(this.dataProperties);
            this.objectProperties = ModelQueryDaoCache.reset(this.objectProperties);
            this.shaclProperties = ModelQueryDaoCache.reset(this.shaclProperties);
            this.inverseOf = ModelQueryDaoCache.reset(this.inverseOf);
            this.labels = ModelQueryDaoCache.reset(this.labels);
            this.descriptions = ModelQueryDaoCache.reset(this.descriptions);
            this.gqlTypeNames = ModelQueryDaoCache.reset(this.gqlTypeNames);
            this.gqlPropNames = ModelQueryDaoCache.reset(this.gqlPropNames);
            this.propertyTypes = ModelQueryDaoCache.reset(this.propertyTypes);
            this.propertyRanges = ModelQueryDaoCache.reset(this.propertyRanges);
            this.propertyDomains = ModelQueryDaoCache.reset(this.propertyDomains);
            this.shaclPropertyDomains = ModelQueryDaoCache.reset(this.shaclPropertyDomains);
            this.parentToChildMapping = ModelQueryDaoCache.reset(this.parentToChildMapping);
            this.classToShapes = ModelQueryDaoCache.reset(this.classToShapes);
            this.shapesToClass = ModelQueryDaoCache.reset(this.shapesToClass);
            this.propertyMedata = ModelQueryDaoCache.reset(this.propertyMedata);
            this.classMetadata = ModelQueryDaoCache.reset(this.classMetadata);
            this.interfaces = ModelQueryDaoCache.reset(this.interfaces);
            this.generationConfigs = ModelQueryDaoCache.reset(this.generationConfigs);
        }
        finally {
            this.dao.close();
        }
    }

    private static <T, C extends Collection<T>> C reset(C collection) {
        if (collection != null) {
            collection.clear();
        }
        return null;
    }

    private static <K, V, M extends Map<K, V>> M reset(M map) {
        if (map != null) {
            map.clear();
        }
        return null;
    }

    SinglePropertyResultHandler findAlternativeConfigurationsOf(@Nullable IRI modelId, Set<IRI> iris) {
        return this.dao.findAlternativeConfigurationsOf(modelId, iris);
    }

    boolean isConfigurationEnabled(@Nullable IRI modelId, IRI configPredicate) {
        return this.dao.isConfigurationEnabled(modelId, configPredicate);
    }

    SinglePropertyResultHandler getCustomDataTypes() {
        return this.dao.getCustomDataTypes();
    }

    SinglePropertyResultHandler getGraphQlName(IRI graphqlModelId) {
        return this.dao.getGraphQlName(graphqlModelId);
    }

    SinglePropertyResultHandler getPublicReferencedOntologies(IRI graphqlModelId) {
        return this.dao.getPublicReferencedOntologies(graphqlModelId);
    }

    SinglePropertyResultHandler getImportedOntologies(Set<IRI> primaryOntologies) {
        return this.dao.getImportedOntologies(primaryOntologies);
    }

    List<Namespace> getNamespaces(Ontology ontology) {
        return this.dao.getNamespaces(ontology);
    }

    GraphQlSchema loadGraphQlModel(IRI modelId) {
        return this.dao.loadGraphQlModel(modelId);
    }

    Collection<GraphQlSchemaShape> getGraphQlSchemaShapes() {
        return this.dao.getGraphQlSchemaShapes();
    }

    SinglePropertyResultHandler findAllExplicitClasses() {
        return this.dao.findAllExplicitClasses();
    }

    boolean isDeactivated(Resource resource) {
        return this.getDeactivatedShapes().contains(resource);
    }

    Set<Resource> getDeactivatedShapes() {
        if (this.deactivatedShapes == null) {
            this.deactivatedShapes = this.dao.getDeactivatedShapes();
        }
        return this.deactivatedShapes;
    }

    SinglePropertyResultHandler findReferencedShaclNodes(Set<IRI> iris) {
        return this.dao.findReferencedShaclNodes(iris);
    }

    SinglePropertyResultHandler findReferencedShaclTypes(Set<IRI> iris) {
        return this.dao.findReferencedShaclTypes(iris);
    }

    void readClassMetadata(Resource id, Classes.Class target, Ontology ontology) {
        if (this.classMetadata == null) {
            this.classMetadata = this.dao.getClassMetadata();
        }
        if (id instanceof IRI) {
            List bindingSets = this.classMetadata.getOrDefault(id, List.of());
            bindingSets.forEach(this.dao.populateTypeMetadata(target, ontology));
        } else if (id instanceof BNode) {
            List<BindingSet> bindingSets = this.dao.getClassMetadata(id);
            bindingSets.forEach(this.dao.populateTypeMetadata(target, ontology));
        }
    }

    Optional<Boolean> isInterfaceType(Resource iri) {
        if (this.interfaces == null) {
            this.interfaces = this.dao.getInterfaceTypes();
        }
        return Optional.ofNullable(this.interfaces.get(iri));
    }

    List<Literal> getLabel(Resource iri) {
        if (this.labels == null) {
            this.labels = this.dao.getLabels();
        }
        return this.labels.getOrDefault(iri, List.of()).stream().filter(Literal.class::isInstance).map(Literal.class::cast).toList();
    }

    List<Literal> getDescription(Resource iri) {
        if (this.descriptions == null) {
            this.descriptions = this.dao.getDescriptions();
        }
        return this.descriptions.getOrDefault(iri, Set.of()).stream().filter(Literal.class::isInstance).map(Literal.class::cast).toList();
    }

    List<Literal> gqlTypeName(Resource iri) {
        if (this.gqlTypeNames == null) {
            this.gqlTypeNames = this.dao.gqlTypeNames();
        }
        return this.gqlTypeNames.getOrDefault(iri, List.of()).stream().map(Literal.class::cast).toList();
    }

    List<Literal> gqlPropertyName(Resource iri) {
        if (this.gqlPropNames == null) {
            this.gqlPropNames = this.dao.gqlPropertyNames();
        }
        return this.gqlPropNames.getOrDefault(iri, Set.of()).stream().filter(Literal.class::isInstance).map(Literal.class::cast).toList();
    }

    Set<Value> getInverseOf(Resource resource) {
        if (this.inverseOf == null) {
            this.inverseOf = this.dao.getInverseOf();
        }
        return this.inverseOf.getOrDefault(resource, Set.of());
    }

    SinglePropertyResultHandler findAllExplicitProperties() {
        return this.dao.getExplicitProperties();
    }

    boolean isShaclProperty(Resource iri) {
        if (this.shaclProperties == null) {
            this.shaclProperties = this.dao.getShaclProperties();
        }
        return this.shaclProperties.contains(iri);
    }

    boolean isSymmetricProperty(Resource iri) {
        return this.getPropertyTypes(iri).contains(OWL.SYMMETRICPROPERTY);
    }

    boolean isMultiValuedProperty(Resource iri) {
        return !this.getPropertyTypes(iri).contains(OWL.FUNCTIONALPROPERTY);
    }

    private Set<Resource> getPropertyTypes(Resource iri) {
        if (this.propertyTypes == null) {
            this.propertyTypes = this.dao.getPropertyTypes();
        }
        return this.propertyTypes.computeIfAbsent((Value)iri, key -> this.dao.getTypes((Resource)key)).stream().map(Resource.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    void readShaclPropertyMetadata(Properties.Property property, Resource shaclId, Ontology ontology, ModelQueryDao.PropTypeConfig typeConfig, ModelQueryDao.LangConfig langConfig) {
        if (this.propertyMedata == null) {
            this.propertyMedata = this.dao.readShaclPropertiesMetadata();
        }
        List bindingSets = this.propertyMedata.getOrDefault(shaclId, List.of());
        bindingSets.forEach(this.dao.populatePropertyShaclMetadata(property, ontology, langConfig, typeConfig));
    }

    void readShaclPropertyPath(Properties.Property property, Resource shaclId) {
        if (property.getRdfProp() != null && property.getRdfPropIri() != null) {
            return;
        }
        if (this.shaclPropertyPaths == null) {
            this.shaclPropertyPaths = this.dao.getShaclPropertyPaths();
        }
        Value path = this.shaclPropertyPaths.get(shaclId);
        this.dao.readShaclPropertyPath(property, shaclId, path);
    }

    @NotNull
    List<PropertyInverseInfo> getPropertyInverseInfo(Resource resource) {
        if (this.propertyInverseInfo == null) {
            this.propertyInverseInfo = this.dao.readShaclInverseRelations().stream().collect(Collectors.groupingBy(PropertyInverseInfo::getPropertyShape));
        }
        return this.propertyInverseInfo.getOrDefault(resource, List.of());
    }

    List<IRI> getOntologies(IRI context) {
        return this.dao.getOntologies(context);
    }

    List<IRI> getGraphQlModels(IRI context) {
        return this.dao.getGraphQlModels(context);
    }

    Map<String, Object> readOntologyMetadata(IRI ontologyIri) {
        return this.dao.readOntologyMetadata(ontologyIri);
    }

    boolean isDataProperty(Resource iri) {
        if (this.dataProperties == null) {
            this.dataProperties = this.dao.getDataProperties();
        }
        return this.dataProperties.contains(iri);
    }

    boolean isObjectProperty(Resource iri) {
        if (this.objectProperties == null) {
            this.objectProperties = this.dao.getObjectProperties();
        }
        return this.objectProperties.contains(iri);
    }

    List<Value> findRangeClasses(Resource propIri) {
        List<Value> ranges;
        if (this.propertyRanges == null) {
            this.propertyRanges = this.dao.findRangeClasses();
        }
        if ((ranges = this.propertyRanges.get(propIri)) == null) {
            return new LinkedList<Value>();
        }
        return ranges;
    }

    List<Value> findDomainClasses(Resource propIri) {
        List<Value> values;
        if (this.propertyDomains == null) {
            this.propertyDomains = this.dao.findDomainClasses();
        }
        if ((values = this.propertyDomains.get(propIri)) == null) {
            return new LinkedList<Value>();
        }
        return values;
    }

    List<Value> resolveShaclPropertyDomain(Resource propIri) {
        if (this.shaclPropertyDomains == null) {
            this.shaclPropertyDomains = this.dao.resolveShaclPropertyDomains();
        }
        return this.shaclPropertyDomains.getOrDefault(propIri, List.of());
    }

    List<IRI> getSubClasses(List<IRI> parents) {
        if (this.parentToChildMapping == null) {
            this.parentToChildMapping = this.dao.getSubClasses();
        }
        return parents.stream().flatMap(parent -> this.parentToChildMapping.getOrDefault(parent, List.of()).stream()).filter(IRI.class::isInstance).map(IRI.class::cast).toList();
    }

    @NotNull
    Map<IRI, Map<IRI, OwlRestrictionsInfo>> getOwlRestrictions() {
        return this.dao.getOwlRestrictions();
    }

    Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> iris) {
        if (this.classToShapes == null) {
            this.classToShapes = this.dao.getTargetClassToShapes(List.of());
            this.shapesToClass = new LinkedHashMap<IRI, Set<IRI>>();
            this.classToShapes.forEach((type, shapes) -> {
                for (IRI shape : shapes) {
                    this.shapesToClass.computeIfAbsent(shape, k -> new LinkedHashSet()).add(type);
                }
            });
        }
        if (iris.isEmpty()) {
            return this.classToShapes;
        }
        LinkedHashMap<IRI, Set<IRI>> mapping = new LinkedHashMap<IRI, Set<IRI>>();
        for (IRI iri : iris) {
            Set<IRI> targets = this.classToShapes.get(iri);
            if (targets != null) {
                mapping.put(iri, targets);
                continue;
            }
            Set<IRI> set = this.shapesToClass.get(iri);
            if (set == null) continue;
            set.forEach(type -> mapping.computeIfAbsent((IRI)type, k -> new LinkedHashSet()).add(iri));
        }
        return mapping;
    }

    public boolean isShape(IRI iri) {
        this.getTargetClassToShapes(List.of());
        return this.shapesToClass.containsKey(iri);
    }

    public Set<IRI> getTargetsForShape(IRI shape) {
        this.getTargetClassToShapes(List.of());
        return this.shapesToClass.getOrDefault(shape, Set.of());
    }

    Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI ontology, IRI storeContext) {
        return this.dao.extractIriAndPrefixFromVann(ontology, storeContext);
    }

    public Optional<Value> extractIriAndPrefixFromSwc(IRI ontologyIri, IRI storedContext) {
        return this.dao.extractIriAndPrefixFromSwc(ontologyIri, storedContext);
    }

    public Optional<String> extractBaseIri(IRI ontologyIri, IRI graphqlModelId, IRI storedContext) {
        return this.dao.extractBaseIri(ontologyIri, graphqlModelId, storedContext);
    }

    public Optional<Pair<String, String>> getDefaultPrefix(IRI graphqlModelId, IRI ontologyId, IRI storedContext) {
        return this.dao.getDefaultPrefix(graphqlModelId, ontologyId, storedContext);
    }

    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> models, IRI storedContext) {
        return this.dao.getDeclaredPrefixes(models, storedContext);
    }

    public Optional<IRI> getDefinedBy(IRI graphqlModelId, IRI storedContext) {
        return this.dao.getDefinedBy(graphqlModelId, storedContext);
    }

    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repositoryId) {
        return this.dao.getPossiblePrefixes(repositoryId);
    }

    public boolean isContext(IRI iri) {
        return this.dao.isContext(iri);
    }

    public boolean isOntology(IRI iri) {
        return this.dao.isOntology(iri);
    }

    public Optional<Value> getConfiguration(IRI modelId, IRI configPredicate) {
        if (this.generationConfigs == null) {
            this.generationConfigs = this.dao.findGenerationConfigs();
        }
        String key = modelId == null ? "unbound" : modelId.stringValue();
        Map configs = this.generationConfigs.getOrDefault(key, Map.of());
        return Optional.ofNullable((Value)configs.get(configPredicate));
    }

    public Map<String, Map<String, Role>> findRbacRoles(IRI ontologyId) {
        return this.dao.findRbacRoles(ontologyId);
    }

    public Optional<Value> readOntologyId(IRI modelId) {
        return this.dao.readOntologyId(modelId);
    }
}

