/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.memory;

import com.ontotext.platform.owl2soml.Constants;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OntologyMetadata;
import com.ontotext.platform.owl2soml.OntologyMetadataExtractor;
import com.ontotext.platform.owl2soml.Utils;
import java.util.Comparator;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.jetbrains.annotations.NotNull;

public class InMemoryOntology
extends Ontology {
    private final Model ontologyModel;

    public InMemoryOntology(Model ontologyModel, DataAccess dataAccess, List<Message> messages) {
        super(dataAccess, messages);
        this.ontologyModel = ontologyModel;
    }

    public Model getModel() {
        return this.ontologyModel;
    }

    void detectOntologyDefinition() {
        this.setOntologyIds(this.ontologyModel.filter(null, RDF.TYPE, (Value)OWL.ONTOLOGY, new Resource[0]).stream().filter(Utils.subjectsAreIris()).map(Statement::getSubject).map(IRI.class::cast).sorted(Comparator.comparing(IRI::toString)).toList());
        this.setGraphqlModelIds(this.ontologyModel.filter(null, RDF.TYPE, (Value)Constants.GRAPHQL_SCHEMA, new Resource[0]).stream().filter(Utils.subjectsAreIris()).map(Statement::getSubject).map(IRI.class::cast).sorted(Comparator.comparing(IRI::toString)).toList());
        if (this.ontologyIds.size() == 1) {
            this.ontologyId = (IRI)this.ontologyIds.getFirst();
        }
        if (this.graphqlModelIds.size() == 1) {
            this.graphqlModelId = (IRI)this.graphqlModelIds.getFirst();
        }
        if (this.graphqlModelId != null && this.ontologyIds.contains(this.graphqlModelId)) {
            this.ontologyId = this.graphqlModelId;
        }
    }

    @Override
    public OntologyMetadata readMetadata() {
        return new OntologyMetadataExtractor(this, this){

            @Override
            @NotNull
            protected GraphQlSchema getGraphQlSchema(Namespaces namespaces) {
                if (namespaces.isVocabularySet()) {
                    return super.getGraphQlSchema(namespaces);
                }
                return new GraphQlSchema();
            }
        };
    }

    @Override
    public Ontology createAllowAllOntology() {
        InMemoryOntology ontology = new InMemoryOntology(this.ontologyModel, this.dataAccess, this.messages);
        ontology.graphqlModelId = null;
        return ontology;
    }
}

