/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.models.Prefixes;
import com.ontotext.platform.owl2soml.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final Pattern TRAILING_DOT = Pattern.compile("\\.$");
    private static final Map<IRI, String> DATATYPE_IRIS = Utils.createDatatypeIriMap();
    private static final Set<IRI> IRI_IRIS = Utils.createDatatypeIriSet();
    private static final Pattern MULTILINE_EMPTY_BLOCK = Pattern.compile("\\{\\s*}");

    public static Model parseFile(String content, String fileName) throws IOException {
        RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)fileName).orElse(RDFFormat.TURTLE);
        try {
            return Rio.parse((Reader)new StringReader(content), (String)"http://example.com", (RDFFormat)rdfFormat, (Resource[])new Resource[0]);
        }
        catch (RDFParseException ex) {
            throw new RDFParseException("Failed to parse " + fileName, (Throwable)ex);
        }
    }

    public static Model parseFile(InputStream content, String fileName) throws IOException {
        RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)fileName).orElse(RDFFormat.TURTLE);
        return Rio.parse((InputStream)content, (String)"http://example.com", (RDFFormat)rdfFormat, (Resource[])new Resource[0]);
    }

    public static List<Value> expandList(Value value, BiFunction<Resource, IRI, Optional<Value>> expandFunc) {
        Resource listNode;
        if (!(value instanceof Resource)) {
            return List.of(value);
        }
        LinkedList<Value> result = new LinkedList<Value>();
        if (value.equals((Object)RDF.NIL)) {
            return List.of();
        }
        do {
            Optional<Value> first;
            if ((first = expandFunc.apply(listNode = (Resource)value, RDF.FIRST)).isEmpty()) {
                result.add((Value)listNode);
                break;
            }
            result.add(first.get());
        } while (!(value = expandFunc.apply(listNode, RDF.REST).orElse((Value)RDF.NIL)).equals((Object)RDF.NIL));
        return result;
    }

    public static Predicate<Statement> objectsAreLiterals() {
        return statement -> statement.getObject() instanceof Literal;
    }

    public static Predicate<Statement> objectsAreNumbers() {
        return statement -> {
            Value patt0$temp = statement.getObject();
            if (patt0$temp instanceof Literal) {
                Literal objLiteral = (Literal)patt0$temp;
                try {
                    objLiteral.decimalValue();
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            return false;
        };
    }

    public static Function<Statement, Stream<Resource>> objectAsResource() {
        return statement -> {
            Value patt0$temp = statement.getObject();
            if (patt0$temp instanceof Resource) {
                Resource objResource = (Resource)patt0$temp;
                return Stream.of(objResource);
            }
            return Stream.empty();
        };
    }

    public static Function<Statement, Stream<IRI>> objectAsIri() {
        return statement -> {
            Value patt0$temp = statement.getObject();
            if (patt0$temp instanceof IRI) {
                IRI objIri = (IRI)patt0$temp;
                return Stream.of(objIri);
            }
            return Stream.empty();
        };
    }

    public static Function<Statement, Stream<Literal>> objectAsLiteral() {
        return statement -> {
            Value patt0$temp = statement.getObject();
            if (patt0$temp instanceof Literal) {
                Literal objLiteral = (Literal)patt0$temp;
                return Stream.of(objLiteral);
            }
            return Stream.empty();
        };
    }

    public static Predicate<Statement> objectsAreEnStrings() {
        return statement -> statement.getObject() instanceof Literal && Utils.isEnLiteral(statement);
    }

    private static boolean isEnLiteral(Statement statement) {
        return ((Literal)statement.getObject()).getLanguage().orElse("en").toLowerCase().startsWith("en");
    }

    public static Predicate<Statement> subjectsAreIris() {
        return statement -> statement.getSubject() instanceof IRI;
    }

    public static Predicate<Statement> objectsAreIris() {
        return statement -> statement.getObject() instanceof IRI;
    }

    public static boolean iriIsNotDatatype(Resource iri) {
        return iri instanceof IRI && !Utils.isDatatype(iri);
    }

    public static boolean isDatatype(Resource iri) {
        return iri instanceof IRI && (DATATYPE_IRIS.containsKey(iri) || iri.stringValue().startsWith("http://www.ontotext.com/semantic-object/scalars/"));
    }

    public static String getDataTypeForIri(IRI iri) {
        if (iri.stringValue().startsWith("http://www.ontotext.com/semantic-object/scalars/")) {
            return iri.stringValue().substring("http://www.ontotext.com/semantic-object/scalars/".length());
        }
        return DATATYPE_IRIS.get(iri);
    }

    public static boolean isIriBasedType(IRI iri) {
        return IRI_IRIS.contains(iri);
    }

    public static Function<String, String> removeTrailingDots() {
        return str -> TRAILING_DOT.matcher((CharSequence)str).replaceAll("");
    }

    public static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static <E> void addIfNotNull(Collection<E> collection, E value) {
        if (value != null) {
            collection.add(value);
        }
    }

    public static String singleLinedEmptyBlocks(String yaml) {
        return MULTILINE_EMPTY_BLOCK.matcher(yaml).replaceAll("{}");
    }

    private static Set<IRI> createDatatypeIriSet() {
        return Constants.IRI_BASED_TYPES.keySet().stream().filter(str -> Constants.DEFAULT_PREFIXES.containsKey((Object)str.split(":")[0])).map(arg_0 -> ((Prefixes)Constants.DEFAULT_PREFIXES).toIri(arg_0)).map(arg_0 -> ((ValueFactory)vf).createIRI(arg_0)).collect(Collectors.toSet());
    }

    private static Map<IRI, String> createDatatypeIriMap() {
        Map<IRI, String> typeMapping = Utils.createTypeMapping(Constants.DATATYPES_ONLY);
        Map<IRI, String> iriMapping = Utils.createTypeMapping(Constants.IRI_BASED_TYPES);
        typeMapping.putAll(iriMapping);
        return typeMapping;
    }

    @NotNull
    public static <V> Map<IRI, V> createTypeMapping(Map<String, V> map) {
        return map.entrySet().stream().filter(entry -> Constants.DEFAULT_PREFIXES.containsKey((Object)((String)entry.getKey()).split(":")[0])).collect(Collectors.toMap(entry -> vf.createIRI(Constants.DEFAULT_PREFIXES.toIri((String)entry.getKey())), Map.Entry::getValue));
    }

    public static String formatVersion(Value object) {
        String version = object.stringValue();
        Matcher matcher = Constants.VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            return version.substring(matcher.start(), matcher.end());
        }
        return version;
    }

    public static String toLocalDateString(Value value) {
        String stringValue = value.stringValue();
        try {
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(stringValue);
            return new SimpleDateFormat("yyyy-MM-dd").format(cal.toGregorianCalendar().getTime());
        }
        catch (DatatypeConfigurationException ex) {
            return stringValue;
        }
    }

    private Utils() {
    }

    public static Comparator<Value> iriComparator() {
        return Comparator.comparing(Value::stringValue);
    }

    public static void readStringValue(String key, BindingSet bindings, Consumer<String> setter) {
        Value value = bindings.getValue(key);
        if (value != null) {
            setter.accept(value.stringValue());
        }
    }

    public static void readBooleanValue(String key, BindingSet bindings, Consumer<Boolean> setter) {
        Value value = bindings.getValue(key);
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            setter.accept(literal.booleanValue());
        }
    }

    public static void readIntegerValue(String key, BindingSet bindings, IntConsumer setter) {
        Value value = bindings.getValue(key);
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            try {
                setter.accept(literal.decimalValue().toBigInteger().intValue());
            }
            catch (NumberFormatException nfe) {
                if (value.stringValue().equals("unbounded") || value.stringValue().equals("\u221e")) {
                    setter.accept(Integer.MAX_VALUE);
                }
                throw nfe;
            }
        }
    }

    public static void readDoubleValue(String key, BindingSet bindings, DoubleConsumer setter) {
        Value value = bindings.getValue(key);
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            setter.accept(literal.decimalValue().doubleValue());
        }
    }

    public static IRI readIriValue(String key, BindingSet bindings) {
        Value value = bindings.getValue(key);
        if (value instanceof IRI) {
            IRI iri = (IRI)value;
            return iri;
        }
        return null;
    }

    public static void readIriValue(String key, BindingSet bindings, Consumer<IRI> setter) {
        Value value = bindings.getValue(key);
        if (value instanceof IRI) {
            IRI iri = (IRI)value;
            setter.accept(iri);
        }
    }

    public static void readResourceValue(String key, BindingSet bindings, Consumer<Resource> setter) {
        Value value = bindings.getValue(key);
        if (value instanceof Resource) {
            Resource resource = (Resource)value;
            setter.accept(resource);
        }
    }

    public static void readLiteralValue(String key, BindingSet bindings, Consumer<Literal> setter) {
        Value value = bindings.getValue(key);
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            setter.accept(literal);
        }
    }

    public static void readValue(String key, BindingSet bindings, Consumer<Value> setter) {
        Value value = bindings.getValue(key);
        if (Objects.nonNull(value)) {
            setter.accept(value);
        }
    }

    public static String extractPrefix(String shortIri) {
        if (shortIri == null) {
            return null;
        }
        int index = shortIri.indexOf(58);
        return index == -1 ? null : shortIri.substring(0, index);
    }
}

