/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.ConversionException;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.MultiTypeDef;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Utils;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.jetbrains.annotations.NotNull;

public class Properties {
    private final Ontology ontology;
    private final Namespaces namespaces;
    private final DataAccess dataAccess;
    private List<Message> messages;
    private Map<Resource, Property> props = new LinkedHashMap<Resource, Property>();

    public Properties(Ontology ontology, Namespaces namespaces, DataAccess dataAccess, List<Message> messages) {
        this.ontology = ontology;
        this.namespaces = namespaces;
        this.dataAccess = dataAccess;
        this.messages = messages;
    }

    public static Property merge(Property prevProp, Property newProp) {
        String range;
        Object max;
        if (prevProp == null) {
            return newProp;
        }
        if (newProp.getMin() != null) {
            prevProp.setMin(newProp.getMin());
        }
        if ((max = newProp.getMax()) != null) {
            if ("inf".equals(max)) {
                prevProp.setMax(Integer.MAX_VALUE);
            } else {
                prevProp.setMax(Integer.parseInt(max.toString()));
            }
        }
        if ("iri".equals(range = prevProp.getRange()) || "string".equals(range)) {
            prevProp.setKind(newProp.getKind());
            prevProp.setRange((String)ObjectsUtil.getOrDefault((Object)newProp.getRange(), (Object)range));
        } else if (!"iri".equals(newProp.getRange()) && !"string".equals(newProp.getRange())) {
            prevProp.setRange(newProp.getRange());
            prevProp.setRangeClass(newProp.getRangeClass());
            prevProp.setKind(newProp.getKind());
        }
        if (newProp.isTypeName) {
            prevProp.setIsTypeName(true);
        }
        prevProp.mergeGenericCharacteristicsFrom(newProp);
        prevProp.mergeShaclCharacteristicsFrom(newProp);
        return prevProp;
    }

    void collect() {
        Set<Resource> propIris = this.findAllPropsInTheModel();
        for (Resource prop : propIris) {
            Property property = this.buildPropObject(prop);
            if (property == null) continue;
            this.props.put(property.getIri(), property);
        }
        this.setShaclPropReferences();
    }

    private void setShaclPropReferences() {
        for (Property property : this.props.values()) {
            String rdfProp;
            IRI iri;
            Property baseProperty;
            if (!property.isShaclProperty() || property.getRdfProp() == null || property.isSparqlTemplate() || (baseProperty = this.props.get(iri = this.namespaces.iri(rdfProp = property.getRdfProp()))) == null) continue;
            baseProperty.addShaclProperty(property);
        }
    }

    Map<String, Object> toSomlProps() {
        TreeMap<String, Object> somlProps = new TreeMap<String, Object>();
        for (Property prop : this.props.values()) {
            if (!prop.isUsed() || prop.isHidden()) continue;
            somlProps.put(prop.getName(), prop.somlObject());
        }
        return somlProps;
    }

    List<Property> values() {
        return new ArrayList<Property>(this.props.values());
    }

    public Property getOrCreateProp(IRI iri) {
        return this.props.computeIfAbsent((Resource)iri, this::buildPropObject);
    }

    public Property get(IRI iri) {
        return this.props.get(iri);
    }

    boolean contains(Resource iri) {
        return this.props.containsKey(iri);
    }

    public Property buildPropObject(Resource propIri) {
        return new Property(propIri).readMetadata();
    }

    void setInverseOf() {
        this.dataAccess.materializeInverseRelations(this.props.values());
        this.props.values().stream().filter(property -> !property.isShaclProperty()).forEach(property -> this.dataAccess.getInverseOf(property.getIri()).ifPresent(scndProp -> this.handleInverseOfConfig((Property)property, (IRI)scndProp)));
        this.props.values().stream().filter(Property::isShaclProperty).forEach(property -> this.dataAccess.getPropertyInverseInfos(property.getIri()).stream().filter(current -> Objects.equals(current.getPredicate(), property.getRdfPropIri())).findFirst().ifPresent(info -> this.handleInverseOfShaclConfig((Property)property, (PropertyInverseInfo)info)));
    }

    private void handleInverseOfConfig(Property property, IRI scndProp) {
        if (this.props.containsKey(scndProp)) {
            Property inverseOfProp = this.props.get(scndProp);
            property.setInverseOf(inverseOfProp);
            inverseOfProp.setInverseOf(property);
        } else {
            this.messages.add(Message.warning("'%s' is defined as inverseProp of '%s', but is no such property. Skipping the inverseOf statement", scndProp.stringValue(), property.getName()));
        }
    }

    private void handleInverseOfShaclConfig(Property property, PropertyInverseInfo info) {
        PropertyInverseInfo inverse = info.getInverse();
        Property inverseProp = this.props.get(inverse.getPropertyShape());
        if (inverseProp != null) {
            property.setInverseOf(inverseProp);
            inverseProp.setInverseOf(property);
        } else {
            inverseProp = this.props.get(inverse.getPredicate());
            if (inverseProp != null) {
                property.setInverseOf(inverseProp);
                inverseProp.setInverseOf(property);
            } else {
                this.messages.add(Message.warning("'%s' is defined as inversedProp of '%s', but is no such property. Skipping the inverseOf statement", info.getPredicate(), property.getName()));
            }
        }
    }

    private Set<Resource> findAllPropsInTheModel() {
        return this.dataAccess.findAllExplicitProperties();
    }

    public class Property
    implements Comparable<Property> {
        private final Resource iri;
        private Resource shaclIri;
        private String name;
        private final String shortIri;
        private String label;
        private String description;
        private String rdfProp;
        private IRI rdfPropIri;
        private boolean isTypeName;
        private String inverseAlias;
        private boolean complexPath;
        private boolean inversePath;
        private TreeSet<Integer> minSet;
        private TreeSet<Integer> maxSet;
        private Boolean symmetric;
        private String range;
        private IRI rangeClass;
        private IRI dataType;
        private final MultiTypeDef orDef = new MultiTypeDef();
        private final MultiTypeDef andDef = new MultiTypeDef();
        private Resource nodeRange;
        private Boolean forceRangeCheck;
        private String kind;
        private Property inverseOf;
        private Property primary;
        private Object lang;
        private Integer maxLength;
        private Integer minLength;
        private Object minInclusive;
        private Object maxInclusive;
        private Object minExclusive;
        private Object maxExclusive;
        private List<Object> valuesIn;
        private Boolean valuesListExclusive;
        private String pattern;
        private String flags;
        private String equals;
        private String defaultValue;
        private Boolean shaclProperty;
        private Set<Property> shaclProperties = new LinkedHashSet<Property>();
        private Property baseProperty;
        private final Map<IRI, List<Property>> references = new LinkedHashMap<IRI, List<Property>>();
        private Classes.Class domain;
        private boolean hidden;
        private Double order;
        private boolean restrictive;
        private boolean sparqlTemplate;

        Property(Resource iri) {
            this.iri = iri;
            this.shortIri = Properties.this.namespaces.shortIri(iri.stringValue());
            Properties.this.dataAccess.readPropertyName(this);
        }

        Property readMetadata() {
            Properties.this.dataAccess.readPropertyMetadata(this, Properties.this.ontology);
            return this;
        }

        Map<String, Object> somlObject() {
            TreeMap<String, Object> object = new TreeMap<String, Object>();
            Utils.putIfNotNull(object, "label", this.label);
            Utils.putIfNotNull(object, "descr", this.description);
            Utils.putIfNotNull(object, "rdfProp", this.rdfProp);
            Utils.putIfNotNull(object, "inverseAlias", this.inverseAlias);
            Utils.putIfNotNull(object, "min", this.getMin());
            Utils.putIfNotNull(object, "max", this.getMax());
            Utils.putIfNotNull(object, "symmetric", this.symmetric);
            Utils.putIfNotNull(object, "range", this.range);
            Utils.putIfNotNull(object, "kind", this.kind);
            Utils.putIfNotNull(object, "lang", this.lang);
            Utils.putIfNotNull(object, "minLength", this.minLength);
            Utils.putIfNotNull(object, "maxLength", this.maxLength);
            Utils.putIfNotNull(object, "minInclusive", this.minInclusive);
            Utils.putIfNotNull(object, "maxInclusive", this.maxInclusive);
            Utils.putIfNotNull(object, "minExclusive", this.minExclusive);
            Utils.putIfNotNull(object, "maxExclusive", this.maxExclusive);
            Utils.putIfNotNull(object, "valuesIn", this.valuesIn);
            Utils.putIfNotNull(object, "valuesListExclusive", this.valuesListExclusive);
            Utils.putIfNotNull(object, "pattern", this.pattern);
            Utils.putIfNotNull(object, "flags", this.flags);
            Utils.putIfNotNull(object, "equals", this.equals);
            Utils.putIfNotNull(object, "gen", this.defaultValue);
            if (this.inverseOf != null) {
                object.put("inverseOf", this.inverseOf.getName());
            }
            Utils.putIfNotNull(object, "rangeCheck", this.forceRangeCheck);
            if (this.order != null) {
                object.put("meta", Map.of("order", this.order));
            }
            if (this.restrictive) {
                object.put("restrictive", true);
            }
            return object;
        }

        public boolean isShaclProperty() {
            return Boolean.TRUE.equals(this.shaclProperty);
        }

        public void setShaclProperty(Boolean shaclProperty) {
            this.shaclProperty = shaclProperty;
        }

        public boolean isInlineShaclProperty() {
            return this.iri instanceof BNode;
        }

        public boolean isObjectPropertyKind() {
            return "object".equals(this.kind);
        }

        void validate(List<Message> messages) throws ConversionException {
            int max;
            int min;
            if (this.minSet != null && this.minSet.size() > 1) {
                messages.add(Message.warning("property.cardinality.ambiguous", "min", this.iri, this.minSet, this.getMin()));
            }
            if (this.maxSet != null && this.maxSet.size() > 1) {
                messages.add(Message.warning("property.cardinality.ambiguous", "max", this.iri, this.maxSet.stream().map(this::maxAsString).toList(), this.getMax()));
            }
            if (this.minSet != null && this.maxSet != null && (min = this.minSet.last().intValue()) > (max = this.maxSet.first().intValue())) {
                throw new ConversionException("property.cardinality.conflict", this.iri, min, max);
            }
        }

        public Resource getIri() {
            return this.iri;
        }

        public Resource getShaclIri() {
            return this.shaclIri;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getShortIri() {
            return this.shortIri;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setRdfProp(String rdfProp) {
            this.rdfProp = rdfProp;
        }

        public String getRdfProp() {
            return this.rdfProp;
        }

        public boolean isComplexPath() {
            return this.complexPath;
        }

        public void setComplexPath(boolean complexPath) {
            this.complexPath = complexPath;
        }

        public boolean isInversePath() {
            return this.inversePath;
        }

        public void setInversePath(boolean inversePath) {
            this.inversePath = inversePath;
        }

        public String getInverseAlias() {
            return this.inverseAlias;
        }

        public void setInverseAlias(String inverseAlias) {
            this.inverseAlias = inverseAlias;
            if (inverseAlias != null && this.inversePath) {
                this.setInverseOf(null);
            }
        }

        public void overrideMax(int max) {
            if (this.maxSet != null) {
                this.maxSet = null;
            }
            this.setMax(max);
        }

        public void setMax(int max) {
            if (this.maxSet == null) {
                this.maxSet = new TreeSet();
            }
            this.maxSet.add(max);
        }

        public Object getMax() {
            if (this.maxSet == null) {
                if (this.primary != null) {
                    return this.getPrimary().getMax();
                }
                return null;
            }
            int actualMap = this.maxSet.first();
            return this.maxAsString(actualMap);
        }

        private Object maxAsString(int value) {
            return value == Integer.MAX_VALUE ? "inf" : Integer.valueOf(value);
        }

        void setMin(int min) {
            if (this.minSet == null) {
                this.minSet = new TreeSet();
            }
            this.minSet.add(min);
        }

        public void overrideMin(int min) {
            if (this.minSet != null) {
                this.minSet = null;
            }
            this.setMin(min);
        }

        Integer getMin() {
            if (this.minSet == null) {
                if (this.primary != null) {
                    return this.getPrimary().getMin();
                }
                return null;
            }
            return this.minSet.last();
        }

        public void setSymmetric() {
            this.symmetric = Boolean.TRUE;
        }

        public String getRange() {
            return this.range;
        }

        public String getActualRange() {
            if (this.range == null) {
                return this.getPrimary().getRange();
            }
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public void setRange(String range, IRI rangeClass) {
            this.range = range;
            this.rangeClass = rangeClass;
        }

        public boolean isRangeIriOrString() {
            return "iri".equals(this.getRange()) || "string".equals(this.getRange());
        }

        public void setRangeClass(IRI rangeClass) {
            this.rangeClass = rangeClass;
        }

        public IRI getRangeClass() {
            return this.rangeClass;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public String getKind() {
            return this.kind;
        }

        public void setInverseOf(Property inverseOf) {
            this.inverseOf = inverseOf;
            if (inverseOf != null && !this.inversePath) {
                this.setInverseAlias(null);
            }
        }

        public String toString() {
            return this.name;
        }

        Property addReference(IRI domainId) {
            Property reference = new Property(this.iri).copyFrom(this);
            this.references.computeIfAbsent(domainId, id -> new LinkedList()).add(reference);
            return reference;
        }

        private Property copyFrom(Property property) {
            this.hidden = property.hidden;
            this.primary = property;
            this.order = property.order;
            this.shaclProperty = property.shaclProperty;
            this.baseProperty = property.baseProperty;
            this.shaclProperties = new LinkedHashSet<Property>(property.shaclProperties);
            return this;
        }

        Property addDirectReference(IRI domainId) {
            this.references.computeIfAbsent(domainId, id -> new LinkedList()).add(this);
            return this;
        }

        public Property addDomain(Classes.Class domain) {
            if (this.domain != null && this.domain != domain) {
                throw new IllegalArgumentException(String.valueOf(this) + " is already set as property for " + String.valueOf(this.domain) + ". Not allowed to add it to " + String.valueOf(domain) + " as well");
            }
            this.domain = domain;
            return this;
        }

        public Classes.Class getDomain() {
            return this.domain;
        }

        boolean isUsed() {
            return !this.references.isEmpty() && !this.isDirectlyReferenced();
        }

        public boolean isExcluded() {
            return this.testProperty(Properties.this.dataAccess.getConfig().isExcludedProp());
        }

        public boolean isProtected() {
            return Properties.this.ontology.isProtectedProperty(this);
        }

        public boolean isPrivate() {
            return Properties.this.ontology.isPrivateProperty(this);
        }

        private boolean testProperty(Predicate<Resource> test) {
            return test.test(this.iri) || this.shaclIri != null && this.shaclIri != this.iri && test.test(this.shaclIri);
        }

        public boolean isDirectlyReferenced() {
            return this.getReferences().values().stream().flatMap(Collection::stream).allMatch(prop -> prop == this);
        }

        public void setShaclIri(Resource shaclIri) {
            this.shaclIri = shaclIri;
        }

        public Map<IRI, List<Property>> getReferences() {
            return this.references;
        }

        public Property readShaclPredicates(Resource shaclId) {
            Properties.this.dataAccess.readShaclPropertyMetadata(this, shaclId, Properties.this.ontology);
            return this;
        }

        private String toSparqlTemplate(String pathValue) {
            return "?_subject " + pathValue + " ?_value";
        }

        public boolean isSparqlTemplate() {
            return this.sparqlTemplate || this.getRdfProp() != null && this.getRdfProp().contains("?");
        }

        public MultiTypeDef getOrDef() {
            return this.orDef;
        }

        public MultiTypeDef getAndDef() {
            return this.andDef;
        }

        public void setNodeRange(Resource nodeRange) {
            this.nodeRange = nodeRange;
        }

        public Resource getNodeRange() {
            return this.nodeRange;
        }

        public boolean isNodeRange() {
            return this.nodeRange != null;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden() {
            this.hidden = true;
        }

        Property getInverseOf() {
            return this.inverseOf;
        }

        Property getPrimary() {
            return Objects.requireNonNullElse(this.primary, this);
        }

        void convertInverseAliasToSparqlTemplate() {
            this.setRdfProp(this.toSparqlTemplate("^" + this.getInverseAlias()));
            this.setSparqlTemplate(true);
            this.setRdfPropIri(null);
            this.setInverseAlias(null);
            this.inversePath = false;
        }

        public double getOrder() {
            return Objects.requireNonNullElse(this.order, 1.0E7);
        }

        public void setOrder(Double order) {
            this.order = order;
        }

        public void setMinExclusive(Object minExclusive) {
            this.minExclusive = minExclusive;
        }

        public void setMaxExclusive(Object maxExclusive) {
            this.maxExclusive = maxExclusive;
        }

        public void setMaxInclusive(Object maxInclusive) {
            this.maxInclusive = maxInclusive;
        }

        public void setMinInclusive(Object minInclusive) {
            this.minInclusive = minInclusive;
        }

        public void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        public void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public void setValuesIn(List<Object> valuesIn) {
            this.valuesIn = valuesIn;
        }

        public void addValuesIn(Object value) {
            if (this.valuesIn == null) {
                this.valuesIn = new ArrayList<Object>();
            }
            this.valuesIn.add(value);
        }

        public void setValuesListExclusive(Boolean valuesListExclusive) {
            this.valuesListExclusive = valuesListExclusive;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setFlags(String flags) {
            this.flags = flags;
        }

        public void setEquals(String equals) {
            this.equals = equals;
        }

        public void setLang(Object lang) {
            this.lang = lang;
        }

        public void setIsTypeName(boolean isTypeName) {
            this.isTypeName = isTypeName;
        }

        public boolean isTypeName() {
            return this.isTypeName;
        }

        @Override
        public int compareTo(@NotNull Property other) {
            return new CompareToBuilder().append(this.getOrder(), other.getOrder()).append((Object)this.getName(), (Object)other.getName()).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property property = (Property)obj;
            return this.iri.equals((Object)property.iri) && Objects.equals(this.name, property.name) && Objects.equals(this.order, property.order);
        }

        public int hashCode() {
            return Objects.hash(this.iri, this.name, this.order);
        }

        public void setAsProtected() {
            Property inverseOfProp = this.getInverseOf();
            if (inverseOfProp != null) {
                inverseOfProp.setInverseOf(null);
            }
            this.setInverseOf(null);
            this.setRange("iri");
            if (this.primary != null) {
                this.primary.setAsProtected();
            }
        }

        public Property deepCopy() {
            return this.copy().mergePropertyFrom(this).mergePropertyFrom(this.getPrimary());
        }

        public Property copy() {
            return new Property(this.getIri()).mergePropertyFrom(this);
        }

        Property mergePropertyFrom(Property property) {
            this.name = (String)ObjectsUtil.getOrDefault((Object)this.name, (Object)property.name);
            this.range = (String)ObjectsUtil.getOrDefault((Object)this.range, (Object)property.range);
            this.rangeClass = (IRI)ObjectsUtil.getOrDefault((Object)this.rangeClass, (Object)property.rangeClass);
            this.rdfProp = (String)ObjectsUtil.getOrDefault((Object)this.rdfProp, (Object)property.rdfProp);
            this.rdfPropIri = (IRI)ObjectsUtil.getOrDefault((Object)this.rdfPropIri, (Object)property.rdfPropIri);
            if (property.isTypeName) {
                this.isTypeName = true;
            }
            this.mergeGenericCharacteristicsFrom(property);
            this.mergeShaclCharacteristicsFrom(property);
            return this;
        }

        void mergeGenericCharacteristicsFrom(Property property) {
            this.label = (String)ObjectsUtil.getOrDefault((Object)this.getLabel(), (Object)property.getLabel());
            this.description = (String)ObjectsUtil.getOrDefault((Object)this.description, (Object)property.description);
            this.inverseAlias = (String)ObjectsUtil.getOrDefault((Object)this.inverseAlias, (Object)property.inverseAlias);
            this.symmetric = (Boolean)ObjectsUtil.getOrDefault((Object)this.symmetric, (Object)property.symmetric);
            this.orDef.copyFrom(property.orDef);
            this.andDef.copyFrom(property.andDef);
            this.nodeRange = (Resource)ObjectsUtil.getOrDefault((Object)this.nodeRange, (Object)property.nodeRange);
            this.kind = (String)ObjectsUtil.getOrDefault((Object)this.kind, (Object)property.kind);
            this.lang = ObjectsUtil.getOrDefault((Object)this.lang, (Object)property.lang);
            this.order = (Double)ObjectsUtil.getOrDefault((Object)this.order, (Object)property.order);
            this.forceRangeCheck = (Boolean)ObjectsUtil.getOrDefault((Object)this.forceRangeCheck, (Object)property.forceRangeCheck);
        }

        void mergeShaclCharacteristicsFrom(Property property) {
            this.maxLength = (Integer)ObjectsUtil.getOrDefault((Object)this.maxLength, (Object)property.maxLength);
            this.minLength = (Integer)ObjectsUtil.getOrDefault((Object)this.minLength, (Object)property.minLength);
            this.minInclusive = ObjectsUtil.getOrDefault((Object)this.minInclusive, (Object)property.minInclusive);
            this.maxInclusive = ObjectsUtil.getOrDefault((Object)this.maxInclusive, (Object)property.maxInclusive);
            this.minExclusive = ObjectsUtil.getOrDefault((Object)this.minExclusive, (Object)property.minExclusive);
            this.maxExclusive = ObjectsUtil.getOrDefault((Object)this.maxExclusive, (Object)property.maxExclusive);
            this.valuesIn = (List)ObjectsUtil.getOrDefault(this.valuesIn, (Object)(property.valuesIn == null ? null : new ArrayList<Object>(property.valuesIn)));
            this.valuesListExclusive = (Boolean)ObjectsUtil.getOrDefault((Object)this.valuesListExclusive, (Object)property.valuesListExclusive);
            this.pattern = (String)ObjectsUtil.getOrDefault((Object)this.pattern, (Object)property.pattern);
            this.flags = (String)ObjectsUtil.getOrDefault((Object)this.flags, (Object)property.flags);
            this.equals = (String)ObjectsUtil.getOrDefault((Object)this.equals, (Object)property.equals);
            this.complexPath = property.complexPath;
            this.inversePath = property.inversePath;
            this.inverseOf = (Property)ObjectsUtil.getOrDefault((Object)this.inverseOf, (Object)property.inverseOf);
            this.defaultValue = (String)ObjectsUtil.getOrDefault((Object)this.defaultValue, (Object)property.defaultValue);
        }

        public void setForceRangeCheck() {
            this.forceRangeCheck = Boolean.TRUE;
        }

        public void addShaclProperty(Property shaclProp) {
            this.shaclProperties.add(shaclProp);
            shaclProp.setBaseProperty(this);
        }

        private void setBaseProperty(Property baseProperty) {
            this.baseProperty = baseProperty;
        }

        public Property getBaseProperty() {
            if (this.baseProperty == null) {
                return this;
            }
            return this.baseProperty;
        }

        public Set<Property> getShaclProperties() {
            return this.shaclProperties;
        }

        public IRI getRdfPropIri() {
            return this.rdfPropIri;
        }

        public void setRdfPropIri(IRI rdfPropIri) {
            this.rdfPropIri = rdfPropIri;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setRestrictive(boolean restrictive) {
            this.restrictive = restrictive;
        }

        public boolean isRestrictive() {
            return this.restrictive;
        }

        public void setSparqlTemplate(boolean template) {
            this.sparqlTemplate = template;
        }
    }
}

